/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHostKeyResponse extends TransferResponse implements
        ToCopyableBuilder<UpdateHostKeyResponse.Builder, UpdateHostKeyResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(UpdateHostKeyResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> HOST_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostKeyId").getter(getter(UpdateHostKeyResponse::hostKeyId)).setter(setter(Builder::hostKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            HOST_KEY_ID_FIELD));

    private final String serverId;

    private final String hostKeyId;

    private UpdateHostKeyResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.hostKeyId = builder.hostKeyId;
    }

    /**
     * <p>
     * Returns the server identifier for the server that contains the updated host key.
     * </p>
     * 
     * @return Returns the server identifier for the server that contains the updated host key.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * <p>
     * Returns the host key identifier for the updated host key.
     * </p>
     * 
     * @return Returns the host key identifier for the updated host key.
     */
    public final String hostKeyId() {
        return hostKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(hostKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHostKeyResponse)) {
            return false;
        }
        UpdateHostKeyResponse other = (UpdateHostKeyResponse) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(hostKeyId(), other.hostKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHostKeyResponse").add("ServerId", serverId()).add("HostKeyId", hostKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "HostKeyId":
            return Optional.ofNullable(clazz.cast(hostKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHostKeyResponse, T> g) {
        return obj -> g.apply((UpdateHostKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHostKeyResponse> {
        /**
         * <p>
         * Returns the server identifier for the server that contains the updated host key.
         * </p>
         * 
         * @param serverId
         *        Returns the server identifier for the server that contains the updated host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * Returns the host key identifier for the updated host key.
         * </p>
         * 
         * @param hostKeyId
         *        Returns the host key identifier for the updated host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKeyId(String hostKeyId);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String serverId;

        private String hostKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHostKeyResponse model) {
            super(model);
            serverId(model.serverId);
            hostKeyId(model.hostKeyId);
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final String getHostKeyId() {
            return hostKeyId;
        }

        public final void setHostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
        }

        @Override
        public final Builder hostKeyId(String hostKeyId) {
            this.hostKeyId = hostKeyId;
            return this;
        }

        @Override
        public UpdateHostKeyResponse build() {
            return new UpdateHostKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
