/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartFileTransferRequest extends TransferRequest implements
        ToCopyableBuilder<StartFileTransferRequest.Builder, StartFileTransferRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorId").getter(getter(StartFileTransferRequest::connectorId)).setter(setter(Builder::connectorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorId").build()).build();

    private static final SdkField<List<String>> SEND_FILE_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SendFilePaths")
            .getter(getter(StartFileTransferRequest::sendFilePaths))
            .setter(setter(Builder::sendFilePaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SendFilePaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RETRIEVE_FILE_PATHS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RetrieveFilePaths")
            .getter(getter(StartFileTransferRequest::retrieveFilePaths))
            .setter(setter(Builder::retrieveFilePaths))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrieveFilePaths").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCAL_DIRECTORY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalDirectoryPath").getter(getter(StartFileTransferRequest::localDirectoryPath))
            .setter(setter(Builder::localDirectoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalDirectoryPath").build())
            .build();

    private static final SdkField<String> REMOTE_DIRECTORY_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemoteDirectoryPath").getter(getter(StartFileTransferRequest::remoteDirectoryPath))
            .setter(setter(Builder::remoteDirectoryPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDirectoryPath").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD,
            SEND_FILE_PATHS_FIELD, RETRIEVE_FILE_PATHS_FIELD, LOCAL_DIRECTORY_PATH_FIELD, REMOTE_DIRECTORY_PATH_FIELD));

    private final String connectorId;

    private final List<String> sendFilePaths;

    private final List<String> retrieveFilePaths;

    private final String localDirectoryPath;

    private final String remoteDirectoryPath;

    private StartFileTransferRequest(BuilderImpl builder) {
        super(builder);
        this.connectorId = builder.connectorId;
        this.sendFilePaths = builder.sendFilePaths;
        this.retrieveFilePaths = builder.retrieveFilePaths;
        this.localDirectoryPath = builder.localDirectoryPath;
        this.remoteDirectoryPath = builder.remoteDirectoryPath;
    }

    /**
     * <p>
     * The unique identifier for the connector.
     * </p>
     * 
     * @return The unique identifier for the connector.
     */
    public final String connectorId() {
        return connectorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SendFilePaths property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSendFilePaths() {
        return sendFilePaths != null && !(sendFilePaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more source paths for the Amazon S3 storage. Each string represents a source file path for one outbound
     * file transfer. For example, <code> <i>DOC-EXAMPLE-BUCKET</i>/<i>myfile.txt</i> </code>.
     * </p>
     * <note>
     * <p>
     * Replace <code> <i>DOC-EXAMPLE-BUCKET</i> </code> with one of your actual buckets.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSendFilePaths} method.
     * </p>
     * 
     * @return One or more source paths for the Amazon S3 storage. Each string represents a source file path for one
     *         outbound file transfer. For example, <code> <i>DOC-EXAMPLE-BUCKET</i>/<i>myfile.txt</i> </code>.</p>
     *         <note>
     *         <p>
     *         Replace <code> <i>DOC-EXAMPLE-BUCKET</i> </code> with one of your actual buckets.
     *         </p>
     */
    public final List<String> sendFilePaths() {
        return sendFilePaths;
    }

    /**
     * For responses, this returns true if the service returned a value for the RetrieveFilePaths property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRetrieveFilePaths() {
        return retrieveFilePaths != null && !(retrieveFilePaths instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more source paths for the partner's SFTP server. Each string represents a source file path for one inbound
     * file transfer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRetrieveFilePaths} method.
     * </p>
     * 
     * @return One or more source paths for the partner's SFTP server. Each string represents a source file path for one
     *         inbound file transfer.
     */
    public final List<String> retrieveFilePaths() {
        return retrieveFilePaths;
    }

    /**
     * <p>
     * For an inbound transfer, the <code>LocaDirectoryPath</code> specifies the destination for one or more files that
     * are transferred from the partner's SFTP server.
     * </p>
     * 
     * @return For an inbound transfer, the <code>LocaDirectoryPath</code> specifies the destination for one or more
     *         files that are transferred from the partner's SFTP server.
     */
    public final String localDirectoryPath() {
        return localDirectoryPath;
    }

    /**
     * <p>
     * For an outbound transfer, the <code>RemoteDirectoryPath</code> specifies the destination for one or more files
     * that are transferred to the partner's SFTP server. If you don't specify a <code>RemoteDirectoryPath</code>, the
     * destination for transferred files is the SFTP user's home directory.
     * </p>
     * 
     * @return For an outbound transfer, the <code>RemoteDirectoryPath</code> specifies the destination for one or more
     *         files that are transferred to the partner's SFTP server. If you don't specify a
     *         <code>RemoteDirectoryPath</code>, the destination for transferred files is the SFTP user's home
     *         directory.
     */
    public final String remoteDirectoryPath() {
        return remoteDirectoryPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSendFilePaths() ? sendFilePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRetrieveFilePaths() ? retrieveFilePaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(localDirectoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDirectoryPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartFileTransferRequest)) {
            return false;
        }
        StartFileTransferRequest other = (StartFileTransferRequest) obj;
        return Objects.equals(connectorId(), other.connectorId()) && hasSendFilePaths() == other.hasSendFilePaths()
                && Objects.equals(sendFilePaths(), other.sendFilePaths())
                && hasRetrieveFilePaths() == other.hasRetrieveFilePaths()
                && Objects.equals(retrieveFilePaths(), other.retrieveFilePaths())
                && Objects.equals(localDirectoryPath(), other.localDirectoryPath())
                && Objects.equals(remoteDirectoryPath(), other.remoteDirectoryPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartFileTransferRequest").add("ConnectorId", connectorId())
                .add("SendFilePaths", hasSendFilePaths() ? sendFilePaths() : null)
                .add("RetrieveFilePaths", hasRetrieveFilePaths() ? retrieveFilePaths() : null)
                .add("LocalDirectoryPath", localDirectoryPath()).add("RemoteDirectoryPath", remoteDirectoryPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorId":
            return Optional.ofNullable(clazz.cast(connectorId()));
        case "SendFilePaths":
            return Optional.ofNullable(clazz.cast(sendFilePaths()));
        case "RetrieveFilePaths":
            return Optional.ofNullable(clazz.cast(retrieveFilePaths()));
        case "LocalDirectoryPath":
            return Optional.ofNullable(clazz.cast(localDirectoryPath()));
        case "RemoteDirectoryPath":
            return Optional.ofNullable(clazz.cast(remoteDirectoryPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartFileTransferRequest, T> g) {
        return obj -> g.apply((StartFileTransferRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartFileTransferRequest> {
        /**
         * <p>
         * The unique identifier for the connector.
         * </p>
         * 
         * @param connectorId
         *        The unique identifier for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorId(String connectorId);

        /**
         * <p>
         * One or more source paths for the Amazon S3 storage. Each string represents a source file path for one
         * outbound file transfer. For example, <code> <i>DOC-EXAMPLE-BUCKET</i>/<i>myfile.txt</i> </code>.
         * </p>
         * <note>
         * <p>
         * Replace <code> <i>DOC-EXAMPLE-BUCKET</i> </code> with one of your actual buckets.
         * </p>
         * </note>
         * 
         * @param sendFilePaths
         *        One or more source paths for the Amazon S3 storage. Each string represents a source file path for one
         *        outbound file transfer. For example, <code> <i>DOC-EXAMPLE-BUCKET</i>/<i>myfile.txt</i> </code>.</p>
         *        <note>
         *        <p>
         *        Replace <code> <i>DOC-EXAMPLE-BUCKET</i> </code> with one of your actual buckets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendFilePaths(Collection<String> sendFilePaths);

        /**
         * <p>
         * One or more source paths for the Amazon S3 storage. Each string represents a source file path for one
         * outbound file transfer. For example, <code> <i>DOC-EXAMPLE-BUCKET</i>/<i>myfile.txt</i> </code>.
         * </p>
         * <note>
         * <p>
         * Replace <code> <i>DOC-EXAMPLE-BUCKET</i> </code> with one of your actual buckets.
         * </p>
         * </note>
         * 
         * @param sendFilePaths
         *        One or more source paths for the Amazon S3 storage. Each string represents a source file path for one
         *        outbound file transfer. For example, <code> <i>DOC-EXAMPLE-BUCKET</i>/<i>myfile.txt</i> </code>.</p>
         *        <note>
         *        <p>
         *        Replace <code> <i>DOC-EXAMPLE-BUCKET</i> </code> with one of your actual buckets.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sendFilePaths(String... sendFilePaths);

        /**
         * <p>
         * One or more source paths for the partner's SFTP server. Each string represents a source file path for one
         * inbound file transfer.
         * </p>
         * 
         * @param retrieveFilePaths
         *        One or more source paths for the partner's SFTP server. Each string represents a source file path for
         *        one inbound file transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveFilePaths(Collection<String> retrieveFilePaths);

        /**
         * <p>
         * One or more source paths for the partner's SFTP server. Each string represents a source file path for one
         * inbound file transfer.
         * </p>
         * 
         * @param retrieveFilePaths
         *        One or more source paths for the partner's SFTP server. Each string represents a source file path for
         *        one inbound file transfer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveFilePaths(String... retrieveFilePaths);

        /**
         * <p>
         * For an inbound transfer, the <code>LocaDirectoryPath</code> specifies the destination for one or more files
         * that are transferred from the partner's SFTP server.
         * </p>
         * 
         * @param localDirectoryPath
         *        For an inbound transfer, the <code>LocaDirectoryPath</code> specifies the destination for one or more
         *        files that are transferred from the partner's SFTP server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localDirectoryPath(String localDirectoryPath);

        /**
         * <p>
         * For an outbound transfer, the <code>RemoteDirectoryPath</code> specifies the destination for one or more
         * files that are transferred to the partner's SFTP server. If you don't specify a
         * <code>RemoteDirectoryPath</code>, the destination for transferred files is the SFTP user's home directory.
         * </p>
         * 
         * @param remoteDirectoryPath
         *        For an outbound transfer, the <code>RemoteDirectoryPath</code> specifies the destination for one or
         *        more files that are transferred to the partner's SFTP server. If you don't specify a
         *        <code>RemoteDirectoryPath</code>, the destination for transferred files is the SFTP user's home
         *        directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDirectoryPath(String remoteDirectoryPath);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String connectorId;

        private List<String> sendFilePaths = DefaultSdkAutoConstructList.getInstance();

        private List<String> retrieveFilePaths = DefaultSdkAutoConstructList.getInstance();

        private String localDirectoryPath;

        private String remoteDirectoryPath;

        private BuilderImpl() {
        }

        private BuilderImpl(StartFileTransferRequest model) {
            super(model);
            connectorId(model.connectorId);
            sendFilePaths(model.sendFilePaths);
            retrieveFilePaths(model.retrieveFilePaths);
            localDirectoryPath(model.localDirectoryPath);
            remoteDirectoryPath(model.remoteDirectoryPath);
        }

        public final String getConnectorId() {
            return connectorId;
        }

        public final void setConnectorId(String connectorId) {
            this.connectorId = connectorId;
        }

        @Override
        public final Builder connectorId(String connectorId) {
            this.connectorId = connectorId;
            return this;
        }

        public final Collection<String> getSendFilePaths() {
            if (sendFilePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return sendFilePaths;
        }

        public final void setSendFilePaths(Collection<String> sendFilePaths) {
            this.sendFilePaths = FilePathsCopier.copy(sendFilePaths);
        }

        @Override
        public final Builder sendFilePaths(Collection<String> sendFilePaths) {
            this.sendFilePaths = FilePathsCopier.copy(sendFilePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sendFilePaths(String... sendFilePaths) {
            sendFilePaths(Arrays.asList(sendFilePaths));
            return this;
        }

        public final Collection<String> getRetrieveFilePaths() {
            if (retrieveFilePaths instanceof SdkAutoConstructList) {
                return null;
            }
            return retrieveFilePaths;
        }

        public final void setRetrieveFilePaths(Collection<String> retrieveFilePaths) {
            this.retrieveFilePaths = FilePathsCopier.copy(retrieveFilePaths);
        }

        @Override
        public final Builder retrieveFilePaths(Collection<String> retrieveFilePaths) {
            this.retrieveFilePaths = FilePathsCopier.copy(retrieveFilePaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrieveFilePaths(String... retrieveFilePaths) {
            retrieveFilePaths(Arrays.asList(retrieveFilePaths));
            return this;
        }

        public final String getLocalDirectoryPath() {
            return localDirectoryPath;
        }

        public final void setLocalDirectoryPath(String localDirectoryPath) {
            this.localDirectoryPath = localDirectoryPath;
        }

        @Override
        public final Builder localDirectoryPath(String localDirectoryPath) {
            this.localDirectoryPath = localDirectoryPath;
            return this;
        }

        public final String getRemoteDirectoryPath() {
            return remoteDirectoryPath;
        }

        public final void setRemoteDirectoryPath(String remoteDirectoryPath) {
            this.remoteDirectoryPath = remoteDirectoryPath;
        }

        @Override
        public final Builder remoteDirectoryPath(String remoteDirectoryPath) {
            this.remoteDirectoryPath = remoteDirectoryPath;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartFileTransferRequest build() {
            return new StartFileTransferRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
