/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transfer.TransferClient;
import software.amazon.awssdk.services.transfer.model.ListServersRequest;
import software.amazon.awssdk.services.transfer.model.ListServersResponse;

public class ListServersIterable
implements SdkIterable<ListServersResponse> {
    private final TransferClient client;
    private final ListServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServersIterable(TransferClient client, ListServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListServersResponseFetcher();
    }

    public Iterator<ListServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListServersResponseFetcher
    implements SyncPageFetcher<ListServersResponse> {
        private ListServersResponseFetcher() {
        }

        public boolean hasNextPage(ListServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServersResponse nextPage(ListServersResponse previousPage) {
            if (previousPage == null) {
                return ListServersIterable.this.client.listServers(ListServersIterable.this.firstRequest);
            }
            return ListServersIterable.this.client.listServers((ListServersRequest)((Object)ListServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

