/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MediaFormat {
    MP3("mp3"),
    MP4("mp4"),
    WAV("wav"),
    FLAC("flac"),
    OGG("ogg"),
    AMR("amr"),
    WEBM("webm"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MediaFormat> VALUE_MAP;
    private final String value;

    private MediaFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MediaFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MediaFormat> knownValues() {
        EnumSet<MediaFormat> knownValues = EnumSet.allOf(MediaFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MediaFormat.class, MediaFormat::toString);
    }
}

