/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RedactionType {
    PII("PII"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RedactionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RedactionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RedactionType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RedactionType> knownValues() {
        return Stream.of(RedactionType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

