/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3EncryptionOption {
    SSE_S3("SSE_S3"),
    SSE_KMS("SSE_KMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3EncryptionOption> VALUE_MAP;
    private final String value;

    private S3EncryptionOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3EncryptionOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3EncryptionOption> knownValues() {
        EnumSet<S3EncryptionOption> knownValues = EnumSet.allOf(S3EncryptionOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3EncryptionOption.class, S3EncryptionOption::toString);
    }
}

