/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.timestreamquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MeasureValueType {
    BIGINT("BIGINT"),
    BOOLEAN("BOOLEAN"),
    DOUBLE("DOUBLE"),
    VARCHAR("VARCHAR"),
    MULTI("MULTI"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MeasureValueType> VALUE_MAP;
    private final String value;

    private MeasureValueType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MeasureValueType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MeasureValueType> knownValues() {
        EnumSet<MeasureValueType> knownValues = EnumSet.allOf(MeasureValueType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MeasureValueType.class, MeasureValueType::toString);
    }
}

