/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Destination details to write data for a target data source. Current supported data source is Timestream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetDestination.Builder, TargetDestination> {
    private static final SdkField<TimestreamDestination> TIMESTREAM_DESTINATION_FIELD = SdkField
            .<TimestreamDestination> builder(MarshallingType.SDK_POJO).memberName("TimestreamDestination")
            .getter(getter(TargetDestination::timestreamDestination)).setter(setter(Builder::timestreamDestination))
            .constructor(TimestreamDestination::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestreamDestination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTREAM_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final TimestreamDestination timestreamDestination;

    private TargetDestination(BuilderImpl builder) {
        this.timestreamDestination = builder.timestreamDestination;
    }

    /**
     * <p>
     * Query result destination details for Timestream data source.
     * </p>
     * 
     * @return Query result destination details for Timestream data source.
     */
    public final TimestreamDestination timestreamDestination() {
        return timestreamDestination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestreamDestination());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetDestination)) {
            return false;
        }
        TargetDestination other = (TargetDestination) obj;
        return Objects.equals(timestreamDestination(), other.timestreamDestination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetDestination").add("TimestreamDestination", timestreamDestination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimestreamDestination":
            return Optional.ofNullable(clazz.cast(timestreamDestination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetDestination, T> g) {
        return obj -> g.apply((TargetDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetDestination> {
        /**
         * <p>
         * Query result destination details for Timestream data source.
         * </p>
         * 
         * @param timestreamDestination
         *        Query result destination details for Timestream data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestreamDestination(TimestreamDestination timestreamDestination);

        /**
         * <p>
         * Query result destination details for Timestream data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestreamDestination.Builder} avoiding
         * the need to create one manually via {@link TimestreamDestination#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestreamDestination.Builder#build()} is called immediately and
         * its result is passed to {@link #timestreamDestination(TimestreamDestination)}.
         * 
         * @param timestreamDestination
         *        a consumer that will call methods on {@link TimestreamDestination.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestreamDestination(TimestreamDestination)
         */
        default Builder timestreamDestination(Consumer<TimestreamDestination.Builder> timestreamDestination) {
            return timestreamDestination(TimestreamDestination.builder().applyMutation(timestreamDestination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TimestreamDestination timestreamDestination;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetDestination model) {
            timestreamDestination(model.timestreamDestination);
        }

        public final TimestreamDestination.Builder getTimestreamDestination() {
            return timestreamDestination != null ? timestreamDestination.toBuilder() : null;
        }

        public final void setTimestreamDestination(TimestreamDestination.BuilderImpl timestreamDestination) {
            this.timestreamDestination = timestreamDestination != null ? timestreamDestination.build() : null;
        }

        @Override
        public final Builder timestreamDestination(TimestreamDestination timestreamDestination) {
            this.timestreamDestination = timestreamDestination;
            return this;
        }

        @Override
        public TargetDestination build() {
            return new TargetDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
