/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Run summary for the scheduled query
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledQueryRunSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledQueryRunSummary.Builder, ScheduledQueryRunSummary> {
    private static final SdkField<Instant> INVOCATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvocationTime").getter(getter(ScheduledQueryRunSummary::invocationTime))
            .setter(setter(Builder::invocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationTime").build()).build();

    private static final SdkField<Instant> TRIGGER_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TriggerTime").getter(getter(ScheduledQueryRunSummary::triggerTime)).setter(setter(Builder::triggerTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerTime").build()).build();

    private static final SdkField<String> RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RunStatus").getter(getter(ScheduledQueryRunSummary::runStatusAsString))
            .setter(setter(Builder::runStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunStatus").build()).build();

    private static final SdkField<ExecutionStats> EXECUTION_STATS_FIELD = SdkField
            .<ExecutionStats> builder(MarshallingType.SDK_POJO).memberName("ExecutionStats")
            .getter(getter(ScheduledQueryRunSummary::executionStats)).setter(setter(Builder::executionStats))
            .constructor(ExecutionStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStats").build()).build();

    private static final SdkField<ErrorReportLocation> ERROR_REPORT_LOCATION_FIELD = SdkField
            .<ErrorReportLocation> builder(MarshallingType.SDK_POJO).memberName("ErrorReportLocation")
            .getter(getter(ScheduledQueryRunSummary::errorReportLocation)).setter(setter(Builder::errorReportLocation))
            .constructor(ErrorReportLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReportLocation").build())
            .build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(ScheduledQueryRunSummary::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_TIME_FIELD,
            TRIGGER_TIME_FIELD, RUN_STATUS_FIELD, EXECUTION_STATS_FIELD, ERROR_REPORT_LOCATION_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant invocationTime;

    private final Instant triggerTime;

    private final String runStatus;

    private final ExecutionStats executionStats;

    private final ErrorReportLocation errorReportLocation;

    private final String failureReason;

    private ScheduledQueryRunSummary(BuilderImpl builder) {
        this.invocationTime = builder.invocationTime;
        this.triggerTime = builder.triggerTime;
        this.runStatus = builder.runStatus;
        this.executionStats = builder.executionStats;
        this.errorReportLocation = builder.errorReportLocation;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * InvocationTime for this run. This is the time at which the query is scheduled to run. Parameter
     * <code>@scheduled_runtime</code> can be used in the query to get the value.
     * </p>
     * 
     * @return InvocationTime for this run. This is the time at which the query is scheduled to run. Parameter
     *         <code>@scheduled_runtime</code> can be used in the query to get the value.
     */
    public final Instant invocationTime() {
        return invocationTime;
    }

    /**
     * <p>
     * The actual time when the query was run.
     * </p>
     * 
     * @return The actual time when the query was run.
     */
    public final Instant triggerTime() {
        return triggerTime;
    }

    /**
     * <p>
     * The status of a scheduled query run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runStatus} will
     * return {@link ScheduledQueryRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #runStatusAsString}.
     * </p>
     * 
     * @return The status of a scheduled query run.
     * @see ScheduledQueryRunStatus
     */
    public final ScheduledQueryRunStatus runStatus() {
        return ScheduledQueryRunStatus.fromValue(runStatus);
    }

    /**
     * <p>
     * The status of a scheduled query run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runStatus} will
     * return {@link ScheduledQueryRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #runStatusAsString}.
     * </p>
     * 
     * @return The status of a scheduled query run.
     * @see ScheduledQueryRunStatus
     */
    public final String runStatusAsString() {
        return runStatus;
    }

    /**
     * <p>
     * Runtime statistics for a scheduled run.
     * </p>
     * 
     * @return Runtime statistics for a scheduled run.
     */
    public final ExecutionStats executionStats() {
        return executionStats;
    }

    /**
     * <p>
     * S3 location for error report.
     * </p>
     * 
     * @return S3 location for error report.
     */
    public final ErrorReportLocation errorReportLocation() {
        return errorReportLocation;
    }

    /**
     * <p>
     * Error message for the scheduled query in case of failure. You might have to look at the error report to get more
     * detailed error reasons.
     * </p>
     * 
     * @return Error message for the scheduled query in case of failure. You might have to look at the error report to
     *         get more detailed error reasons.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(triggerTime());
        hashCode = 31 * hashCode + Objects.hashCode(runStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionStats());
        hashCode = 31 * hashCode + Objects.hashCode(errorReportLocation());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledQueryRunSummary)) {
            return false;
        }
        ScheduledQueryRunSummary other = (ScheduledQueryRunSummary) obj;
        return Objects.equals(invocationTime(), other.invocationTime()) && Objects.equals(triggerTime(), other.triggerTime())
                && Objects.equals(runStatusAsString(), other.runStatusAsString())
                && Objects.equals(executionStats(), other.executionStats())
                && Objects.equals(errorReportLocation(), other.errorReportLocation())
                && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledQueryRunSummary").add("InvocationTime", invocationTime())
                .add("TriggerTime", triggerTime()).add("RunStatus", runStatusAsString()).add("ExecutionStats", executionStats())
                .add("ErrorReportLocation", errorReportLocation()).add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvocationTime":
            return Optional.ofNullable(clazz.cast(invocationTime()));
        case "TriggerTime":
            return Optional.ofNullable(clazz.cast(triggerTime()));
        case "RunStatus":
            return Optional.ofNullable(clazz.cast(runStatusAsString()));
        case "ExecutionStats":
            return Optional.ofNullable(clazz.cast(executionStats()));
        case "ErrorReportLocation":
            return Optional.ofNullable(clazz.cast(errorReportLocation()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledQueryRunSummary, T> g) {
        return obj -> g.apply((ScheduledQueryRunSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledQueryRunSummary> {
        /**
         * <p>
         * InvocationTime for this run. This is the time at which the query is scheduled to run. Parameter
         * <code>@scheduled_runtime</code> can be used in the query to get the value.
         * </p>
         * 
         * @param invocationTime
         *        InvocationTime for this run. This is the time at which the query is scheduled to run. Parameter
         *        <code>@scheduled_runtime</code> can be used in the query to get the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationTime(Instant invocationTime);

        /**
         * <p>
         * The actual time when the query was run.
         * </p>
         * 
         * @param triggerTime
         *        The actual time when the query was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerTime(Instant triggerTime);

        /**
         * <p>
         * The status of a scheduled query run.
         * </p>
         * 
         * @param runStatus
         *        The status of a scheduled query run.
         * @see ScheduledQueryRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryRunStatus
         */
        Builder runStatus(String runStatus);

        /**
         * <p>
         * The status of a scheduled query run.
         * </p>
         * 
         * @param runStatus
         *        The status of a scheduled query run.
         * @see ScheduledQueryRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledQueryRunStatus
         */
        Builder runStatus(ScheduledQueryRunStatus runStatus);

        /**
         * <p>
         * Runtime statistics for a scheduled run.
         * </p>
         * 
         * @param executionStats
         *        Runtime statistics for a scheduled run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStats(ExecutionStats executionStats);

        /**
         * <p>
         * Runtime statistics for a scheduled run.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionStats.Builder} avoiding the need
         * to create one manually via {@link ExecutionStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionStats.Builder#build()} is called immediately and its
         * result is passed to {@link #executionStats(ExecutionStats)}.
         * 
         * @param executionStats
         *        a consumer that will call methods on {@link ExecutionStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionStats(ExecutionStats)
         */
        default Builder executionStats(Consumer<ExecutionStats.Builder> executionStats) {
            return executionStats(ExecutionStats.builder().applyMutation(executionStats).build());
        }

        /**
         * <p>
         * S3 location for error report.
         * </p>
         * 
         * @param errorReportLocation
         *        S3 location for error report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReportLocation(ErrorReportLocation errorReportLocation);

        /**
         * <p>
         * S3 location for error report.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorReportLocation.Builder} avoiding the
         * need to create one manually via {@link ErrorReportLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorReportLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #errorReportLocation(ErrorReportLocation)}.
         * 
         * @param errorReportLocation
         *        a consumer that will call methods on {@link ErrorReportLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorReportLocation(ErrorReportLocation)
         */
        default Builder errorReportLocation(Consumer<ErrorReportLocation.Builder> errorReportLocation) {
            return errorReportLocation(ErrorReportLocation.builder().applyMutation(errorReportLocation).build());
        }

        /**
         * <p>
         * Error message for the scheduled query in case of failure. You might have to look at the error report to get
         * more detailed error reasons.
         * </p>
         * 
         * @param failureReason
         *        Error message for the scheduled query in case of failure. You might have to look at the error report
         *        to get more detailed error reasons.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private Instant invocationTime;

        private Instant triggerTime;

        private String runStatus;

        private ExecutionStats executionStats;

        private ErrorReportLocation errorReportLocation;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledQueryRunSummary model) {
            invocationTime(model.invocationTime);
            triggerTime(model.triggerTime);
            runStatus(model.runStatus);
            executionStats(model.executionStats);
            errorReportLocation(model.errorReportLocation);
            failureReason(model.failureReason);
        }

        public final Instant getInvocationTime() {
            return invocationTime;
        }

        public final void setInvocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
        }

        @Override
        public final Builder invocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
            return this;
        }

        public final Instant getTriggerTime() {
            return triggerTime;
        }

        public final void setTriggerTime(Instant triggerTime) {
            this.triggerTime = triggerTime;
        }

        @Override
        public final Builder triggerTime(Instant triggerTime) {
            this.triggerTime = triggerTime;
            return this;
        }

        public final String getRunStatus() {
            return runStatus;
        }

        public final void setRunStatus(String runStatus) {
            this.runStatus = runStatus;
        }

        @Override
        public final Builder runStatus(String runStatus) {
            this.runStatus = runStatus;
            return this;
        }

        @Override
        public final Builder runStatus(ScheduledQueryRunStatus runStatus) {
            this.runStatus(runStatus == null ? null : runStatus.toString());
            return this;
        }

        public final ExecutionStats.Builder getExecutionStats() {
            return executionStats != null ? executionStats.toBuilder() : null;
        }

        public final void setExecutionStats(ExecutionStats.BuilderImpl executionStats) {
            this.executionStats = executionStats != null ? executionStats.build() : null;
        }

        @Override
        public final Builder executionStats(ExecutionStats executionStats) {
            this.executionStats = executionStats;
            return this;
        }

        public final ErrorReportLocation.Builder getErrorReportLocation() {
            return errorReportLocation != null ? errorReportLocation.toBuilder() : null;
        }

        public final void setErrorReportLocation(ErrorReportLocation.BuilderImpl errorReportLocation) {
            this.errorReportLocation = errorReportLocation != null ? errorReportLocation.build() : null;
        }

        @Override
        public final Builder errorReportLocation(ErrorReportLocation errorReportLocation) {
            this.errorReportLocation = errorReportLocation;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public ScheduledQueryRunSummary build() {
            return new ScheduledQueryRunSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
