/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.timestreamquery.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteScheduledQueryRequest extends TimestreamQueryRequest implements
        ToCopyableBuilder<ExecuteScheduledQueryRequest.Builder, ExecuteScheduledQueryRequest> {
    private static final SdkField<String> SCHEDULED_QUERY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduledQueryArn").getter(getter(ExecuteScheduledQueryRequest::scheduledQueryArn))
            .setter(setter(Builder::scheduledQueryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledQueryArn").build()).build();

    private static final SdkField<Instant> INVOCATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InvocationTime").getter(getter(ExecuteScheduledQueryRequest::invocationTime))
            .setter(setter(Builder::invocationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationTime").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ExecuteScheduledQueryRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_QUERY_ARN_FIELD,
            INVOCATION_TIME_FIELD, CLIENT_TOKEN_FIELD));

    private final String scheduledQueryArn;

    private final Instant invocationTime;

    private final String clientToken;

    private ExecuteScheduledQueryRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledQueryArn = builder.scheduledQueryArn;
        this.invocationTime = builder.invocationTime;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * ARN of the scheduled query.
     * </p>
     * 
     * @return ARN of the scheduled query.
     */
    public final String scheduledQueryArn() {
        return scheduledQueryArn;
    }

    /**
     * <p>
     * The timestamp in UTC. Query will be run as if it was invoked at this timestamp.
     * </p>
     * 
     * @return The timestamp in UTC. Query will be run as if it was invoked at this timestamp.
     */
    public final Instant invocationTime() {
        return invocationTime;
    }

    /**
     * <p>
     * Not used.
     * </p>
     * 
     * @return Not used.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledQueryArn());
        hashCode = 31 * hashCode + Objects.hashCode(invocationTime());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteScheduledQueryRequest)) {
            return false;
        }
        ExecuteScheduledQueryRequest other = (ExecuteScheduledQueryRequest) obj;
        return Objects.equals(scheduledQueryArn(), other.scheduledQueryArn())
                && Objects.equals(invocationTime(), other.invocationTime()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteScheduledQueryRequest").add("ScheduledQueryArn", scheduledQueryArn())
                .add("InvocationTime", invocationTime())
                .add("ClientToken", clientToken() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledQueryArn":
            return Optional.ofNullable(clazz.cast(scheduledQueryArn()));
        case "InvocationTime":
            return Optional.ofNullable(clazz.cast(invocationTime()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteScheduledQueryRequest, T> g) {
        return obj -> g.apply((ExecuteScheduledQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TimestreamQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ExecuteScheduledQueryRequest> {
        /**
         * <p>
         * ARN of the scheduled query.
         * </p>
         * 
         * @param scheduledQueryArn
         *        ARN of the scheduled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledQueryArn(String scheduledQueryArn);

        /**
         * <p>
         * The timestamp in UTC. Query will be run as if it was invoked at this timestamp.
         * </p>
         * 
         * @param invocationTime
         *        The timestamp in UTC. Query will be run as if it was invoked at this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationTime(Instant invocationTime);

        /**
         * <p>
         * Not used.
         * </p>
         * 
         * @param clientToken
         *        Not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TimestreamQueryRequest.BuilderImpl implements Builder {
        private String scheduledQueryArn;

        private Instant invocationTime;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteScheduledQueryRequest model) {
            super(model);
            scheduledQueryArn(model.scheduledQueryArn);
            invocationTime(model.invocationTime);
            clientToken(model.clientToken);
        }

        public final String getScheduledQueryArn() {
            return scheduledQueryArn;
        }

        public final void setScheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
        }

        @Override
        public final Builder scheduledQueryArn(String scheduledQueryArn) {
            this.scheduledQueryArn = scheduledQueryArn;
            return this;
        }

        public final Instant getInvocationTime() {
            return invocationTime;
        }

        public final void setInvocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
        }

        @Override
        public final Builder invocationTime(Instant invocationTime) {
            this.invocationTime = invocationTime;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteScheduledQueryRequest build() {
            return new ExecuteScheduledQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
