/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.textract.model.Geometry;
import software.amazon.awssdk.services.textract.model.SelectionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LendingDetection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LendingDetection> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(LendingDetection.getter(LendingDetection::text)).setter(LendingDetection.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> SELECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectionStatus").getter(LendingDetection.getter(LendingDetection::selectionStatusAsString)).setter(LendingDetection.setter(Builder::selectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionStatus").build()}).build();
    private static final SdkField<Geometry> GEOMETRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Geometry").getter(LendingDetection.getter(LendingDetection::geometry)).setter(LendingDetection.setter(Builder::geometry)).constructor(Geometry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometry").build()}).build();
    private static final SdkField<Float> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("Confidence").getter(LendingDetection.getter(LendingDetection::confidence)).setter(LendingDetection.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, SELECTION_STATUS_FIELD, GEOMETRY_FIELD, CONFIDENCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String text;
    private final String selectionStatus;
    private final Geometry geometry;
    private final Float confidence;

    private LendingDetection(BuilderImpl builder) {
        this.text = builder.text;
        this.selectionStatus = builder.selectionStatus;
        this.geometry = builder.geometry;
        this.confidence = builder.confidence;
    }

    public final String text() {
        return this.text;
    }

    public final SelectionStatus selectionStatus() {
        return SelectionStatus.fromValue(this.selectionStatus);
    }

    public final String selectionStatusAsString() {
        return this.selectionStatus;
    }

    public final Geometry geometry() {
        return this.geometry;
    }

    public final Float confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.geometry());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LendingDetection)) {
            return false;
        }
        LendingDetection other = (LendingDetection)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.selectionStatusAsString(), other.selectionStatusAsString()) && Objects.equals(this.geometry(), other.geometry()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"LendingDetection").add("Text", (Object)this.text()).add("SelectionStatus", (Object)this.selectionStatusAsString()).add("Geometry", (Object)this.geometry()).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "SelectionStatus": {
                return Optional.ofNullable(clazz.cast(this.selectionStatusAsString()));
            }
            case "Geometry": {
                return Optional.ofNullable(clazz.cast(this.geometry()));
            }
            case "Confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LendingDetection, T> g) {
        return obj -> g.apply((LendingDetection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private String selectionStatus;
        private Geometry geometry;
        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(LendingDetection model) {
            this.text(model.text);
            this.selectionStatus(model.selectionStatus);
            this.geometry(model.geometry);
            this.confidence(model.confidence);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getSelectionStatus() {
            return this.selectionStatus;
        }

        public final void setSelectionStatus(String selectionStatus) {
            this.selectionStatus = selectionStatus;
        }

        @Override
        public final Builder selectionStatus(String selectionStatus) {
            this.selectionStatus = selectionStatus;
            return this;
        }

        @Override
        public final Builder selectionStatus(SelectionStatus selectionStatus) {
            this.selectionStatus(selectionStatus == null ? null : selectionStatus.toString());
            return this;
        }

        public final Geometry.Builder getGeometry() {
            return this.geometry != null ? this.geometry.toBuilder() : null;
        }

        public final void setGeometry(Geometry.BuilderImpl geometry) {
            this.geometry = geometry != null ? geometry.build() : null;
        }

        @Override
        public final Builder geometry(Geometry geometry) {
            this.geometry = geometry;
            return this;
        }

        public final Float getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public LendingDetection build() {
            return new LendingDetection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LendingDetection> {
        public Builder text(String var1);

        public Builder selectionStatus(String var1);

        public Builder selectionStatus(SelectionStatus var1);

        public Builder geometry(Geometry var1);

        default public Builder geometry(Consumer<Geometry.Builder> geometry) {
            return this.geometry((Geometry)((Geometry.Builder)Geometry.builder().applyMutation(geometry)).build());
        }

        public Builder confidence(Float var1);
    }
}

