/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.junit.Assert;
import software.amazon.awssdk.testutils.InputStreamUtils;
import software.amazon.awssdk.utils.IoUtils;

public final class SdkAsserts {
    private SdkAsserts() {
    }

    @Deprecated
    public static void assertNotEmpty(String str) {
        Assert.assertNotNull((Object)str);
        Assert.assertTrue((str.length() > 0 ? 1 : 0) != 0);
    }

    public static void assertFileEqualsStream(File expected, InputStream actual) {
        SdkAsserts.assertFileEqualsStream(null, expected, actual);
    }

    public static void assertFileEqualsStream(String errmsg, File expected, InputStream actual) {
        try {
            FileInputStream expectedInputStream = new FileInputStream(expected);
            SdkAsserts.assertStreamEqualsStream(errmsg, expectedInputStream, actual);
        }
        catch (FileNotFoundException e) {
            Assert.fail((String)("Expected file " + expected.getAbsolutePath() + " doesn't exist: " + e.getMessage()));
        }
    }

    public static void assertStreamEqualsStream(InputStream expected, InputStream actual) {
        SdkAsserts.assertStreamEqualsStream(null, expected, actual);
    }

    public static void assertStreamEqualsStream(String errmsg, InputStream expectedInputStream, InputStream inputStream) {
        try {
            Assert.assertTrue((String)errmsg, (boolean)SdkAsserts.doesStreamEqualStream(expectedInputStream, inputStream));
        }
        catch (IOException e) {
            Assert.fail((String)("Error reading from stream: " + e.getMessage()));
        }
    }

    public static void assertFileEqualsFile(File expected, File actual) {
        if (expected == null || !expected.exists()) {
            Assert.fail((String)"Expected file doesn't exist");
        }
        if (actual == null || !actual.exists()) {
            Assert.fail((String)"Actual file doesn't exist");
        }
        long expectedFileLen = expected.length();
        long fileLen = actual.length();
        Assert.assertTrue((String)("expectedFileLen=" + expectedFileLen + ", fileLen=" + fileLen + ", expectedFile=" + expected + ", file=" + actual), (expectedFileLen == fileLen ? 1 : 0) != 0);
        try (FileInputStream expectedIs = new FileInputStream(expected);
             FileInputStream actualIs = new FileInputStream(actual);){
            SdkAsserts.assertStreamEqualsStream("expected file: " + expected + " vs. actual file: " + actual, expectedIs, actualIs);
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to compare files: " + e.getMessage()));
        }
    }

    public static void assertStringEqualsStream(String expected, InputStream actual) {
        try {
            ByteArrayInputStream expectedInputStream = new ByteArrayInputStream(expected.getBytes(StandardCharsets.UTF_8));
            Assert.assertTrue((boolean)SdkAsserts.doesStreamEqualStream(expectedInputStream, actual));
        }
        catch (IOException e) {
            Assert.fail((String)("Error reading from stream: " + e.getMessage()));
        }
    }

    public static boolean doesStreamEqualStream(InputStream expected, InputStream actual) throws IOException {
        try {
            byte[] expectedDigest = InputStreamUtils.calculateMD5Digest(expected);
            byte[] actualDigest = InputStreamUtils.calculateMD5Digest(actual);
            boolean bl = Arrays.equals(expectedDigest, actualDigest);
            return bl;
        }
        catch (NoSuchAlgorithmException nse) {
            throw new RuntimeException(nse.getMessage(), nse);
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)expected, null);
            IoUtils.closeQuietly((AutoCloseable)actual, null);
        }
    }

    public static boolean doesFileEqualStream(File expectedFile, InputStream inputStream) throws IOException {
        FileInputStream expectedInputStream = new FileInputStream(expectedFile);
        return SdkAsserts.doesStreamEqualStream(expectedInputStream, inputStream);
    }
}

