/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.Property;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface LogCaptor
extends SdkAutoCloseable {
    public static LogCaptor create() {
        return new DefaultLogCaptor();
    }

    public static LogCaptor create(Level level) {
        return new DefaultLogCaptor(level);
    }

    public List<LogEvent> loggedEvents();

    public void clear();

    public static class DefaultLogCaptor
    extends AbstractAppender
    implements LogCaptor {
        private final List<LogEvent> loggedEvents = new ArrayList<LogEvent>();
        private final Level originalLoggingLevel = DefaultLogCaptor.rootLogger().getLevel();
        private final Level levelToCapture;

        private DefaultLogCaptor() {
            this(Level.ALL);
        }

        private DefaultLogCaptor(Level level) {
            super(DefaultLogCaptor.getCallerClassName(), null, null, false, Property.EMPTY_ARRAY);
            this.levelToCapture = level;
            this.startCapturing();
        }

        @Override
        public List<LogEvent> loggedEvents() {
            return new ArrayList<LogEvent>(this.loggedEvents);
        }

        @Override
        public void clear() {
            this.loggedEvents.clear();
        }

        protected void startCapturing() {
            this.loggedEvents.clear();
            DefaultLogCaptor.rootLogger().addAppender((Appender)this);
            this.start();
            Configurator.setRootLevel((Level)this.levelToCapture);
        }

        protected void stopCapturing() {
            DefaultLogCaptor.rootLogger().removeAppender((Appender)this);
            this.stop();
            Configurator.setRootLevel((Level)this.originalLoggingLevel);
        }

        public void append(LogEvent event) {
            this.loggedEvents.add(event.toImmutable());
        }

        public void close() {
            this.stopCapturing();
        }

        private static Logger rootLogger() {
            return (Logger)LogManager.getRootLogger();
        }

        static String getCallerClassName() {
            return Arrays.stream(Thread.currentThread().getStackTrace()).map(StackTraceElement::getClassName).filter(className -> !className.equals(Thread.class.getName())).filter(className -> !className.equals(DefaultLogCaptor.class.getName())).filter(className -> !className.equals(LogCaptor.class.getName())).findFirst().orElseThrow(NoSuchElementException::new);
        }
    }

    public static class LogCaptorTestBase
    extends DefaultLogCaptor {
        public LogCaptorTestBase() {
        }

        public LogCaptorTestBase(Level level) {
            super(level);
        }

        @Override
        @BeforeEach
        public void startCapturing() {
            super.startCapturing();
        }

        @Override
        @AfterEach
        public void stopCapturing() {
            super.stopCapturing();
        }
    }
}

