/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfiguration;
import software.amazon.awssdk.services.supportapp.model.SlackWorkspaceConfigurationListCopier;
import software.amazon.awssdk.services.supportapp.model.SupportAppResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSlackWorkspaceConfigurationsResponse
extends SupportAppResponse
implements ToCopyableBuilder<Builder, ListSlackWorkspaceConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSlackWorkspaceConfigurationsResponse.getter(ListSlackWorkspaceConfigurationsResponse::nextToken)).setter(ListSlackWorkspaceConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SlackWorkspaceConfiguration>> SLACK_WORKSPACE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slackWorkspaceConfigurations").getter(ListSlackWorkspaceConfigurationsResponse.getter(ListSlackWorkspaceConfigurationsResponse::slackWorkspaceConfigurations)).setter(ListSlackWorkspaceConfigurationsResponse.setter(Builder::slackWorkspaceConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slackWorkspaceConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlackWorkspaceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SLACK_WORKSPACE_CONFIGURATIONS_FIELD));
    private final String nextToken;
    private final List<SlackWorkspaceConfiguration> slackWorkspaceConfigurations;

    private ListSlackWorkspaceConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.slackWorkspaceConfigurations = builder.slackWorkspaceConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSlackWorkspaceConfigurations() {
        return this.slackWorkspaceConfigurations != null && !(this.slackWorkspaceConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SlackWorkspaceConfiguration> slackWorkspaceConfigurations() {
        return this.slackWorkspaceConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlackWorkspaceConfigurations() ? this.slackWorkspaceConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSlackWorkspaceConfigurationsResponse)) {
            return false;
        }
        ListSlackWorkspaceConfigurationsResponse other = (ListSlackWorkspaceConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSlackWorkspaceConfigurations() == other.hasSlackWorkspaceConfigurations() && Objects.equals(this.slackWorkspaceConfigurations(), other.slackWorkspaceConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ListSlackWorkspaceConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("SlackWorkspaceConfigurations", this.hasSlackWorkspaceConfigurations() ? this.slackWorkspaceConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "slackWorkspaceConfigurations": {
                return Optional.ofNullable(clazz.cast(this.slackWorkspaceConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSlackWorkspaceConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSlackWorkspaceConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportAppResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SlackWorkspaceConfiguration> slackWorkspaceConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSlackWorkspaceConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.slackWorkspaceConfigurations(model.slackWorkspaceConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SlackWorkspaceConfiguration.Builder> getSlackWorkspaceConfigurations() {
            List<SlackWorkspaceConfiguration.Builder> result = SlackWorkspaceConfigurationListCopier.copyToBuilder(this.slackWorkspaceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlackWorkspaceConfigurations(Collection<SlackWorkspaceConfiguration.BuilderImpl> slackWorkspaceConfigurations) {
            this.slackWorkspaceConfigurations = SlackWorkspaceConfigurationListCopier.copyFromBuilder(slackWorkspaceConfigurations);
        }

        @Override
        public final Builder slackWorkspaceConfigurations(Collection<SlackWorkspaceConfiguration> slackWorkspaceConfigurations) {
            this.slackWorkspaceConfigurations = SlackWorkspaceConfigurationListCopier.copy(slackWorkspaceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackWorkspaceConfigurations(SlackWorkspaceConfiguration ... slackWorkspaceConfigurations) {
            this.slackWorkspaceConfigurations(Arrays.asList(slackWorkspaceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackWorkspaceConfigurations(Consumer<SlackWorkspaceConfiguration.Builder> ... slackWorkspaceConfigurations) {
            this.slackWorkspaceConfigurations(Stream.of(slackWorkspaceConfigurations).map(c -> (SlackWorkspaceConfiguration)((SlackWorkspaceConfiguration.Builder)SlackWorkspaceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSlackWorkspaceConfigurationsResponse build() {
            return new ListSlackWorkspaceConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SupportAppResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSlackWorkspaceConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder slackWorkspaceConfigurations(Collection<SlackWorkspaceConfiguration> var1);

        public Builder slackWorkspaceConfigurations(SlackWorkspaceConfiguration ... var1);

        public Builder slackWorkspaceConfigurations(Consumer<SlackWorkspaceConfiguration.Builder> ... var1);
    }
}

