/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.supportapp.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.supportapp.model.SlackChannelConfiguration;
import software.amazon.awssdk.services.supportapp.model.SupportAppResponse;
import software.amazon.awssdk.services.supportapp.model._slackChannelConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSlackChannelConfigurationsResponse
extends SupportAppResponse
implements ToCopyableBuilder<Builder, ListSlackChannelConfigurationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSlackChannelConfigurationsResponse.getter(ListSlackChannelConfigurationsResponse::nextToken)).setter(ListSlackChannelConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SlackChannelConfiguration>> SLACK_CHANNEL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("slackChannelConfigurations").getter(ListSlackChannelConfigurationsResponse.getter(ListSlackChannelConfigurationsResponse::slackChannelConfigurations)).setter(ListSlackChannelConfigurationsResponse.setter(Builder::slackChannelConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slackChannelConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SlackChannelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SLACK_CHANNEL_CONFIGURATIONS_FIELD));
    private final String nextToken;
    private final List<SlackChannelConfiguration> slackChannelConfigurations;

    private ListSlackChannelConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.slackChannelConfigurations = builder.slackChannelConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSlackChannelConfigurations() {
        return this.slackChannelConfigurations != null && !(this.slackChannelConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SlackChannelConfiguration> slackChannelConfigurations() {
        return this.slackChannelConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSlackChannelConfigurations() ? this.slackChannelConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSlackChannelConfigurationsResponse)) {
            return false;
        }
        ListSlackChannelConfigurationsResponse other = (ListSlackChannelConfigurationsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSlackChannelConfigurations() == other.hasSlackChannelConfigurations() && Objects.equals(this.slackChannelConfigurations(), other.slackChannelConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"ListSlackChannelConfigurationsResponse").add("NextToken", (Object)this.nextToken()).add("SlackChannelConfigurations", this.hasSlackChannelConfigurations() ? this.slackChannelConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "slackChannelConfigurations": {
                return Optional.ofNullable(clazz.cast(this.slackChannelConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSlackChannelConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSlackChannelConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SupportAppResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SlackChannelConfiguration> slackChannelConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSlackChannelConfigurationsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.slackChannelConfigurations(model.slackChannelConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SlackChannelConfiguration.Builder> getSlackChannelConfigurations() {
            List<SlackChannelConfiguration.Builder> result = _slackChannelConfigurationListCopier.copyToBuilder(this.slackChannelConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSlackChannelConfigurations(Collection<SlackChannelConfiguration.BuilderImpl> slackChannelConfigurations) {
            this.slackChannelConfigurations = _slackChannelConfigurationListCopier.copyFromBuilder(slackChannelConfigurations);
        }

        @Override
        public final Builder slackChannelConfigurations(Collection<SlackChannelConfiguration> slackChannelConfigurations) {
            this.slackChannelConfigurations = _slackChannelConfigurationListCopier.copy(slackChannelConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackChannelConfigurations(SlackChannelConfiguration ... slackChannelConfigurations) {
            this.slackChannelConfigurations(Arrays.asList(slackChannelConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder slackChannelConfigurations(Consumer<SlackChannelConfiguration.Builder> ... slackChannelConfigurations) {
            this.slackChannelConfigurations(Stream.of(slackChannelConfigurations).map(c -> (SlackChannelConfiguration)((SlackChannelConfiguration.Builder)SlackChannelConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSlackChannelConfigurationsResponse build() {
            return new ListSlackChannelConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SupportAppResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSlackChannelConfigurationsResponse> {
        public Builder nextToken(String var1);

        public Builder slackChannelConfigurations(Collection<SlackChannelConfiguration> var1);

        public Builder slackChannelConfigurations(SlackChannelConfiguration ... var1);

        public Builder slackChannelConfigurations(Consumer<SlackChannelConfiguration.Builder> ... var1);
    }
}

