/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmsap.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The connection specifications for the database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseConnection implements SdkPojo, Serializable,
        ToCopyableBuilder<DatabaseConnection.Builder, DatabaseConnection> {
    private static final SdkField<String> DATABASE_CONNECTION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseConnectionMethod").getter(getter(DatabaseConnection::databaseConnectionMethodAsString))
            .setter(setter(Builder::databaseConnectionMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseConnectionMethod").build())
            .build();

    private static final SdkField<String> DATABASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseArn").getter(getter(DatabaseConnection::databaseArn)).setter(setter(Builder::databaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseArn").build()).build();

    private static final SdkField<String> CONNECTION_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionIp").getter(getter(DatabaseConnection::connectionIp)).setter(setter(Builder::connectionIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DATABASE_CONNECTION_METHOD_FIELD, DATABASE_ARN_FIELD, CONNECTION_IP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String databaseConnectionMethod;

    private final String databaseArn;

    private final String connectionIp;

    private DatabaseConnection(BuilderImpl builder) {
        this.databaseConnectionMethod = builder.databaseConnectionMethod;
        this.databaseArn = builder.databaseArn;
        this.connectionIp = builder.connectionIp;
    }

    /**
     * <p>
     * The method of connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseConnectionMethod} will return {@link DatabaseConnectionMethod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #databaseConnectionMethodAsString}.
     * </p>
     * 
     * @return The method of connection.
     * @see DatabaseConnectionMethod
     */
    public final DatabaseConnectionMethod databaseConnectionMethod() {
        return DatabaseConnectionMethod.fromValue(databaseConnectionMethod);
    }

    /**
     * <p>
     * The method of connection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #databaseConnectionMethod} will return {@link DatabaseConnectionMethod#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #databaseConnectionMethodAsString}.
     * </p>
     * 
     * @return The method of connection.
     * @see DatabaseConnectionMethod
     */
    public final String databaseConnectionMethodAsString() {
        return databaseConnectionMethod;
    }

    /**
     * <p>
     * The Amazon Resource Name of the connected SAP HANA database.
     * </p>
     * 
     * @return The Amazon Resource Name of the connected SAP HANA database.
     */
    public final String databaseArn() {
        return databaseArn;
    }

    /**
     * <p>
     * The IP address for connection.
     * </p>
     * 
     * @return The IP address for connection.
     */
    public final String connectionIp() {
        return connectionIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(databaseConnectionMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(databaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(connectionIp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseConnection)) {
            return false;
        }
        DatabaseConnection other = (DatabaseConnection) obj;
        return Objects.equals(databaseConnectionMethodAsString(), other.databaseConnectionMethodAsString())
                && Objects.equals(databaseArn(), other.databaseArn()) && Objects.equals(connectionIp(), other.connectionIp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseConnection").add("DatabaseConnectionMethod", databaseConnectionMethodAsString())
                .add("DatabaseArn", databaseArn()).add("ConnectionIp", connectionIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DatabaseConnectionMethod":
            return Optional.ofNullable(clazz.cast(databaseConnectionMethodAsString()));
        case "DatabaseArn":
            return Optional.ofNullable(clazz.cast(databaseArn()));
        case "ConnectionIp":
            return Optional.ofNullable(clazz.cast(connectionIp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatabaseConnection, T> g) {
        return obj -> g.apply((DatabaseConnection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseConnection> {
        /**
         * <p>
         * The method of connection.
         * </p>
         * 
         * @param databaseConnectionMethod
         *        The method of connection.
         * @see DatabaseConnectionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseConnectionMethod
         */
        Builder databaseConnectionMethod(String databaseConnectionMethod);

        /**
         * <p>
         * The method of connection.
         * </p>
         * 
         * @param databaseConnectionMethod
         *        The method of connection.
         * @see DatabaseConnectionMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatabaseConnectionMethod
         */
        Builder databaseConnectionMethod(DatabaseConnectionMethod databaseConnectionMethod);

        /**
         * <p>
         * The Amazon Resource Name of the connected SAP HANA database.
         * </p>
         * 
         * @param databaseArn
         *        The Amazon Resource Name of the connected SAP HANA database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseArn(String databaseArn);

        /**
         * <p>
         * The IP address for connection.
         * </p>
         * 
         * @param connectionIp
         *        The IP address for connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionIp(String connectionIp);
    }

    static final class BuilderImpl implements Builder {
        private String databaseConnectionMethod;

        private String databaseArn;

        private String connectionIp;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseConnection model) {
            databaseConnectionMethod(model.databaseConnectionMethod);
            databaseArn(model.databaseArn);
            connectionIp(model.connectionIp);
        }

        public final String getDatabaseConnectionMethod() {
            return databaseConnectionMethod;
        }

        public final void setDatabaseConnectionMethod(String databaseConnectionMethod) {
            this.databaseConnectionMethod = databaseConnectionMethod;
        }

        @Override
        public final Builder databaseConnectionMethod(String databaseConnectionMethod) {
            this.databaseConnectionMethod = databaseConnectionMethod;
            return this;
        }

        @Override
        public final Builder databaseConnectionMethod(DatabaseConnectionMethod databaseConnectionMethod) {
            this.databaseConnectionMethod(databaseConnectionMethod == null ? null : databaseConnectionMethod.toString());
            return this;
        }

        public final String getDatabaseArn() {
            return databaseArn;
        }

        public final void setDatabaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
        }

        @Override
        public final Builder databaseArn(String databaseArn) {
            this.databaseArn = databaseArn;
            return this;
        }

        public final String getConnectionIp() {
            return connectionIp;
        }

        public final void setConnectionIp(String connectionIp) {
            this.connectionIp = connectionIp;
        }

        @Override
        public final Builder connectionIp(String connectionIp) {
            this.connectionIp = connectionIp;
            return this;
        }

        @Override
        public DatabaseConnection build() {
            return new DatabaseConnection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
