/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about what created the incident record and when it was created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IncidentRecordSource implements SdkPojo, Serializable,
        ToCopyableBuilder<IncidentRecordSource.Builder, IncidentRecordSource> {
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(IncidentRecordSource::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<String> INVOKED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invokedBy").getter(getter(IncidentRecordSource::invokedBy)).setter(setter(Builder::invokedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invokedBy").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(IncidentRecordSource::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(IncidentRecordSource::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_BY_FIELD,
            INVOKED_BY_FIELD, RESOURCE_ARN_FIELD, SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String createdBy;

    private final String invokedBy;

    private final String resourceArn;

    private final String source;

    private IncidentRecordSource(BuilderImpl builder) {
        this.createdBy = builder.createdBy;
        this.invokedBy = builder.invokedBy;
        this.resourceArn = builder.resourceArn;
        this.source = builder.source;
    }

    /**
     * <p>
     * The principal that started the incident.
     * </p>
     * 
     * @return The principal that started the incident.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The service principal that assumed the role specified in <code>createdBy</code>. If no service principal assumed
     * the role this will be left blank.
     * </p>
     * 
     * @return The service principal that assumed the role specified in <code>createdBy</code>. If no service principal
     *         assumed the role this will be left blank.
     */
    public final String invokedBy() {
        return invokedBy;
    }

    /**
     * <p>
     * The resource that caused the incident to be created.
     * </p>
     * 
     * @return The resource that caused the incident to be created.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The service that started the incident. This can be manually created from Incident Manager, automatically created
     * using an Amazon CloudWatch alarm, or Amazon EventBridge event.
     * </p>
     * 
     * @return The service that started the incident. This can be manually created from Incident Manager, automatically
     *         created using an Amazon CloudWatch alarm, or Amazon EventBridge event.
     */
    public final String source() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(invokedBy());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IncidentRecordSource)) {
            return false;
        }
        IncidentRecordSource other = (IncidentRecordSource) obj;
        return Objects.equals(createdBy(), other.createdBy()) && Objects.equals(invokedBy(), other.invokedBy())
                && Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(source(), other.source());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IncidentRecordSource").add("CreatedBy", createdBy()).add("InvokedBy", invokedBy())
                .add("ResourceArn", resourceArn()).add("Source", source()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "invokedBy":
            return Optional.ofNullable(clazz.cast(invokedBy()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IncidentRecordSource, T> g) {
        return obj -> g.apply((IncidentRecordSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IncidentRecordSource> {
        /**
         * <p>
         * The principal that started the incident.
         * </p>
         * 
         * @param createdBy
         *        The principal that started the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The service principal that assumed the role specified in <code>createdBy</code>. If no service principal
         * assumed the role this will be left blank.
         * </p>
         * 
         * @param invokedBy
         *        The service principal that assumed the role specified in <code>createdBy</code>. If no service
         *        principal assumed the role this will be left blank.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invokedBy(String invokedBy);

        /**
         * <p>
         * The resource that caused the incident to be created.
         * </p>
         * 
         * @param resourceArn
         *        The resource that caused the incident to be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The service that started the incident. This can be manually created from Incident Manager, automatically
         * created using an Amazon CloudWatch alarm, or Amazon EventBridge event.
         * </p>
         * 
         * @param source
         *        The service that started the incident. This can be manually created from Incident Manager,
         *        automatically created using an Amazon CloudWatch alarm, or Amazon EventBridge event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);
    }

    static final class BuilderImpl implements Builder {
        private String createdBy;

        private String invokedBy;

        private String resourceArn;

        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(IncidentRecordSource model) {
            createdBy(model.createdBy);
            invokedBy(model.invokedBy);
            resourceArn(model.resourceArn);
            source(model.source);
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getInvokedBy() {
            return invokedBy;
        }

        public final void setInvokedBy(String invokedBy) {
            this.invokedBy = invokedBy;
        }

        @Override
        public final Builder invokedBy(String invokedBy) {
            this.invokedBy = invokedBy;
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public IncidentRecordSource build() {
            return new IncidentRecordSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
