/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the PagerDuty incident associated with an incident created by an Incident Manager response plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PagerDutyIncidentDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<PagerDutyIncidentDetail.Builder, PagerDutyIncidentDetail> {
    private static final SdkField<Boolean> AUTO_RESOLVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("autoResolve").getter(getter(PagerDutyIncidentDetail::autoResolve)).setter(setter(Builder::autoResolve))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoResolve").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(PagerDutyIncidentDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretId").getter(getter(PagerDutyIncidentDetail::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_RESOLVE_FIELD, ID_FIELD,
            SECRET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean autoResolve;

    private final String id;

    private final String secretId;

    private PagerDutyIncidentDetail(BuilderImpl builder) {
        this.autoResolve = builder.autoResolve;
        this.id = builder.id;
        this.secretId = builder.secretId;
    }

    /**
     * <p>
     * Indicates whether to resolve the PagerDuty incident when you resolve the associated Incident Manager incident.
     * </p>
     * 
     * @return Indicates whether to resolve the PagerDuty incident when you resolve the associated Incident Manager
     *         incident.
     */
    public final Boolean autoResolve() {
        return autoResolve;
    }

    /**
     * <p>
     * The ID of the incident associated with the PagerDuty service for the response plan.
     * </p>
     * 
     * @return The ID of the incident associated with the PagerDuty service for the response plan.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Secrets Manager secret that stores your PagerDuty key, either a General Access
     * REST API Key or User Token REST API Key, and other user credentials.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Secrets Manager secret that stores your PagerDuty key, either a General
     *         Access REST API Key or User Token REST API Key, and other user credentials.
     */
    public final String secretId() {
        return secretId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoResolve());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PagerDutyIncidentDetail)) {
            return false;
        }
        PagerDutyIncidentDetail other = (PagerDutyIncidentDetail) obj;
        return Objects.equals(autoResolve(), other.autoResolve()) && Objects.equals(id(), other.id())
                && Objects.equals(secretId(), other.secretId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PagerDutyIncidentDetail").add("AutoResolve", autoResolve()).add("Id", id())
                .add("SecretId", secretId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoResolve":
            return Optional.ofNullable(clazz.cast(autoResolve()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "secretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PagerDutyIncidentDetail, T> g) {
        return obj -> g.apply((PagerDutyIncidentDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PagerDutyIncidentDetail> {
        /**
         * <p>
         * Indicates whether to resolve the PagerDuty incident when you resolve the associated Incident Manager
         * incident.
         * </p>
         * 
         * @param autoResolve
         *        Indicates whether to resolve the PagerDuty incident when you resolve the associated Incident Manager
         *        incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoResolve(Boolean autoResolve);

        /**
         * <p>
         * The ID of the incident associated with the PagerDuty service for the response plan.
         * </p>
         * 
         * @param id
         *        The ID of the incident associated with the PagerDuty service for the response plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ID of the Amazon Web Services Secrets Manager secret that stores your PagerDuty key, either a General
         * Access REST API Key or User Token REST API Key, and other user credentials.
         * </p>
         * 
         * @param secretId
         *        The ID of the Amazon Web Services Secrets Manager secret that stores your PagerDuty key, either a
         *        General Access REST API Key or User Token REST API Key, and other user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean autoResolve;

        private String id;

        private String secretId;

        private BuilderImpl() {
        }

        private BuilderImpl(PagerDutyIncidentDetail model) {
            autoResolve(model.autoResolve);
            id(model.id);
            secretId(model.secretId);
        }

        public final Boolean getAutoResolve() {
            return autoResolve;
        }

        public final void setAutoResolve(Boolean autoResolve) {
            this.autoResolve = autoResolve;
        }

        @Override
        public final Builder autoResolve(Boolean autoResolve) {
            this.autoResolve = autoResolve;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        @Override
        public PagerDutyIncidentDetail build() {
            return new PagerDutyIncidentDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
