/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the PagerDuty configuration for a response plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PagerDutyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PagerDutyConfiguration.Builder, PagerDutyConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PagerDutyConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<PagerDutyIncidentConfiguration> PAGER_DUTY_INCIDENT_CONFIGURATION_FIELD = SdkField
            .<PagerDutyIncidentConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("pagerDutyIncidentConfiguration")
            .getter(getter(PagerDutyConfiguration::pagerDutyIncidentConfiguration))
            .setter(setter(Builder::pagerDutyIncidentConfiguration))
            .constructor(PagerDutyIncidentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pagerDutyIncidentConfiguration")
                    .build()).build();

    private static final SdkField<String> SECRET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretId").getter(getter(PagerDutyConfiguration::secretId)).setter(setter(Builder::secretId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PAGER_DUTY_INCIDENT_CONFIGURATION_FIELD, SECRET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final PagerDutyIncidentConfiguration pagerDutyIncidentConfiguration;

    private final String secretId;

    private PagerDutyConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.pagerDutyIncidentConfiguration = builder.pagerDutyIncidentConfiguration;
        this.secretId = builder.secretId;
    }

    /**
     * <p>
     * The name of the PagerDuty configuration.
     * </p>
     * 
     * @return The name of the PagerDuty configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Details about the PagerDuty service associated with the configuration.
     * </p>
     * 
     * @return Details about the PagerDuty service associated with the configuration.
     */
    public final PagerDutyIncidentConfiguration pagerDutyIncidentConfiguration() {
        return pagerDutyIncidentConfiguration;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Secrets Manager secret that stores your PagerDuty key, either a General Access
     * REST API Key or User Token REST API Key, and other user credentials.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Secrets Manager secret that stores your PagerDuty key, either a General
     *         Access REST API Key or User Token REST API Key, and other user credentials.
     */
    public final String secretId() {
        return secretId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pagerDutyIncidentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(secretId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PagerDutyConfiguration)) {
            return false;
        }
        PagerDutyConfiguration other = (PagerDutyConfiguration) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(pagerDutyIncidentConfiguration(), other.pagerDutyIncidentConfiguration())
                && Objects.equals(secretId(), other.secretId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PagerDutyConfiguration").add("Name", name())
                .add("PagerDutyIncidentConfiguration", pagerDutyIncidentConfiguration()).add("SecretId", secretId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "pagerDutyIncidentConfiguration":
            return Optional.ofNullable(clazz.cast(pagerDutyIncidentConfiguration()));
        case "secretId":
            return Optional.ofNullable(clazz.cast(secretId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PagerDutyConfiguration, T> g) {
        return obj -> g.apply((PagerDutyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PagerDutyConfiguration> {
        /**
         * <p>
         * The name of the PagerDuty configuration.
         * </p>
         * 
         * @param name
         *        The name of the PagerDuty configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Details about the PagerDuty service associated with the configuration.
         * </p>
         * 
         * @param pagerDutyIncidentConfiguration
         *        Details about the PagerDuty service associated with the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pagerDutyIncidentConfiguration(PagerDutyIncidentConfiguration pagerDutyIncidentConfiguration);

        /**
         * <p>
         * Details about the PagerDuty service associated with the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link PagerDutyIncidentConfiguration.Builder}
         * avoiding the need to create one manually via {@link PagerDutyIncidentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PagerDutyIncidentConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pagerDutyIncidentConfiguration(PagerDutyIncidentConfiguration)}.
         * 
         * @param pagerDutyIncidentConfiguration
         *        a consumer that will call methods on {@link PagerDutyIncidentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pagerDutyIncidentConfiguration(PagerDutyIncidentConfiguration)
         */
        default Builder pagerDutyIncidentConfiguration(
                Consumer<PagerDutyIncidentConfiguration.Builder> pagerDutyIncidentConfiguration) {
            return pagerDutyIncidentConfiguration(PagerDutyIncidentConfiguration.builder()
                    .applyMutation(pagerDutyIncidentConfiguration).build());
        }

        /**
         * <p>
         * The ID of the Amazon Web Services Secrets Manager secret that stores your PagerDuty key, either a General
         * Access REST API Key or User Token REST API Key, and other user credentials.
         * </p>
         * 
         * @param secretId
         *        The ID of the Amazon Web Services Secrets Manager secret that stores your PagerDuty key, either a
         *        General Access REST API Key or User Token REST API Key, and other user credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretId(String secretId);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private PagerDutyIncidentConfiguration pagerDutyIncidentConfiguration;

        private String secretId;

        private BuilderImpl() {
        }

        private BuilderImpl(PagerDutyConfiguration model) {
            name(model.name);
            pagerDutyIncidentConfiguration(model.pagerDutyIncidentConfiguration);
            secretId(model.secretId);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PagerDutyIncidentConfiguration.Builder getPagerDutyIncidentConfiguration() {
            return pagerDutyIncidentConfiguration != null ? pagerDutyIncidentConfiguration.toBuilder() : null;
        }

        public final void setPagerDutyIncidentConfiguration(
                PagerDutyIncidentConfiguration.BuilderImpl pagerDutyIncidentConfiguration) {
            this.pagerDutyIncidentConfiguration = pagerDutyIncidentConfiguration != null ? pagerDutyIncidentConfiguration.build()
                    : null;
        }

        @Override
        public final Builder pagerDutyIncidentConfiguration(PagerDutyIncidentConfiguration pagerDutyIncidentConfiguration) {
            this.pagerDutyIncidentConfiguration = pagerDutyIncidentConfiguration;
            return this;
        }

        public final String getSecretId() {
            return secretId;
        }

        public final void setSecretId(String secretId) {
            this.secretId = secretId;
        }

        @Override
        public final Builder secretId(String secretId) {
            this.secretId = secretId;
            return this;
        }

        @Override
        public PagerDutyConfiguration build() {
            return new PagerDutyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
