/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsAsyncClient;
import software.amazon.awssdk.services.ssmincidents.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsResponse;

public class ListReplicationSetsPublisher
implements SdkPublisher<ListReplicationSetsResponse> {
    private final SsmIncidentsAsyncClient client;
    private final ListReplicationSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReplicationSetsPublisher(SsmIncidentsAsyncClient client, ListReplicationSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReplicationSetsPublisher(SsmIncidentsAsyncClient client, ListReplicationSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReplicationSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReplicationSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> replicationSetArns() {
        Function<ListReplicationSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.replicationSetArns() != null) {
                return response.replicationSetArns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReplicationSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReplicationSetsResponseFetcher
    implements AsyncPageFetcher<ListReplicationSetsResponse> {
        private ListReplicationSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListReplicationSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReplicationSetsResponse> nextPage(ListReplicationSetsResponse previousPage) {
            if (previousPage == null) {
                return ListReplicationSetsPublisher.this.client.listReplicationSets(ListReplicationSetsPublisher.this.firstRequest);
            }
            return ListReplicationSetsPublisher.this.client.listReplicationSets((ListReplicationSetsRequest)((Object)ListReplicationSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

