/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventReference> {
    private static final SdkField<String> RELATED_ITEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedItemId").getter(EventReference.getter(EventReference::relatedItemId)).setter(EventReference.setter(Builder::relatedItemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemId").build()}).build();
    private static final SdkField<String> RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resource").getter(EventReference.getter(EventReference::resource)).setter(EventReference.setter(Builder::resource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RELATED_ITEM_ID_FIELD, RESOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String relatedItemId;
    private final String resource;
    private final Type type;

    private EventReference(BuilderImpl builder) {
        this.relatedItemId = builder.relatedItemId;
        this.resource = builder.resource;
        this.type = builder.type;
    }

    public final String relatedItemId() {
        return this.relatedItemId;
    }

    public final String resource() {
        return this.resource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedItemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventReference)) {
            return false;
        }
        EventReference other = (EventReference)obj;
        return Objects.equals(this.relatedItemId(), other.relatedItemId()) && Objects.equals(this.resource(), other.resource());
    }

    public final String toString() {
        return ToString.builder((String)"EventReference").add("RelatedItemId", (Object)this.relatedItemId()).add("Resource", (Object)this.resource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "relatedItemId": {
                return Optional.ofNullable(clazz.cast(this.relatedItemId()));
            }
            case "resource": {
                return Optional.ofNullable(clazz.cast(this.resource()));
            }
        }
        return Optional.empty();
    }

    public static EventReference fromRelatedItemId(String relatedItemId) {
        return (EventReference)EventReference.builder().relatedItemId(relatedItemId).build();
    }

    public static EventReference fromResource(String resource) {
        return (EventReference)EventReference.builder().resource(resource).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventReference, T> g) {
        return obj -> g.apply((EventReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        RELATED_ITEM_ID,
        RESOURCE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String relatedItemId;
        private String resource;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EventReference model) {
            this.relatedItemId(model.relatedItemId);
            this.resource(model.resource);
        }

        public final String getRelatedItemId() {
            return this.relatedItemId;
        }

        public final void setRelatedItemId(String relatedItemId) {
            String oldValue = this.relatedItemId;
            this.relatedItemId = relatedItemId;
            this.handleUnionValueChange(Type.RELATED_ITEM_ID, oldValue, this.relatedItemId);
        }

        @Override
        public final Builder relatedItemId(String relatedItemId) {
            String oldValue = this.relatedItemId;
            this.relatedItemId = relatedItemId;
            this.handleUnionValueChange(Type.RELATED_ITEM_ID, oldValue, this.relatedItemId);
            return this;
        }

        public final String getResource() {
            return this.resource;
        }

        public final void setResource(String resource) {
            String oldValue = this.resource;
            this.resource = resource;
            this.handleUnionValueChange(Type.RESOURCE, oldValue, this.resource);
        }

        @Override
        public final Builder resource(String resource) {
            String oldValue = this.resource;
            this.resource = resource;
            this.handleUnionValueChange(Type.RESOURCE, oldValue, this.resource);
            return this;
        }

        public EventReference build() {
            return new EventReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventReference> {
        public Builder relatedItemId(String var1);

        public Builder resource(String var1);
    }
}

