/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssmincidents.model.Action;
import software.amazon.awssdk.services.ssmincidents.model.ActionsListCopier;
import software.amazon.awssdk.services.ssmincidents.model.ChatChannel;
import software.amazon.awssdk.services.ssmincidents.model.EngagementSetCopier;
import software.amazon.awssdk.services.ssmincidents.model.IncidentTemplate;
import software.amazon.awssdk.services.ssmincidents.model.Integration;
import software.amazon.awssdk.services.ssmincidents.model.IntegrationsCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsRequest;
import software.amazon.awssdk.services.ssmincidents.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResponsePlanRequest
extends SsmIncidentsRequest
implements ToCopyableBuilder<Builder, CreateResponsePlanRequest> {
    private static final SdkField<List<Action>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::actions)).setter(CreateResponsePlanRequest.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Action::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ChatChannel> CHAT_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("chatChannel").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::chatChannel)).setter(CreateResponsePlanRequest.setter(Builder::chatChannel)).constructor(ChatChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("chatChannel").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::clientToken)).setter(CreateResponsePlanRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::displayName)).setter(CreateResponsePlanRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<List<String>> ENGAGEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("engagements").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::engagements)).setter(CreateResponsePlanRequest.setter(Builder::engagements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IncidentTemplate> INCIDENT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("incidentTemplate").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::incidentTemplate)).setter(CreateResponsePlanRequest.setter(Builder::incidentTemplate)).constructor(IncidentTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentTemplate").build()}).build();
    private static final SdkField<List<Integration>> INTEGRATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("integrations").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::integrations)).setter(CreateResponsePlanRequest.setter(Builder::integrations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integrations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Integration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::name)).setter(CreateResponsePlanRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateResponsePlanRequest.getter(CreateResponsePlanRequest::tags)).setter(CreateResponsePlanRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, CHAT_CHANNEL_FIELD, CLIENT_TOKEN_FIELD, DISPLAY_NAME_FIELD, ENGAGEMENTS_FIELD, INCIDENT_TEMPLATE_FIELD, INTEGRATIONS_FIELD, NAME_FIELD, TAGS_FIELD));
    private final List<Action> actions;
    private final ChatChannel chatChannel;
    private final String clientToken;
    private final String displayName;
    private final List<String> engagements;
    private final IncidentTemplate incidentTemplate;
    private final List<Integration> integrations;
    private final String name;
    private final Map<String, String> tags;

    private CreateResponsePlanRequest(BuilderImpl builder) {
        super(builder);
        this.actions = builder.actions;
        this.chatChannel = builder.chatChannel;
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.engagements = builder.engagements;
        this.incidentTemplate = builder.incidentTemplate;
        this.integrations = builder.integrations;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<Action> actions() {
        return this.actions;
    }

    public final ChatChannel chatChannel() {
        return this.chatChannel;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final boolean hasEngagements() {
        return this.engagements != null && !(this.engagements instanceof SdkAutoConstructList);
    }

    public final List<String> engagements() {
        return this.engagements;
    }

    public final IncidentTemplate incidentTemplate() {
        return this.incidentTemplate;
    }

    public final boolean hasIntegrations() {
        return this.integrations != null && !(this.integrations instanceof SdkAutoConstructList);
    }

    public final List<Integration> integrations() {
        return this.integrations;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.chatChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngagements() ? this.engagements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.incidentTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntegrations() ? this.integrations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResponsePlanRequest)) {
            return false;
        }
        CreateResponsePlanRequest other = (CreateResponsePlanRequest)((Object)obj);
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.chatChannel(), other.chatChannel()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.displayName(), other.displayName()) && this.hasEngagements() == other.hasEngagements() && Objects.equals(this.engagements(), other.engagements()) && Objects.equals(this.incidentTemplate(), other.incidentTemplate()) && this.hasIntegrations() == other.hasIntegrations() && Objects.equals(this.integrations(), other.integrations()) && Objects.equals(this.name(), other.name()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResponsePlanRequest").add("Actions", this.hasActions() ? this.actions() : null).add("ChatChannel", (Object)this.chatChannel()).add("ClientToken", (Object)this.clientToken()).add("DisplayName", (Object)this.displayName()).add("Engagements", this.hasEngagements() ? this.engagements() : null).add("IncidentTemplate", (Object)this.incidentTemplate()).add("Integrations", this.hasIntegrations() ? this.integrations() : null).add("Name", (Object)this.name()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "chatChannel": {
                return Optional.ofNullable(clazz.cast(this.chatChannel()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "engagements": {
                return Optional.ofNullable(clazz.cast(this.engagements()));
            }
            case "incidentTemplate": {
                return Optional.ofNullable(clazz.cast(this.incidentTemplate()));
            }
            case "integrations": {
                return Optional.ofNullable(clazz.cast(this.integrations()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResponsePlanRequest, T> g) {
        return obj -> g.apply((CreateResponsePlanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsRequest.BuilderImpl
    implements Builder {
        private List<Action> actions = DefaultSdkAutoConstructList.getInstance();
        private ChatChannel chatChannel;
        private String clientToken;
        private String displayName;
        private List<String> engagements = DefaultSdkAutoConstructList.getInstance();
        private IncidentTemplate incidentTemplate;
        private List<Integration> integrations = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResponsePlanRequest model) {
            super(model);
            this.actions(model.actions);
            this.chatChannel(model.chatChannel);
            this.clientToken(model.clientToken);
            this.displayName(model.displayName);
            this.engagements(model.engagements);
            this.incidentTemplate(model.incidentTemplate);
            this.integrations(model.integrations);
            this.name(model.name);
            this.tags(model.tags);
        }

        public final List<Action.Builder> getActions() {
            List<Action.Builder> result = ActionsListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionsListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<Action.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (Action)((Action.Builder)Action.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ChatChannel.Builder getChatChannel() {
            return this.chatChannel != null ? this.chatChannel.toBuilder() : null;
        }

        public final void setChatChannel(ChatChannel.BuilderImpl chatChannel) {
            this.chatChannel = chatChannel != null ? chatChannel.build() : null;
        }

        @Override
        public final Builder chatChannel(ChatChannel chatChannel) {
            this.chatChannel = chatChannel;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final Collection<String> getEngagements() {
            if (this.engagements instanceof SdkAutoConstructList) {
                return null;
            }
            return this.engagements;
        }

        public final void setEngagements(Collection<String> engagements) {
            this.engagements = EngagementSetCopier.copy(engagements);
        }

        @Override
        public final Builder engagements(Collection<String> engagements) {
            this.engagements = EngagementSetCopier.copy(engagements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagements(String ... engagements) {
            this.engagements(Arrays.asList(engagements));
            return this;
        }

        public final IncidentTemplate.Builder getIncidentTemplate() {
            return this.incidentTemplate != null ? this.incidentTemplate.toBuilder() : null;
        }

        public final void setIncidentTemplate(IncidentTemplate.BuilderImpl incidentTemplate) {
            this.incidentTemplate = incidentTemplate != null ? incidentTemplate.build() : null;
        }

        @Override
        public final Builder incidentTemplate(IncidentTemplate incidentTemplate) {
            this.incidentTemplate = incidentTemplate;
            return this;
        }

        public final List<Integration.Builder> getIntegrations() {
            List<Integration.Builder> result = IntegrationsCopier.copyToBuilder(this.integrations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIntegrations(Collection<Integration.BuilderImpl> integrations) {
            this.integrations = IntegrationsCopier.copyFromBuilder(integrations);
        }

        @Override
        public final Builder integrations(Collection<Integration> integrations) {
            this.integrations = IntegrationsCopier.copy(integrations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Integration ... integrations) {
            this.integrations(Arrays.asList(integrations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder integrations(Consumer<Integration.Builder> ... integrations) {
            this.integrations(Stream.of(integrations).map(c -> (Integration)((Integration.Builder)Integration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResponsePlanRequest build() {
            return new CreateResponsePlanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmIncidentsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResponsePlanRequest> {
        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder actions(Consumer<Action.Builder> ... var1);

        public Builder chatChannel(ChatChannel var1);

        default public Builder chatChannel(Consumer<ChatChannel.Builder> chatChannel) {
            return this.chatChannel((ChatChannel)((ChatChannel.Builder)ChatChannel.builder().applyMutation(chatChannel)).build());
        }

        public Builder clientToken(String var1);

        public Builder displayName(String var1);

        public Builder engagements(Collection<String> var1);

        public Builder engagements(String ... var1);

        public Builder incidentTemplate(IncidentTemplate var1);

        default public Builder incidentTemplate(Consumer<IncidentTemplate.Builder> incidentTemplate) {
            return this.incidentTemplate((IncidentTemplate)((IncidentTemplate.Builder)IncidentTemplate.builder().applyMutation(incidentTemplate)).build());
        }

        public Builder integrations(Collection<Integration> var1);

        public Builder integrations(Integration ... var1);

        public Builder integrations(Consumer<Integration.Builder> ... var1);

        public Builder name(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

