/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartIncidentRequest extends SsmIncidentsRequest implements
        ToCopyableBuilder<StartIncidentRequest.Builder, StartIncidentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(StartIncidentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Integer> IMPACT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("impact").getter(getter(StartIncidentRequest::impact)).setter(setter(Builder::impact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impact").build()).build();

    private static final SdkField<List<RelatedItem>> RELATED_ITEMS_FIELD = SdkField
            .<List<RelatedItem>> builder(MarshallingType.LIST)
            .memberName("relatedItems")
            .getter(getter(StartIncidentRequest::relatedItems))
            .setter(setter(Builder::relatedItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelatedItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelatedItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESPONSE_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responsePlanArn").getter(getter(StartIncidentRequest::responsePlanArn))
            .setter(setter(Builder::responsePlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responsePlanArn").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(StartIncidentRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<TriggerDetails> TRIGGER_DETAILS_FIELD = SdkField
            .<TriggerDetails> builder(MarshallingType.SDK_POJO).memberName("triggerDetails")
            .getter(getter(StartIncidentRequest::triggerDetails)).setter(setter(Builder::triggerDetails))
            .constructor(TriggerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            IMPACT_FIELD, RELATED_ITEMS_FIELD, RESPONSE_PLAN_ARN_FIELD, TITLE_FIELD, TRIGGER_DETAILS_FIELD));

    private final String clientToken;

    private final Integer impact;

    private final List<RelatedItem> relatedItems;

    private final String responsePlanArn;

    private final String title;

    private final TriggerDetails triggerDetails;

    private StartIncidentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.impact = builder.impact;
        this.relatedItems = builder.relatedItems;
        this.responsePlanArn = builder.responsePlanArn;
        this.title = builder.title;
        this.triggerDetails = builder.triggerDetails;
    }

    /**
     * <p>
     * A token ensuring that the operation is called only once with the specified details.
     * </p>
     * 
     * @return A token ensuring that the operation is called only once with the specified details.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
     * </p>
     * <p class="title">
     * <b>Possible impacts:</b>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>1</code> - Critical impact, this typically relates to full application failure that impacts many to all
     * customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>2</code> - High impact, partial application failure with impact to many customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>3</code> - Medium impact, the application is providing reduced service to customers.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>4</code> - Low impact, customer might aren't impacted by the problem yet.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Defines the impact to the customers. Providing an impact overwrites the impact provided by a response
     *         plan.</p>
     *         <p class="title">
     *         <b>Possible impacts:</b>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>1</code> - Critical impact, this typically relates to full application failure that impacts many to
     *         all customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>2</code> - High impact, partial application failure with impact to many customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>3</code> - Medium impact, the application is providing reduced service to customers.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>4</code> - Low impact, customer might aren't impacted by the problem yet.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid
     *         impact.
     *         </p>
     *         </li>
     */
    public final Integer impact() {
        return impact;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelatedItems() {
        return relatedItems != null && !(relatedItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Add related items to the incident for other responders to use. Related items are Amazon Web Services resources,
     * external links, or files uploaded to an Amazon S3 bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedItems} method.
     * </p>
     * 
     * @return Add related items to the incident for other responders to use. Related items are Amazon Web Services
     *         resources, external links, or files uploaded to an Amazon S3 bucket.
     */
    public final List<RelatedItem> relatedItems() {
        return relatedItems;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat channels, Amazon SNS topics,
     * runbooks, title, and impact of the incident.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat channels, Amazon SNS
     *         topics, runbooks, title, and impact of the incident.
     */
    public final String responsePlanArn() {
        return responsePlanArn;
    }

    /**
     * <p>
     * Provide a title for the incident. Providing a title overwrites the title provided by the response plan.
     * </p>
     * 
     * @return Provide a title for the incident. Providing a title overwrites the title provided by the response plan.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Details of what created the incident record in Incident Manager.
     * </p>
     * 
     * @return Details of what created the incident record in Incident Manager.
     */
    public final TriggerDetails triggerDetails() {
        return triggerDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(impact());
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedItems() ? relatedItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(responsePlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(triggerDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIncidentRequest)) {
            return false;
        }
        StartIncidentRequest other = (StartIncidentRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(impact(), other.impact())
                && hasRelatedItems() == other.hasRelatedItems() && Objects.equals(relatedItems(), other.relatedItems())
                && Objects.equals(responsePlanArn(), other.responsePlanArn()) && Objects.equals(title(), other.title())
                && Objects.equals(triggerDetails(), other.triggerDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartIncidentRequest").add("ClientToken", clientToken()).add("Impact", impact())
                .add("RelatedItems", hasRelatedItems() ? relatedItems() : null).add("ResponsePlanArn", responsePlanArn())
                .add("Title", title()).add("TriggerDetails", triggerDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "impact":
            return Optional.ofNullable(clazz.cast(impact()));
        case "relatedItems":
            return Optional.ofNullable(clazz.cast(relatedItems()));
        case "responsePlanArn":
            return Optional.ofNullable(clazz.cast(responsePlanArn()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "triggerDetails":
            return Optional.ofNullable(clazz.cast(triggerDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartIncidentRequest, T> g) {
        return obj -> g.apply((StartIncidentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmIncidentsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartIncidentRequest> {
        /**
         * <p>
         * A token ensuring that the operation is called only once with the specified details.
         * </p>
         * 
         * @param clientToken
         *        A token ensuring that the operation is called only once with the specified details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Defines the impact to the customers. Providing an impact overwrites the impact provided by a response plan.
         * </p>
         * <p class="title">
         * <b>Possible impacts:</b>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>1</code> - Critical impact, this typically relates to full application failure that impacts many to all
         * customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>2</code> - High impact, partial application failure with impact to many customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>3</code> - Medium impact, the application is providing reduced service to customers.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>4</code> - Low impact, customer might aren't impacted by the problem yet.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid impact.
         * </p>
         * </li>
         * </ul>
         * 
         * @param impact
         *        Defines the impact to the customers. Providing an impact overwrites the impact provided by a response
         *        plan.</p>
         *        <p class="title">
         *        <b>Possible impacts:</b>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>1</code> - Critical impact, this typically relates to full application failure that impacts many
         *        to all customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>2</code> - High impact, partial application failure with impact to many customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>3</code> - Medium impact, the application is providing reduced service to customers.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>4</code> - Low impact, customer might aren't impacted by the problem yet.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>5</code> - No impact, customers aren't currently impacted but urgent action is needed to avoid
         *        impact.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impact(Integer impact);

        /**
         * <p>
         * Add related items to the incident for other responders to use. Related items are Amazon Web Services
         * resources, external links, or files uploaded to an Amazon S3 bucket.
         * </p>
         * 
         * @param relatedItems
         *        Add related items to the incident for other responders to use. Related items are Amazon Web Services
         *        resources, external links, or files uploaded to an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedItems(Collection<RelatedItem> relatedItems);

        /**
         * <p>
         * Add related items to the incident for other responders to use. Related items are Amazon Web Services
         * resources, external links, or files uploaded to an Amazon S3 bucket.
         * </p>
         * 
         * @param relatedItems
         *        Add related items to the incident for other responders to use. Related items are Amazon Web Services
         *        resources, external links, or files uploaded to an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedItems(RelatedItem... relatedItems);

        /**
         * <p>
         * Add related items to the incident for other responders to use. Related items are Amazon Web Services
         * resources, external links, or files uploaded to an Amazon S3 bucket.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ssmincidents.model.RelatedItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.ssmincidents.model.RelatedItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ssmincidents.model.RelatedItem.Builder#build()} is called immediately
         * and its result is passed to {@link #relatedItems(List<RelatedItem>)}.
         * 
         * @param relatedItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ssmincidents.model.RelatedItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedItems(java.util.Collection<RelatedItem>)
         */
        Builder relatedItems(Consumer<RelatedItem.Builder>... relatedItems);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat channels, Amazon SNS
         * topics, runbooks, title, and impact of the incident.
         * </p>
         * 
         * @param responsePlanArn
         *        The Amazon Resource Name (ARN) of the response plan that pre-defines summary, chat channels, Amazon
         *        SNS topics, runbooks, title, and impact of the incident.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responsePlanArn(String responsePlanArn);

        /**
         * <p>
         * Provide a title for the incident. Providing a title overwrites the title provided by the response plan.
         * </p>
         * 
         * @param title
         *        Provide a title for the incident. Providing a title overwrites the title provided by the response
         *        plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Details of what created the incident record in Incident Manager.
         * </p>
         * 
         * @param triggerDetails
         *        Details of what created the incident record in Incident Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerDetails(TriggerDetails triggerDetails);

        /**
         * <p>
         * Details of what created the incident record in Incident Manager.
         * </p>
         * This is a convenience method that creates an instance of the {@link TriggerDetails.Builder} avoiding the need
         * to create one manually via {@link TriggerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TriggerDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #triggerDetails(TriggerDetails)}.
         * 
         * @param triggerDetails
         *        a consumer that will call methods on {@link TriggerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerDetails(TriggerDetails)
         */
        default Builder triggerDetails(Consumer<TriggerDetails.Builder> triggerDetails) {
            return triggerDetails(TriggerDetails.builder().applyMutation(triggerDetails).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmIncidentsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private Integer impact;

        private List<RelatedItem> relatedItems = DefaultSdkAutoConstructList.getInstance();

        private String responsePlanArn;

        private String title;

        private TriggerDetails triggerDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StartIncidentRequest model) {
            super(model);
            clientToken(model.clientToken);
            impact(model.impact);
            relatedItems(model.relatedItems);
            responsePlanArn(model.responsePlanArn);
            title(model.title);
            triggerDetails(model.triggerDetails);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getImpact() {
            return impact;
        }

        public final void setImpact(Integer impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(Integer impact) {
            this.impact = impact;
            return this;
        }

        public final List<RelatedItem.Builder> getRelatedItems() {
            List<RelatedItem.Builder> result = RelatedItemListCopier.copyToBuilder(this.relatedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedItems(Collection<RelatedItem.BuilderImpl> relatedItems) {
            this.relatedItems = RelatedItemListCopier.copyFromBuilder(relatedItems);
        }

        @Override
        public final Builder relatedItems(Collection<RelatedItem> relatedItems) {
            this.relatedItems = RelatedItemListCopier.copy(relatedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedItems(RelatedItem... relatedItems) {
            relatedItems(Arrays.asList(relatedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedItems(Consumer<RelatedItem.Builder>... relatedItems) {
            relatedItems(Stream.of(relatedItems).map(c -> RelatedItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResponsePlanArn() {
            return responsePlanArn;
        }

        public final void setResponsePlanArn(String responsePlanArn) {
            this.responsePlanArn = responsePlanArn;
        }

        @Override
        public final Builder responsePlanArn(String responsePlanArn) {
            this.responsePlanArn = responsePlanArn;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final TriggerDetails.Builder getTriggerDetails() {
            return triggerDetails != null ? triggerDetails.toBuilder() : null;
        }

        public final void setTriggerDetails(TriggerDetails.BuilderImpl triggerDetails) {
            this.triggerDetails = triggerDetails != null ? triggerDetails.build() : null;
        }

        @Override
        public final Builder triggerDetails(TriggerDetails triggerDetails) {
            this.triggerDetails = triggerDetails;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartIncidentRequest build() {
            return new StartIncidentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
