/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmincidents;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ssmincidents.model.AccessDeniedException;
import software.amazon.awssdk.services.ssmincidents.model.ConflictException;
import software.amazon.awssdk.services.ssmincidents.model.CreateReplicationSetRequest;
import software.amazon.awssdk.services.ssmincidents.model.CreateReplicationSetResponse;
import software.amazon.awssdk.services.ssmincidents.model.CreateResponsePlanRequest;
import software.amazon.awssdk.services.ssmincidents.model.CreateResponsePlanResponse;
import software.amazon.awssdk.services.ssmincidents.model.CreateTimelineEventRequest;
import software.amazon.awssdk.services.ssmincidents.model.CreateTimelineEventResponse;
import software.amazon.awssdk.services.ssmincidents.model.DeleteIncidentRecordRequest;
import software.amazon.awssdk.services.ssmincidents.model.DeleteIncidentRecordResponse;
import software.amazon.awssdk.services.ssmincidents.model.DeleteReplicationSetRequest;
import software.amazon.awssdk.services.ssmincidents.model.DeleteReplicationSetResponse;
import software.amazon.awssdk.services.ssmincidents.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.ssmincidents.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.ssmincidents.model.DeleteResponsePlanRequest;
import software.amazon.awssdk.services.ssmincidents.model.DeleteResponsePlanResponse;
import software.amazon.awssdk.services.ssmincidents.model.DeleteTimelineEventRequest;
import software.amazon.awssdk.services.ssmincidents.model.DeleteTimelineEventResponse;
import software.amazon.awssdk.services.ssmincidents.model.GetIncidentRecordRequest;
import software.amazon.awssdk.services.ssmincidents.model.GetIncidentRecordResponse;
import software.amazon.awssdk.services.ssmincidents.model.GetReplicationSetRequest;
import software.amazon.awssdk.services.ssmincidents.model.GetReplicationSetResponse;
import software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesRequest;
import software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesResponse;
import software.amazon.awssdk.services.ssmincidents.model.GetResponsePlanRequest;
import software.amazon.awssdk.services.ssmincidents.model.GetResponsePlanResponse;
import software.amazon.awssdk.services.ssmincidents.model.GetTimelineEventRequest;
import software.amazon.awssdk.services.ssmincidents.model.GetTimelineEventResponse;
import software.amazon.awssdk.services.ssmincidents.model.InternalServerException;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsResponse;
import software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsResponse;
import software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsResponse;
import software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansResponse;
import software.amazon.awssdk.services.ssmincidents.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsResponse;
import software.amazon.awssdk.services.ssmincidents.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.ssmincidents.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.ssmincidents.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssmincidents.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsException;
import software.amazon.awssdk.services.ssmincidents.model.StartIncidentRequest;
import software.amazon.awssdk.services.ssmincidents.model.StartIncidentResponse;
import software.amazon.awssdk.services.ssmincidents.model.TagResourceRequest;
import software.amazon.awssdk.services.ssmincidents.model.TagResourceResponse;
import software.amazon.awssdk.services.ssmincidents.model.ThrottlingException;
import software.amazon.awssdk.services.ssmincidents.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssmincidents.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssmincidents.model.UpdateDeletionProtectionRequest;
import software.amazon.awssdk.services.ssmincidents.model.UpdateDeletionProtectionResponse;
import software.amazon.awssdk.services.ssmincidents.model.UpdateIncidentRecordRequest;
import software.amazon.awssdk.services.ssmincidents.model.UpdateIncidentRecordResponse;
import software.amazon.awssdk.services.ssmincidents.model.UpdateRelatedItemsRequest;
import software.amazon.awssdk.services.ssmincidents.model.UpdateRelatedItemsResponse;
import software.amazon.awssdk.services.ssmincidents.model.UpdateReplicationSetRequest;
import software.amazon.awssdk.services.ssmincidents.model.UpdateReplicationSetResponse;
import software.amazon.awssdk.services.ssmincidents.model.UpdateResponsePlanRequest;
import software.amazon.awssdk.services.ssmincidents.model.UpdateResponsePlanResponse;
import software.amazon.awssdk.services.ssmincidents.model.UpdateTimelineEventRequest;
import software.amazon.awssdk.services.ssmincidents.model.UpdateTimelineEventResponse;
import software.amazon.awssdk.services.ssmincidents.model.ValidationException;
import software.amazon.awssdk.services.ssmincidents.paginators.GetResourcePoliciesIterable;
import software.amazon.awssdk.services.ssmincidents.paginators.ListIncidentRecordsIterable;
import software.amazon.awssdk.services.ssmincidents.paginators.ListRelatedItemsIterable;
import software.amazon.awssdk.services.ssmincidents.paginators.ListReplicationSetsIterable;
import software.amazon.awssdk.services.ssmincidents.paginators.ListResponsePlansIterable;
import software.amazon.awssdk.services.ssmincidents.paginators.ListTimelineEventsIterable;
import software.amazon.awssdk.services.ssmincidents.waiters.SsmIncidentsWaiter;

/**
 * Service client for accessing SSM Incidents. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Systems Manager Incident Manager is an incident management console designed to help users mitigate and recover from
 * incidents affecting their Amazon Web Services-hosted applications. An incident is any unplanned interruption or
 * reduction in quality of services.
 * </p>
 * <p>
 * Incident Manager increases incident resolution by notifying responders of impact, highlighting relevant
 * troubleshooting data, and providing collaboration tools to get services back up and running. To achieve the primary
 * goal of reducing the time-to-resolution of critical incidents, Incident Manager automates response plans and enables
 * responder team escalation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SsmIncidentsClient extends AwsClient {
    String SERVICE_NAME = "ssm-incidents";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ssm-incidents";

    /**
     * <p>
     * A replication set replicates and encrypts your data to the provided Regions with the provided KMS key.
     * </p>
     *
     * @param createReplicationSetRequest
     * @return Result of the CreateReplicationSet operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.CreateReplicationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateReplicationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationSetResponse createReplicationSet(CreateReplicationSetRequest createReplicationSetRequest)
            throws ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, ValidationException,
            ConflictException, InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A replication set replicates and encrypts your data to the provided Regions with the provided KMS key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReplicationSetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReplicationSetRequest#builder()}
     * </p>
     *
     * @param createReplicationSetRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationSetInput.Builder} to create a
     *        request.
     * @return Result of the CreateReplicationSet operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.CreateReplicationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateReplicationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationSetResponse createReplicationSet(
            Consumer<CreateReplicationSetRequest.Builder> createReplicationSetRequest) throws ServiceQuotaExceededException,
            ThrottlingException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, SsmIncidentsException {
        return createReplicationSet(CreateReplicationSetRequest.builder().applyMutation(createReplicationSetRequest).build());
    }

    /**
     * <p>
     * Creates a response plan that automates the initial response to incidents. A response plan engages contacts,
     * starts chat channel collaboration, and initiates runbooks at the beginning of an incident.
     * </p>
     *
     * @param createResponsePlanRequest
     * @return Result of the CreateResponsePlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.CreateResponsePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateResponsePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResponsePlanResponse createResponsePlan(CreateResponsePlanRequest createResponsePlanRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a response plan that automates the initial response to incidents. A response plan engages contacts,
     * starts chat channel collaboration, and initiates runbooks at the beginning of an incident.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResponsePlanRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResponsePlanRequest#builder()}
     * </p>
     *
     * @param createResponsePlanRequest
     *        A {@link Consumer} that will call methods on {@link CreateResponsePlanInput.Builder} to create a request.
     * @return Result of the CreateResponsePlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.CreateResponsePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateResponsePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResponsePlanResponse createResponsePlan(Consumer<CreateResponsePlanRequest.Builder> createResponsePlanRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return createResponsePlan(CreateResponsePlanRequest.builder().applyMutation(createResponsePlanRequest).build());
    }

    /**
     * <p>
     * Creates a custom timeline event on the incident details page of an incident record. Incident Manager
     * automatically creates timeline events that mark key moments during an incident. You can create custom timeline
     * events to mark important events that Incident Manager can detect automatically.
     * </p>
     *
     * @param createTimelineEventRequest
     * @return Result of the CreateTimelineEvent operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.CreateTimelineEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateTimelineEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTimelineEventResponse createTimelineEvent(CreateTimelineEventRequest createTimelineEventRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom timeline event on the incident details page of an incident record. Incident Manager
     * automatically creates timeline events that mark key moments during an incident. You can create custom timeline
     * events to mark important events that Incident Manager can detect automatically.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTimelineEventRequest.Builder} avoiding the
     * need to create one manually via {@link CreateTimelineEventRequest#builder()}
     * </p>
     *
     * @param createTimelineEventRequest
     *        A {@link Consumer} that will call methods on {@link CreateTimelineEventInput.Builder} to create a request.
     * @return Result of the CreateTimelineEvent operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.CreateTimelineEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/CreateTimelineEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateTimelineEventResponse createTimelineEvent(
            Consumer<CreateTimelineEventRequest.Builder> createTimelineEventRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, SsmIncidentsException {
        return createTimelineEvent(CreateTimelineEventRequest.builder().applyMutation(createTimelineEventRequest).build());
    }

    /**
     * <p>
     * Delete an incident record from Incident Manager.
     * </p>
     *
     * @param deleteIncidentRecordRequest
     * @return Result of the DeleteIncidentRecord operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteIncidentRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteIncidentRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIncidentRecordResponse deleteIncidentRecord(DeleteIncidentRecordRequest deleteIncidentRecordRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an incident record from Incident Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIncidentRecordRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIncidentRecordRequest#builder()}
     * </p>
     *
     * @param deleteIncidentRecordRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIncidentRecordInput.Builder} to create a
     *        request.
     * @return Result of the DeleteIncidentRecord operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteIncidentRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteIncidentRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIncidentRecordResponse deleteIncidentRecord(
            Consumer<DeleteIncidentRecordRequest.Builder> deleteIncidentRecordRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return deleteIncidentRecord(DeleteIncidentRecordRequest.builder().applyMutation(deleteIncidentRecordRequest).build());
    }

    /**
     * <p>
     * Deletes all Regions in your replication set. Deleting the replication set deletes all Incident Manager data.
     * </p>
     *
     * @param deleteReplicationSetRequest
     * @return Result of the DeleteReplicationSet operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteReplicationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteReplicationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationSetResponse deleteReplicationSet(DeleteReplicationSetRequest deleteReplicationSetRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes all Regions in your replication set. Deleting the replication set deletes all Incident Manager data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReplicationSetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReplicationSetRequest#builder()}
     * </p>
     *
     * @param deleteReplicationSetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationSetInput.Builder} to create a
     *        request.
     * @return Result of the DeleteReplicationSet operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteReplicationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteReplicationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationSetResponse deleteReplicationSet(
            Consumer<DeleteReplicationSetRequest.Builder> deleteReplicationSetRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return deleteReplicationSet(DeleteReplicationSetRequest.builder().applyMutation(deleteReplicationSetRequest).build());
    }

    /**
     * <p>
     * Deletes the resource policy that Resource Access Manager uses to share your Incident Manager resource.
     * </p>
     *
     * @param deleteResourcePolicyRequest
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource policy that Resource Access Manager uses to share your Incident Manager resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourcePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourcePolicyRequest#builder()}
     * </p>
     *
     * @param deleteResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourcePolicyInput.Builder} to create a
     *        request.
     * @return Result of the DeleteResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourcePolicyResponse deleteResourcePolicy(
            Consumer<DeleteResourcePolicyRequest.Builder> deleteResourcePolicyRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return deleteResourcePolicy(DeleteResourcePolicyRequest.builder().applyMutation(deleteResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch alarms and EventBridge
     * events from creating an incident with this response plan.
     * </p>
     *
     * @param deleteResponsePlanRequest
     * @return Result of the DeleteResponsePlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteResponsePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteResponsePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResponsePlanResponse deleteResponsePlan(DeleteResponsePlanRequest deleteResponsePlanRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified response plan. Deleting a response plan stops all linked CloudWatch alarms and EventBridge
     * events from creating an incident with this response plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResponsePlanRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResponsePlanRequest#builder()}
     * </p>
     *
     * @param deleteResponsePlanRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResponsePlanInput.Builder} to create a request.
     * @return Result of the DeleteResponsePlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteResponsePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteResponsePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResponsePlanResponse deleteResponsePlan(Consumer<DeleteResponsePlanRequest.Builder> deleteResponsePlanRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return deleteResponsePlan(DeleteResponsePlanRequest.builder().applyMutation(deleteResponsePlanRequest).build());
    }

    /**
     * <p>
     * Deletes a timeline event from an incident.
     * </p>
     *
     * @param deleteTimelineEventRequest
     * @return Result of the DeleteTimelineEvent operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteTimelineEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteTimelineEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTimelineEventResponse deleteTimelineEvent(DeleteTimelineEventRequest deleteTimelineEventRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a timeline event from an incident.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTimelineEventRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteTimelineEventRequest#builder()}
     * </p>
     *
     * @param deleteTimelineEventRequest
     *        A {@link Consumer} that will call methods on {@link DeleteTimelineEventInput.Builder} to create a request.
     * @return Result of the DeleteTimelineEvent operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.DeleteTimelineEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/DeleteTimelineEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteTimelineEventResponse deleteTimelineEvent(
            Consumer<DeleteTimelineEventRequest.Builder> deleteTimelineEventRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return deleteTimelineEvent(DeleteTimelineEventRequest.builder().applyMutation(deleteTimelineEventRequest).build());
    }

    /**
     * <p>
     * Returns the details for the specified incident record.
     * </p>
     *
     * @param getIncidentRecordRequest
     * @return Result of the GetIncidentRecord operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetIncidentRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetIncidentRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIncidentRecordResponse getIncidentRecord(GetIncidentRecordRequest getIncidentRecordRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the specified incident record.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIncidentRecordRequest.Builder} avoiding the need
     * to create one manually via {@link GetIncidentRecordRequest#builder()}
     * </p>
     *
     * @param getIncidentRecordRequest
     *        A {@link Consumer} that will call methods on {@link GetIncidentRecordInput.Builder} to create a request.
     * @return Result of the GetIncidentRecord operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetIncidentRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetIncidentRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIncidentRecordResponse getIncidentRecord(Consumer<GetIncidentRecordRequest.Builder> getIncidentRecordRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return getIncidentRecord(GetIncidentRecordRequest.builder().applyMutation(getIncidentRecordRequest).build());
    }

    /**
     * <p>
     * Retrieve your Incident Manager replication set.
     * </p>
     *
     * @param getReplicationSetRequest
     * @return Result of the GetReplicationSet operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetReplicationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetReplicationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReplicationSetResponse getReplicationSet(GetReplicationSetRequest getReplicationSetRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve your Incident Manager replication set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationSetRequest.Builder} avoiding the need
     * to create one manually via {@link GetReplicationSetRequest#builder()}
     * </p>
     *
     * @param getReplicationSetRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationSetInput.Builder} to create a request.
     * @return Result of the GetReplicationSet operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetReplicationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetReplicationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReplicationSetResponse getReplicationSet(Consumer<GetReplicationSetRequest.Builder> getReplicationSetRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return getReplicationSet(GetReplicationSetRequest.builder().applyMutation(getReplicationSetRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource policies attached to the specified response plan.
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return Result of the GetResourcePolicies operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResourcePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePoliciesResponse getResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource policies attached to the specified response plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesInput.Builder} to create a request.
     * @return Result of the GetResourcePolicies operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResourcePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePoliciesResponse getResourcePolicies(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return getResourcePolicies(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource policies attached to the specified response plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.GetResourcePoliciesIterable responses = client
     *             .getResourcePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getResourcePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResourcePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePoliciesIterable getResourcePoliciesPaginator(GetResourcePoliciesRequest getResourcePoliciesRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return new GetResourcePoliciesIterable(this, getResourcePoliciesRequest);
    }

    /**
     * <p>
     * Retrieves the resource policies attached to the specified response plan.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.GetResourcePoliciesIterable responses = client
     *             .getResourcePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.GetResourcePoliciesIterable responses = client.getResourcePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcePolicies(software.amazon.awssdk.services.ssmincidents.model.GetResourcePoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourcePoliciesRequest#builder()}
     * </p>
     *
     * @param getResourcePoliciesRequest
     *        A {@link Consumer} that will call methods on {@link GetResourcePoliciesInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetResourcePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResourcePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcePoliciesIterable getResourcePoliciesPaginator(
            Consumer<GetResourcePoliciesRequest.Builder> getResourcePoliciesRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return getResourcePoliciesPaginator(GetResourcePoliciesRequest.builder().applyMutation(getResourcePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the details of the specified response plan.
     * </p>
     *
     * @param getResponsePlanRequest
     * @return Result of the GetResponsePlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetResponsePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResponsePlan" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResponsePlanResponse getResponsePlan(GetResponsePlanRequest getResponsePlanRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of the specified response plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResponsePlanRequest.Builder} avoiding the need
     * to create one manually via {@link GetResponsePlanRequest#builder()}
     * </p>
     *
     * @param getResponsePlanRequest
     *        A {@link Consumer} that will call methods on {@link GetResponsePlanInput.Builder} to create a request.
     * @return Result of the GetResponsePlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetResponsePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetResponsePlan" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResponsePlanResponse getResponsePlan(Consumer<GetResponsePlanRequest.Builder> getResponsePlanRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return getResponsePlan(GetResponsePlanRequest.builder().applyMutation(getResponsePlanRequest).build());
    }

    /**
     * <p>
     * Retrieves a timeline event based on its ID and incident record.
     * </p>
     *
     * @param getTimelineEventRequest
     * @return Result of the GetTimelineEvent operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetTimelineEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetTimelineEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTimelineEventResponse getTimelineEvent(GetTimelineEventRequest getTimelineEventRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a timeline event based on its ID and incident record.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTimelineEventRequest.Builder} avoiding the need
     * to create one manually via {@link GetTimelineEventRequest#builder()}
     * </p>
     *
     * @param getTimelineEventRequest
     *        A {@link Consumer} that will call methods on {@link GetTimelineEventInput.Builder} to create a request.
     * @return Result of the GetTimelineEvent operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.GetTimelineEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/GetTimelineEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default GetTimelineEventResponse getTimelineEvent(Consumer<GetTimelineEventRequest.Builder> getTimelineEventRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return getTimelineEvent(GetTimelineEventRequest.builder().applyMutation(getTimelineEventRequest).build());
    }

    /**
     * <p>
     * Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the
     * incident record you want to update.
     * </p>
     *
     * @param listIncidentRecordsRequest
     * @return Result of the ListIncidentRecords operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListIncidentRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListIncidentRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIncidentRecordsResponse listIncidentRecords(ListIncidentRecordsRequest listIncidentRecordsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the
     * incident record you want to update.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIncidentRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIncidentRecordsRequest#builder()}
     * </p>
     *
     * @param listIncidentRecordsRequest
     *        A {@link Consumer} that will call methods on {@link ListIncidentRecordsInput.Builder} to create a request.
     * @return Result of the ListIncidentRecords operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListIncidentRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListIncidentRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIncidentRecordsResponse listIncidentRecords(
            Consumer<ListIncidentRecordsRequest.Builder> listIncidentRecordsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return listIncidentRecords(ListIncidentRecordsRequest.builder().applyMutation(listIncidentRecordsRequest).build());
    }

    /**
     * <p>
     * Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the
     * incident record you want to update.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIncidentRecords(software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListIncidentRecordsIterable responses = client.listIncidentRecordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListIncidentRecordsIterable responses = client
     *             .listIncidentRecordsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListIncidentRecordsIterable responses = client.listIncidentRecordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIncidentRecords(software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIncidentRecordsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListIncidentRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListIncidentRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIncidentRecordsIterable listIncidentRecordsPaginator(ListIncidentRecordsRequest listIncidentRecordsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return new ListIncidentRecordsIterable(this, listIncidentRecordsRequest);
    }

    /**
     * <p>
     * Lists all incident records in your account. Use this command to retrieve the Amazon Resource Name (ARN) of the
     * incident record you want to update.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIncidentRecords(software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListIncidentRecordsIterable responses = client.listIncidentRecordsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListIncidentRecordsIterable responses = client
     *             .listIncidentRecordsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListIncidentRecordsIterable responses = client.listIncidentRecordsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIncidentRecords(software.amazon.awssdk.services.ssmincidents.model.ListIncidentRecordsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIncidentRecordsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIncidentRecordsRequest#builder()}
     * </p>
     *
     * @param listIncidentRecordsRequest
     *        A {@link Consumer} that will call methods on {@link ListIncidentRecordsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListIncidentRecords
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListIncidentRecords"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIncidentRecordsIterable listIncidentRecordsPaginator(
            Consumer<ListIncidentRecordsRequest.Builder> listIncidentRecordsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return listIncidentRecordsPaginator(ListIncidentRecordsRequest.builder().applyMutation(listIncidentRecordsRequest)
                .build());
    }

    /**
     * <p>
     * List all related items for an incident record.
     * </p>
     *
     * @param listRelatedItemsRequest
     * @return Result of the ListRelatedItems operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelatedItemsResponse listRelatedItems(ListRelatedItemsRequest listRelatedItemsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all related items for an incident record.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelatedItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRelatedItemsRequest#builder()}
     * </p>
     *
     * @param listRelatedItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListRelatedItemsInput.Builder} to create a request.
     * @return Result of the ListRelatedItems operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelatedItemsResponse listRelatedItems(Consumer<ListRelatedItemsRequest.Builder> listRelatedItemsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return listRelatedItems(ListRelatedItemsRequest.builder().applyMutation(listRelatedItemsRequest).build());
    }

    /**
     * <p>
     * List all related items for an incident record.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRelatedItems(software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListRelatedItemsIterable responses = client.listRelatedItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListRelatedItemsIterable responses = client
     *             .listRelatedItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListRelatedItemsIterable responses = client.listRelatedItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelatedItems(software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRelatedItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelatedItemsIterable listRelatedItemsPaginator(ListRelatedItemsRequest listRelatedItemsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return new ListRelatedItemsIterable(this, listRelatedItemsRequest);
    }

    /**
     * <p>
     * List all related items for an incident record.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRelatedItems(software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListRelatedItemsIterable responses = client.listRelatedItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListRelatedItemsIterable responses = client
     *             .listRelatedItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListRelatedItemsIterable responses = client.listRelatedItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRelatedItems(software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRelatedItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListRelatedItemsRequest#builder()}
     * </p>
     *
     * @param listRelatedItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListRelatedItemsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRelatedItemsIterable listRelatedItemsPaginator(Consumer<ListRelatedItemsRequest.Builder> listRelatedItemsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return listRelatedItemsPaginator(ListRelatedItemsRequest.builder().applyMutation(listRelatedItemsRequest).build());
    }

    /**
     * <p>
     * Lists details about the replication set configured in your account.
     * </p>
     *
     * @param listReplicationSetsRequest
     * @return Result of the ListReplicationSets operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListReplicationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListReplicationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReplicationSetsResponse listReplicationSets(ListReplicationSetsRequest listReplicationSetsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about the replication set configured in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReplicationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReplicationSetsRequest#builder()}
     * </p>
     *
     * @param listReplicationSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListReplicationSetsInput.Builder} to create a request.
     * @return Result of the ListReplicationSets operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListReplicationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListReplicationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReplicationSetsResponse listReplicationSets(
            Consumer<ListReplicationSetsRequest.Builder> listReplicationSetsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return listReplicationSets(ListReplicationSetsRequest.builder().applyMutation(listReplicationSetsRequest).build());
    }

    /**
     * <p>
     * Lists details about the replication set configured in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReplicationSets(software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListReplicationSetsIterable responses = client.listReplicationSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListReplicationSetsIterable responses = client
     *             .listReplicationSetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListReplicationSetsIterable responses = client.listReplicationSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReplicationSets(software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReplicationSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListReplicationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListReplicationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReplicationSetsIterable listReplicationSetsPaginator(ListReplicationSetsRequest listReplicationSetsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return new ListReplicationSetsIterable(this, listReplicationSetsRequest);
    }

    /**
     * <p>
     * Lists details about the replication set configured in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listReplicationSets(software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListReplicationSetsIterable responses = client.listReplicationSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListReplicationSetsIterable responses = client
     *             .listReplicationSetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListReplicationSetsIterable responses = client.listReplicationSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReplicationSets(software.amazon.awssdk.services.ssmincidents.model.ListReplicationSetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReplicationSetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReplicationSetsRequest#builder()}
     * </p>
     *
     * @param listReplicationSetsRequest
     *        A {@link Consumer} that will call methods on {@link ListReplicationSetsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListReplicationSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListReplicationSets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReplicationSetsIterable listReplicationSetsPaginator(
            Consumer<ListReplicationSetsRequest.Builder> listReplicationSetsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return listReplicationSetsPaginator(ListReplicationSetsRequest.builder().applyMutation(listReplicationSetsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all response plans in your account.
     * </p>
     *
     * @param listResponsePlansRequest
     * @return Result of the ListResponsePlans operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListResponsePlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListResponsePlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponsePlansResponse listResponsePlans(ListResponsePlansRequest listResponsePlansRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all response plans in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResponsePlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListResponsePlansRequest#builder()}
     * </p>
     *
     * @param listResponsePlansRequest
     *        A {@link Consumer} that will call methods on {@link ListResponsePlansInput.Builder} to create a request.
     * @return Result of the ListResponsePlans operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListResponsePlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListResponsePlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponsePlansResponse listResponsePlans(Consumer<ListResponsePlansRequest.Builder> listResponsePlansRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return listResponsePlans(ListResponsePlansRequest.builder().applyMutation(listResponsePlansRequest).build());
    }

    /**
     * <p>
     * Lists all response plans in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResponsePlans(software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListResponsePlansIterable responses = client.listResponsePlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListResponsePlansIterable responses = client
     *             .listResponsePlansPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListResponsePlansIterable responses = client.listResponsePlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResponsePlans(software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResponsePlansRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListResponsePlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListResponsePlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponsePlansIterable listResponsePlansPaginator(ListResponsePlansRequest listResponsePlansRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return new ListResponsePlansIterable(this, listResponsePlansRequest);
    }

    /**
     * <p>
     * Lists all response plans in your account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResponsePlans(software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListResponsePlansIterable responses = client.listResponsePlansPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListResponsePlansIterable responses = client
     *             .listResponsePlansPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListResponsePlansIterable responses = client.listResponsePlansPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResponsePlans(software.amazon.awssdk.services.ssmincidents.model.ListResponsePlansRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResponsePlansRequest.Builder} avoiding the need
     * to create one manually via {@link ListResponsePlansRequest#builder()}
     * </p>
     *
     * @param listResponsePlansRequest
     *        A {@link Consumer} that will call methods on {@link ListResponsePlansInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListResponsePlans
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListResponsePlans"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResponsePlansIterable listResponsePlansPaginator(
            Consumer<ListResponsePlansRequest.Builder> listResponsePlansRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return listResponsePlansPaginator(ListResponsePlansRequest.builder().applyMutation(listResponsePlansRequest).build());
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified response plan.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified response plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists timeline events for the specified incident record.
     * </p>
     *
     * @param listTimelineEventsRequest
     * @return Result of the ListTimelineEvents operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListTimelineEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTimelineEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimelineEventsResponse listTimelineEvents(ListTimelineEventsRequest listTimelineEventsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists timeline events for the specified incident record.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimelineEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTimelineEventsRequest#builder()}
     * </p>
     *
     * @param listTimelineEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListTimelineEventsInput.Builder} to create a request.
     * @return Result of the ListTimelineEvents operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListTimelineEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTimelineEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimelineEventsResponse listTimelineEvents(Consumer<ListTimelineEventsRequest.Builder> listTimelineEventsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return listTimelineEvents(ListTimelineEventsRequest.builder().applyMutation(listTimelineEventsRequest).build());
    }

    /**
     * <p>
     * Lists timeline events for the specified incident record.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTimelineEvents(software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListTimelineEventsIterable responses = client.listTimelineEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListTimelineEventsIterable responses = client
     *             .listTimelineEventsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListTimelineEventsIterable responses = client.listTimelineEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimelineEvents(software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTimelineEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListTimelineEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTimelineEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimelineEventsIterable listTimelineEventsPaginator(ListTimelineEventsRequest listTimelineEventsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return new ListTimelineEventsIterable(this, listTimelineEventsRequest);
    }

    /**
     * <p>
     * Lists timeline events for the specified incident record.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTimelineEvents(software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListTimelineEventsIterable responses = client.listTimelineEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssmincidents.paginators.ListTimelineEventsIterable responses = client
     *             .listTimelineEventsPaginator(request);
     *     for (software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssmincidents.paginators.ListTimelineEventsIterable responses = client.listTimelineEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTimelineEvents(software.amazon.awssdk.services.ssmincidents.model.ListTimelineEventsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTimelineEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTimelineEventsRequest#builder()}
     * </p>
     *
     * @param listTimelineEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListTimelineEventsInput.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.ListTimelineEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/ListTimelineEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTimelineEventsIterable listTimelineEventsPaginator(
            Consumer<ListTimelineEventsRequest.Builder> listTimelineEventsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return listTimelineEventsPaginator(ListTimelineEventsRequest.builder().applyMutation(listTimelineEventsRequest).build());
    }

    /**
     * <p>
     * Adds a resource policy to the specified response plan. The resource policy is used to share the response plan
     * using Resource Access Manager (RAM). For more information about cross-account sharing, see <a href=
     * "https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-manager-cross-account-cross-region.html"
     * >Cross-Region and cross-account incident management</a>.
     * </p>
     *
     * @param putResourcePolicyRequest
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a resource policy to the specified response plan. The resource policy is used to share the response plan
     * using Resource Access Manager (RAM). For more information about cross-account sharing, see <a href=
     * "https://docs.aws.amazon.com/incident-manager/latest/userguide/incident-manager-cross-account-cross-region.html"
     * >Cross-Region and cross-account incident management</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutResourcePolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutResourcePolicyRequest#builder()}
     * </p>
     *
     * @param putResourcePolicyRequest
     *        A {@link Consumer} that will call methods on {@link PutResourcePolicyInput.Builder} to create a request.
     * @return Result of the PutResourcePolicy operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.PutResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/PutResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default PutResourcePolicyResponse putResourcePolicy(Consumer<PutResourcePolicyRequest.Builder> putResourcePolicyRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return putResourcePolicy(PutResourcePolicyRequest.builder().applyMutation(putResourcePolicyRequest).build());
    }

    /**
     * <p>
     * Used to start an incident from CloudWatch alarms, EventBridge events, or manually.
     * </p>
     *
     * @param startIncidentRequest
     * @return Result of the StartIncident operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.StartIncident
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/StartIncident" target="_top">AWS
     *      API Documentation</a>
     */
    default StartIncidentResponse startIncident(StartIncidentRequest startIncidentRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to start an incident from CloudWatch alarms, EventBridge events, or manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartIncidentRequest.Builder} avoiding the need to
     * create one manually via {@link StartIncidentRequest#builder()}
     * </p>
     *
     * @param startIncidentRequest
     *        A {@link Consumer} that will call methods on {@link StartIncidentInput.Builder} to create a request.
     * @return Result of the StartIncident operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.StartIncident
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/StartIncident" target="_top">AWS
     *      API Documentation</a>
     */
    default StartIncidentResponse startIncident(Consumer<StartIncidentRequest.Builder> startIncidentRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return startIncident(StartIncidentRequest.builder().applyMutation(startIncidentRequest).build());
    }

    /**
     * <p>
     * Adds a tag to a response plan.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a tag to a response plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         Request would cause a service quota to be exceeded.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ResourceNotFoundException, AccessDeniedException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            SsmIncidentsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update deletion protection to either allow or deny deletion of the final Region in a replication set.
     * </p>
     *
     * @param updateDeletionProtectionRequest
     * @return Result of the UpdateDeletionProtection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateDeletionProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateDeletionProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeletionProtectionResponse updateDeletionProtection(
            UpdateDeletionProtectionRequest updateDeletionProtectionRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update deletion protection to either allow or deny deletion of the final Region in a replication set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDeletionProtectionRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateDeletionProtectionRequest#builder()}
     * </p>
     *
     * @param updateDeletionProtectionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDeletionProtectionInput.Builder} to create a
     *        request.
     * @return Result of the UpdateDeletionProtection operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateDeletionProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateDeletionProtection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDeletionProtectionResponse updateDeletionProtection(
            Consumer<UpdateDeletionProtectionRequest.Builder> updateDeletionProtectionRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, SsmIncidentsException {
        return updateDeletionProtection(UpdateDeletionProtectionRequest.builder().applyMutation(updateDeletionProtectionRequest)
                .build());
    }

    /**
     * <p>
     * Update the details of an incident record. You can use this operation to update an incident record from the
     * defined chat channel. For more information about using actions in chat channels, see <a
     * href="https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact">Interacting through
     * chat</a>.
     * </p>
     *
     * @param updateIncidentRecordRequest
     * @return Result of the UpdateIncidentRecord operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateIncidentRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateIncidentRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIncidentRecordResponse updateIncidentRecord(UpdateIncidentRecordRequest updateIncidentRecordRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the details of an incident record. You can use this operation to update an incident record from the
     * defined chat channel. For more information about using actions in chat channels, see <a
     * href="https://docs.aws.amazon.com/incident-manager/latest/userguide/chat.html#chat-interact">Interacting through
     * chat</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIncidentRecordRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIncidentRecordRequest#builder()}
     * </p>
     *
     * @param updateIncidentRecordRequest
     *        A {@link Consumer} that will call methods on {@link UpdateIncidentRecordInput.Builder} to create a
     *        request.
     * @return Result of the UpdateIncidentRecord operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateIncidentRecord
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateIncidentRecord"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIncidentRecordResponse updateIncidentRecord(
            Consumer<UpdateIncidentRecordRequest.Builder> updateIncidentRecordRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, SsmIncidentsException {
        return updateIncidentRecord(UpdateIncidentRecordRequest.builder().applyMutation(updateIncidentRecordRequest).build());
    }

    /**
     * <p>
     * Add or remove related items from the related items tab of an incident record.
     * </p>
     *
     * @param updateRelatedItemsRequest
     * @return Result of the UpdateRelatedItems operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRelatedItemsResponse updateRelatedItems(UpdateRelatedItemsRequest updateRelatedItemsRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add or remove related items from the related items tab of an incident record.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRelatedItemsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateRelatedItemsRequest#builder()}
     * </p>
     *
     * @param updateRelatedItemsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateRelatedItemsInput.Builder} to create a request.
     * @return Result of the UpdateRelatedItems operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRelatedItemsResponse updateRelatedItems(Consumer<UpdateRelatedItemsRequest.Builder> updateRelatedItemsRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return updateRelatedItems(UpdateRelatedItemsRequest.builder().applyMutation(updateRelatedItemsRequest).build());
    }

    /**
     * <p>
     * Add or delete Regions from your replication set.
     * </p>
     *
     * @param updateReplicationSetRequest
     * @return Result of the UpdateReplicationSet operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateReplicationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateReplicationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationSetResponse updateReplicationSet(UpdateReplicationSetRequest updateReplicationSetRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Add or delete Regions from your replication set.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReplicationSetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateReplicationSetRequest#builder()}
     * </p>
     *
     * @param updateReplicationSetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationSetInput.Builder} to create a
     *        request.
     * @return Result of the UpdateReplicationSet operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateReplicationSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateReplicationSet"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationSetResponse updateReplicationSet(
            Consumer<UpdateReplicationSetRequest.Builder> updateReplicationSetRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, SsmIncidentsException {
        return updateReplicationSet(UpdateReplicationSetRequest.builder().applyMutation(updateReplicationSetRequest).build());
    }

    /**
     * <p>
     * Updates the specified response plan.
     * </p>
     *
     * @param updateResponsePlanRequest
     * @return Result of the UpdateResponsePlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateResponsePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateResponsePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResponsePlanResponse updateResponsePlan(UpdateResponsePlanRequest updateResponsePlanRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified response plan.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResponsePlanRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateResponsePlanRequest#builder()}
     * </p>
     *
     * @param updateResponsePlanRequest
     *        A {@link Consumer} that will call methods on {@link UpdateResponsePlanInput.Builder} to create a request.
     * @return Result of the UpdateResponsePlan operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateResponsePlan
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateResponsePlan"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateResponsePlanResponse updateResponsePlan(Consumer<UpdateResponsePlanRequest.Builder> updateResponsePlanRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        return updateResponsePlan(UpdateResponsePlanRequest.builder().applyMutation(updateResponsePlanRequest).build());
    }

    /**
     * <p>
     * Updates a timeline event. You can update events of type <code>Custom Event</code>.
     * </p>
     *
     * @param updateTimelineEventRequest
     * @return Result of the UpdateTimelineEvent operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateTimelineEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateTimelineEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTimelineEventResponse updateTimelineEvent(UpdateTimelineEventRequest updateTimelineEventRequest)
            throws ThrottlingException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, SsmIncidentsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a timeline event. You can update events of type <code>Custom Event</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTimelineEventRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateTimelineEventRequest#builder()}
     * </p>
     *
     * @param updateTimelineEventRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTimelineEventInput.Builder} to create a request.
     * @return Result of the UpdateTimelineEvent operation returned by the service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ResourceNotFoundException
     *         Request references a resource which doesn't exist.
     * @throws AccessDeniedException
     *         You don't have sufficient access to perform this operation.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ConflictException
     *         Updating or deleting a resource causes an inconsistent state.
     * @throws InternalServerException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmIncidentsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmIncidentsClient.UpdateTimelineEvent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-incidents-2018-05-10/UpdateTimelineEvent"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateTimelineEventResponse updateTimelineEvent(
            Consumer<UpdateTimelineEventRequest.Builder> updateTimelineEventRequest) throws ThrottlingException,
            ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, SsmIncidentsException {
        return updateTimelineEvent(UpdateTimelineEventRequest.builder().applyMutation(updateTimelineEventRequest).build());
    }

    /**
     * Create an instance of {@link SsmIncidentsWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link SsmIncidentsWaiter}
     */
    default SsmIncidentsWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link SsmIncidentsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmIncidentsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmIncidentsClient}.
     */
    static SsmIncidentsClientBuilder builder() {
        return new DefaultSsmIncidentsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SsmIncidentsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
