/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmincidents.SsmIncidentsClient;
import software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsRequest;
import software.amazon.awssdk.services.ssmincidents.model.ListRelatedItemsResponse;
import software.amazon.awssdk.services.ssmincidents.model.RelatedItem;

public class ListRelatedItemsIterable
implements SdkIterable<ListRelatedItemsResponse> {
    private final SsmIncidentsClient client;
    private final ListRelatedItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRelatedItemsIterable(SsmIncidentsClient client, ListRelatedItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListRelatedItemsResponseFetcher();
    }

    public Iterator<ListRelatedItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RelatedItem> relatedItems() {
        Function<ListRelatedItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedItems() != null) {
                return response.relatedItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRelatedItemsResponseFetcher
    implements SyncPageFetcher<ListRelatedItemsResponse> {
        private ListRelatedItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListRelatedItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRelatedItemsResponse nextPage(ListRelatedItemsResponse previousPage) {
            if (previousPage == null) {
                return ListRelatedItemsIterable.this.client.listRelatedItems(ListRelatedItemsIterable.this.firstRequest);
            }
            return ListRelatedItemsIterable.this.client.listRelatedItems((ListRelatedItemsRequest)((Object)ListRelatedItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

