/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmincidents.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssmincidents.model.ResponsePlanSummary;
import software.amazon.awssdk.services.ssmincidents.model.ResponsePlanSummaryListCopier;
import software.amazon.awssdk.services.ssmincidents.model.SsmIncidentsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResponsePlansResponse
extends SsmIncidentsResponse
implements ToCopyableBuilder<Builder, ListResponsePlansResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResponsePlansResponse.getter(ListResponsePlansResponse::nextToken)).setter(ListResponsePlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ResponsePlanSummary>> RESPONSE_PLAN_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("responsePlanSummaries").getter(ListResponsePlansResponse.getter(ListResponsePlansResponse::responsePlanSummaries)).setter(ListResponsePlansResponse.setter(Builder::responsePlanSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responsePlanSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResponsePlanSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESPONSE_PLAN_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<ResponsePlanSummary> responsePlanSummaries;

    private ListResponsePlansResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.responsePlanSummaries = builder.responsePlanSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasResponsePlanSummaries() {
        return this.responsePlanSummaries != null && !(this.responsePlanSummaries instanceof SdkAutoConstructList);
    }

    public final List<ResponsePlanSummary> responsePlanSummaries() {
        return this.responsePlanSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponsePlanSummaries() ? this.responsePlanSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResponsePlansResponse)) {
            return false;
        }
        ListResponsePlansResponse other = (ListResponsePlansResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasResponsePlanSummaries() == other.hasResponsePlanSummaries() && Objects.equals(this.responsePlanSummaries(), other.responsePlanSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListResponsePlansResponse").add("NextToken", (Object)this.nextToken()).add("ResponsePlanSummaries", this.hasResponsePlanSummaries() ? this.responsePlanSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "responsePlanSummaries": {
                return Optional.ofNullable(clazz.cast(this.responsePlanSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResponsePlansResponse, T> g) {
        return obj -> g.apply((ListResponsePlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmIncidentsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ResponsePlanSummary> responsePlanSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResponsePlansResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.responsePlanSummaries(model.responsePlanSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResponsePlanSummary.Builder> getResponsePlanSummaries() {
            List<ResponsePlanSummary.Builder> result = ResponsePlanSummaryListCopier.copyToBuilder(this.responsePlanSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResponsePlanSummaries(Collection<ResponsePlanSummary.BuilderImpl> responsePlanSummaries) {
            this.responsePlanSummaries = ResponsePlanSummaryListCopier.copyFromBuilder(responsePlanSummaries);
        }

        @Override
        @Transient
        public final Builder responsePlanSummaries(Collection<ResponsePlanSummary> responsePlanSummaries) {
            this.responsePlanSummaries = ResponsePlanSummaryListCopier.copy(responsePlanSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder responsePlanSummaries(ResponsePlanSummary ... responsePlanSummaries) {
            this.responsePlanSummaries(Arrays.asList(responsePlanSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder responsePlanSummaries(Consumer<ResponsePlanSummary.Builder> ... responsePlanSummaries) {
            this.responsePlanSummaries(Stream.of(responsePlanSummaries).map(c -> (ResponsePlanSummary)((ResponsePlanSummary.Builder)ResponsePlanSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResponsePlansResponse build() {
            return new ListResponsePlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmIncidentsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResponsePlansResponse> {
        public Builder nextToken(String var1);

        public Builder responsePlanSummaries(Collection<ResponsePlanSummary> var1);

        public Builder responsePlanSummaries(ResponsePlanSummary ... var1);

        public Builder responsePlanSummaries(Consumer<ResponsePlanSummary.Builder> ... var1);
    }
}

