/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRotationRequest extends SsmContactsRequest implements
        ToCopyableBuilder<UpdateRotationRequest.Builder, UpdateRotationRequest> {
    private static final SdkField<String> ROTATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RotationId").getter(getter(UpdateRotationRequest::rotationId)).setter(setter(Builder::rotationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RotationId").build()).build();

    private static final SdkField<List<String>> CONTACT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContactIds")
            .getter(getter(UpdateRotationRequest::contactIds))
            .setter(setter(Builder::contactIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(UpdateRotationRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> TIME_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeZoneId").getter(getter(UpdateRotationRequest::timeZoneId)).setter(setter(Builder::timeZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeZoneId").build()).build();

    private static final SdkField<RecurrenceSettings> RECURRENCE_FIELD = SdkField
            .<RecurrenceSettings> builder(MarshallingType.SDK_POJO).memberName("Recurrence")
            .getter(getter(UpdateRotationRequest::recurrence)).setter(setter(Builder::recurrence))
            .constructor(RecurrenceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recurrence").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROTATION_ID_FIELD,
            CONTACT_IDS_FIELD, START_TIME_FIELD, TIME_ZONE_ID_FIELD, RECURRENCE_FIELD));

    private final String rotationId;

    private final List<String> contactIds;

    private final Instant startTime;

    private final String timeZoneId;

    private final RecurrenceSettings recurrence;

    private UpdateRotationRequest(BuilderImpl builder) {
        super(builder);
        this.rotationId = builder.rotationId;
        this.contactIds = builder.contactIds;
        this.startTime = builder.startTime;
        this.timeZoneId = builder.timeZoneId;
        this.recurrence = builder.recurrence;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the rotation to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the rotation to update.
     */
    public final String rotationId() {
        return rotationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContactIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContactIds() {
        return contactIds != null && !(contactIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation.
     * </p>
     * <p>
     * The order in which you list the contacts is their shift order in the rotation schedule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContactIds} method.
     * </p>
     * 
     * @return The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation. </p>
     *         <p>
     *         The order in which you list the contacts is their shift order in the rotation schedule.
     */
    public final List<String> contactIds() {
        return contactIds;
    }

    /**
     * <p>
     * The date and time the rotation goes into effect.
     * </p>
     * 
     * @return The date and time the rotation goes into effect.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time zone to base the updated rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format.
     * For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a
     * href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
     * </p>
     * <note>
     * <p>
     * Designators for time zones that don’t support Daylight Savings Time Rules, such as Pacific Standard Time (PST)
     * and Pacific Daylight Time (PDT), aren't supported.
     * </p>
     * </note>
     * 
     * @return The time zone to base the updated rotation’s activity on, in Internet Assigned Numbers Authority (IANA)
     *         format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a
     *         href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p> <note>
     *         <p>
     *         Designators for time zones that don’t support Daylight Savings Time Rules, such as Pacific Standard Time
     *         (PST) and Pacific Daylight Time (PDT), aren't supported.
     *         </p>
     */
    public final String timeZoneId() {
        return timeZoneId;
    }

    /**
     * <p>
     * Information about how long the updated rotation lasts before restarting at the beginning of the shift order.
     * </p>
     * 
     * @return Information about how long the updated rotation lasts before restarting at the beginning of the shift
     *         order.
     */
    public final RecurrenceSettings recurrence() {
        return recurrence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rotationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasContactIds() ? contactIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(recurrence());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRotationRequest)) {
            return false;
        }
        UpdateRotationRequest other = (UpdateRotationRequest) obj;
        return Objects.equals(rotationId(), other.rotationId()) && hasContactIds() == other.hasContactIds()
                && Objects.equals(contactIds(), other.contactIds()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(timeZoneId(), other.timeZoneId()) && Objects.equals(recurrence(), other.recurrence());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRotationRequest").add("RotationId", rotationId())
                .add("ContactIds", hasContactIds() ? contactIds() : null).add("StartTime", startTime())
                .add("TimeZoneId", timeZoneId()).add("Recurrence", recurrence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RotationId":
            return Optional.ofNullable(clazz.cast(rotationId()));
        case "ContactIds":
            return Optional.ofNullable(clazz.cast(contactIds()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "TimeZoneId":
            return Optional.ofNullable(clazz.cast(timeZoneId()));
        case "Recurrence":
            return Optional.ofNullable(clazz.cast(recurrence()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRotationRequest, T> g) {
        return obj -> g.apply((UpdateRotationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmContactsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRotationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the rotation to update.
         * </p>
         * 
         * @param rotationId
         *        The Amazon Resource Name (ARN) of the rotation to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rotationId(String rotationId);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation.
         * </p>
         * <p>
         * The order in which you list the contacts is their shift order in the rotation schedule.
         * </p>
         * 
         * @param contactIds
         *        The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation. </p>
         *        <p>
         *        The order in which you list the contacts is their shift order in the rotation schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactIds(Collection<String> contactIds);

        /**
         * <p>
         * The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation.
         * </p>
         * <p>
         * The order in which you list the contacts is their shift order in the rotation schedule.
         * </p>
         * 
         * @param contactIds
         *        The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation. </p>
         *        <p>
         *        The order in which you list the contacts is their shift order in the rotation schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactIds(String... contactIds);

        /**
         * <p>
         * The date and time the rotation goes into effect.
         * </p>
         * 
         * @param startTime
         *        The date and time the rotation goes into effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time zone to base the updated rotation’s activity on, in Internet Assigned Numbers Authority (IANA)
         * format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the <a
         * href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
         * </p>
         * <note>
         * <p>
         * Designators for time zones that don’t support Daylight Savings Time Rules, such as Pacific Standard Time
         * (PST) and Pacific Daylight Time (PDT), aren't supported.
         * </p>
         * </note>
         * 
         * @param timeZoneId
         *        The time zone to base the updated rotation’s activity on, in Internet Assigned Numbers Authority
         *        (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see
         *        the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.</p> <note>
         *        <p>
         *        Designators for time zones that don’t support Daylight Savings Time Rules, such as Pacific Standard
         *        Time (PST) and Pacific Daylight Time (PDT), aren't supported.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZoneId(String timeZoneId);

        /**
         * <p>
         * Information about how long the updated rotation lasts before restarting at the beginning of the shift order.
         * </p>
         * 
         * @param recurrence
         *        Information about how long the updated rotation lasts before restarting at the beginning of the shift
         *        order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(RecurrenceSettings recurrence);

        /**
         * <p>
         * Information about how long the updated rotation lasts before restarting at the beginning of the shift order.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecurrenceSettings.Builder} avoiding the
         * need to create one manually via {@link RecurrenceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecurrenceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #recurrence(RecurrenceSettings)}.
         * 
         * @param recurrence
         *        a consumer that will call methods on {@link RecurrenceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recurrence(RecurrenceSettings)
         */
        default Builder recurrence(Consumer<RecurrenceSettings.Builder> recurrence) {
            return recurrence(RecurrenceSettings.builder().applyMutation(recurrence).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmContactsRequest.BuilderImpl implements Builder {
        private String rotationId;

        private List<String> contactIds = DefaultSdkAutoConstructList.getInstance();

        private Instant startTime;

        private String timeZoneId;

        private RecurrenceSettings recurrence;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRotationRequest model) {
            super(model);
            rotationId(model.rotationId);
            contactIds(model.contactIds);
            startTime(model.startTime);
            timeZoneId(model.timeZoneId);
            recurrence(model.recurrence);
        }

        public final String getRotationId() {
            return rotationId;
        }

        public final void setRotationId(String rotationId) {
            this.rotationId = rotationId;
        }

        @Override
        public final Builder rotationId(String rotationId) {
            this.rotationId = rotationId;
            return this;
        }

        public final Collection<String> getContactIds() {
            if (contactIds instanceof SdkAutoConstructList) {
                return null;
            }
            return contactIds;
        }

        public final void setContactIds(Collection<String> contactIds) {
            this.contactIds = RotationContactsArnListCopier.copy(contactIds);
        }

        @Override
        public final Builder contactIds(Collection<String> contactIds) {
            this.contactIds = RotationContactsArnListCopier.copy(contactIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contactIds(String... contactIds) {
            contactIds(Arrays.asList(contactIds));
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getTimeZoneId() {
            return timeZoneId;
        }

        public final void setTimeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
        }

        @Override
        public final Builder timeZoneId(String timeZoneId) {
            this.timeZoneId = timeZoneId;
            return this;
        }

        public final RecurrenceSettings.Builder getRecurrence() {
            return recurrence != null ? recurrence.toBuilder() : null;
        }

        public final void setRecurrence(RecurrenceSettings.BuilderImpl recurrence) {
            this.recurrence = recurrence != null ? recurrence.build() : null;
        }

        @Override
        public final Builder recurrence(RecurrenceSettings recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRotationRequest build() {
            return new UpdateRotationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
