/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssmcontacts.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contact that Incident Manager is engaging during an incident.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContactTargetInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ContactTargetInfo.Builder, ContactTargetInfo> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactId").getter(getter(ContactTargetInfo::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<Boolean> IS_ESSENTIAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsEssential").getter(getter(ContactTargetInfo::isEssential)).setter(setter(Builder::isEssential))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEssential").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            IS_ESSENTIAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String contactId;

    private final Boolean isEssential;

    private ContactTargetInfo(BuilderImpl builder) {
        this.contactId = builder.contactId;
        this.isEssential = builder.isEssential;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the contact.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the contact.
     */
    public final String contactId() {
        return contactId;
    }

    /**
     * <p>
     * A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
     * </p>
     * 
     * @return A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
     */
    public final Boolean isEssential() {
        return isEssential;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(isEssential());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactTargetInfo)) {
            return false;
        }
        ContactTargetInfo other = (ContactTargetInfo) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(isEssential(), other.isEssential());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContactTargetInfo").add("ContactId", contactId()).add("IsEssential", isEssential()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "IsEssential":
            return Optional.ofNullable(clazz.cast(isEssential()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactTargetInfo, T> g) {
        return obj -> g.apply((ContactTargetInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContactTargetInfo> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the contact.
         * </p>
         * 
         * @param contactId
         *        The Amazon Resource Name (ARN) of the contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
         * </p>
         * 
         * @param isEssential
         *        A Boolean value determining if the contact's acknowledgement stops the progress of stages in the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEssential(Boolean isEssential);
    }

    static final class BuilderImpl implements Builder {
        private String contactId;

        private Boolean isEssential;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactTargetInfo model) {
            contactId(model.contactId);
            isEssential(model.isEssential);
        }

        public final String getContactId() {
            return contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final Boolean getIsEssential() {
            return isEssential;
        }

        public final void setIsEssential(Boolean isEssential) {
            this.isEssential = isEssential;
        }

        @Override
        public final Builder isEssential(Boolean isEssential) {
            this.isEssential = isEssential;
            return this;
        }

        @Override
        public ContactTargetInfo build() {
            return new ContactTargetInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
