/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse;
import software.amazon.awssdk.services.ssm.model.InventoryDeletionStatusItem;

public class DescribeInventoryDeletionsIterable
implements SdkIterable<DescribeInventoryDeletionsResponse> {
    private final SsmClient client;
    private final DescribeInventoryDeletionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInventoryDeletionsIterable(SsmClient client, DescribeInventoryDeletionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInventoryDeletionsResponseFetcher();
    }

    public Iterator<DescribeInventoryDeletionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InventoryDeletionStatusItem> inventoryDeletions() {
        Function<DescribeInventoryDeletionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inventoryDeletions() != null) {
                return response.inventoryDeletions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInventoryDeletionsResponseFetcher
    implements SyncPageFetcher<DescribeInventoryDeletionsResponse> {
        private DescribeInventoryDeletionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInventoryDeletionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInventoryDeletionsResponse nextPage(DescribeInventoryDeletionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInventoryDeletionsIterable.this.client.describeInventoryDeletions(DescribeInventoryDeletionsIterable.this.firstRequest);
            }
            return DescribeInventoryDeletionsIterable.this.client.describeInventoryDeletions((DescribeInventoryDeletionsRequest)((Object)DescribeInventoryDeletionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

