/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueueAttributeName {
    ALL("All"),
    POLICY("Policy"),
    VISIBILITY_TIMEOUT("VisibilityTimeout"),
    MAXIMUM_MESSAGE_SIZE("MaximumMessageSize"),
    MESSAGE_RETENTION_PERIOD("MessageRetentionPeriod"),
    APPROXIMATE_NUMBER_OF_MESSAGES("ApproximateNumberOfMessages"),
    APPROXIMATE_NUMBER_OF_MESSAGES_NOT_VISIBLE("ApproximateNumberOfMessagesNotVisible"),
    CREATED_TIMESTAMP("CreatedTimestamp"),
    LAST_MODIFIED_TIMESTAMP("LastModifiedTimestamp"),
    QUEUE_ARN("QueueArn"),
    APPROXIMATE_NUMBER_OF_MESSAGES_DELAYED("ApproximateNumberOfMessagesDelayed"),
    DELAY_SECONDS("DelaySeconds"),
    RECEIVE_MESSAGE_WAIT_TIME_SECONDS("ReceiveMessageWaitTimeSeconds"),
    REDRIVE_POLICY("RedrivePolicy"),
    FIFO_QUEUE("FifoQueue"),
    CONTENT_BASED_DEDUPLICATION("ContentBasedDeduplication"),
    KMS_MASTER_KEY_ID("KmsMasterKeyId"),
    KMS_DATA_KEY_REUSE_PERIOD_SECONDS("KmsDataKeyReusePeriodSeconds"),
    DEDUPLICATION_SCOPE("DeduplicationScope"),
    FIFO_THROUGHPUT_LIMIT("FifoThroughputLimit"),
    REDRIVE_ALLOW_POLICY("RedriveAllowPolicy"),
    SQS_MANAGED_SSE_ENABLED("SqsManagedSseEnabled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueueAttributeName> VALUE_MAP;
    private final String value;

    private QueueAttributeName(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueueAttributeName fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueueAttributeName> knownValues() {
        EnumSet<QueueAttributeName> knownValues = EnumSet.allOf(QueueAttributeName.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueueAttributeName.class, QueueAttributeName::toString);
    }
}

