/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransferOption {
    IMPORT("IMPORT"),
    EXPORT("EXPORT"),
    LOCAL_USE("LOCAL_USE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransferOption> VALUE_MAP;
    private final String value;

    private TransferOption(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransferOption fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransferOption> knownValues() {
        EnumSet<TransferOption> knownValues = EnumSet.allOf(TransferOption.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransferOption.class, TransferOption::toString);
    }
}

