/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.snowball.model.JobListEntry;
import software.amazon.awssdk.services.snowball.model.JobListEntryListCopier;
import software.amazon.awssdk.services.snowball.model.SnowballResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateClusterResponse
extends SnowballResponse
implements ToCopyableBuilder<Builder, CreateClusterResponse> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(CreateClusterResponse.getter(CreateClusterResponse::clusterId)).setter(CreateClusterResponse.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<List<JobListEntry>> JOB_LIST_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("JobListEntries").getter(CreateClusterResponse.getter(CreateClusterResponse::jobListEntries)).setter(CreateClusterResponse.setter(Builder::jobListEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobListEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, JOB_LIST_ENTRIES_FIELD));
    private final String clusterId;
    private final List<JobListEntry> jobListEntries;

    private CreateClusterResponse(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.jobListEntries = builder.jobListEntries;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final boolean hasJobListEntries() {
        return this.jobListEntries != null && !(this.jobListEntries instanceof SdkAutoConstructList);
    }

    public final List<JobListEntry> jobListEntries() {
        return this.jobListEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobListEntries() ? this.jobListEntries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterResponse)) {
            return false;
        }
        CreateClusterResponse other = (CreateClusterResponse)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && this.hasJobListEntries() == other.hasJobListEntries() && Objects.equals(this.jobListEntries(), other.jobListEntries());
    }

    public final String toString() {
        return ToString.builder((String)"CreateClusterResponse").add("ClusterId", (Object)this.clusterId()).add("JobListEntries", this.hasJobListEntries() ? this.jobListEntries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "JobListEntries": {
                return Optional.ofNullable(clazz.cast(this.jobListEntries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterResponse, T> g) {
        return obj -> g.apply((CreateClusterResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowballResponse.BuilderImpl
    implements Builder {
        private String clusterId;
        private List<JobListEntry> jobListEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterResponse model) {
            super(model);
            this.clusterId(model.clusterId);
            this.jobListEntries(model.jobListEntries);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final List<JobListEntry.Builder> getJobListEntries() {
            List<JobListEntry.Builder> result = JobListEntryListCopier.copyToBuilder(this.jobListEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobListEntries(Collection<JobListEntry.BuilderImpl> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copyFromBuilder(jobListEntries);
        }

        @Override
        public final Builder jobListEntries(Collection<JobListEntry> jobListEntries) {
            this.jobListEntries = JobListEntryListCopier.copy(jobListEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(JobListEntry ... jobListEntries) {
            this.jobListEntries(Arrays.asList(jobListEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobListEntries(Consumer<JobListEntry.Builder> ... jobListEntries) {
            this.jobListEntries(Stream.of(jobListEntries).map(c -> (JobListEntry)((JobListEntry.Builder)JobListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateClusterResponse build() {
            return new CreateClusterResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowballResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateClusterResponse> {
        public Builder clusterId(String var1);

        public Builder jobListEntries(Collection<JobListEntry> var1);

        public Builder jobListEntries(JobListEntry ... var1);

        public Builder jobListEntries(Consumer<JobListEntry.Builder> ... var1);
    }
}

