/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.snowball.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Ec2AmiResourceListCopier {
    static List<Ec2AmiResource> copy(Collection<? extends Ec2AmiResource> ec2AmiResourceListParam) {
        List<Ec2AmiResource> list;
        if (ec2AmiResourceListParam == null || ec2AmiResourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2AmiResource> modifiableList = new ArrayList<>();
            ec2AmiResourceListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ec2AmiResource> copyFromBuilder(Collection<? extends Ec2AmiResource.Builder> ec2AmiResourceListParam) {
        List<Ec2AmiResource> list;
        if (ec2AmiResourceListParam == null || ec2AmiResourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2AmiResource> modifiableList = new ArrayList<>();
            ec2AmiResourceListParam.forEach(entry -> {
                Ec2AmiResource member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Ec2AmiResource.Builder> copyToBuilder(Collection<? extends Ec2AmiResource> ec2AmiResourceListParam) {
        List<Ec2AmiResource.Builder> list;
        if (ec2AmiResourceListParam == null || ec2AmiResourceListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Ec2AmiResource.Builder> modifiableList = new ArrayList<>();
            ec2AmiResourceListParam.forEach(entry -> {
                Ec2AmiResource.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
