/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowball.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.snowball.SnowballAsyncClient;
import software.amazon.awssdk.services.snowball.model.CompatibleImage;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesRequest;
import software.amazon.awssdk.services.snowball.model.ListCompatibleImagesResponse;

public class ListCompatibleImagesPublisher
implements SdkPublisher<ListCompatibleImagesResponse> {
    private final SnowballAsyncClient client;
    private final ListCompatibleImagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCompatibleImagesPublisher(SnowballAsyncClient client, ListCompatibleImagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCompatibleImagesPublisher(SnowballAsyncClient client, ListCompatibleImagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCompatibleImagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCompatibleImagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CompatibleImage> compatibleImages() {
        Function<ListCompatibleImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.compatibleImages() != null) {
                return response.compatibleImages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCompatibleImagesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCompatibleImagesResponseFetcher
    implements AsyncPageFetcher<ListCompatibleImagesResponse> {
        private ListCompatibleImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListCompatibleImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCompatibleImagesResponse> nextPage(ListCompatibleImagesResponse previousPage) {
            if (previousPage == null) {
                return ListCompatibleImagesPublisher.this.client.listCompatibleImages(ListCompatibleImagesPublisher.this.firstRequest);
            }
            return ListCompatibleImagesPublisher.this.client.listCompatibleImages((ListCompatibleImagesRequest)((Object)ListCompatibleImagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

