/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Narrows the set of protection groups that the call retrieves. You can retrieve a single protection group by its name
 * and you can retrieve all protection groups that are configured with a specific pattern, aggregation, or resource
 * type. You can provide up to one criteria per filter type. Shield Advanced returns the protection groups that exactly
 * match all of the search criteria that you provide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InclusionProtectionGroupFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<InclusionProtectionGroupFilters.Builder, InclusionProtectionGroupFilters> {
    private static final SdkField<List<String>> PROTECTION_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProtectionGroupIds")
            .getter(getter(InclusionProtectionGroupFilters::protectionGroupIds))
            .setter(setter(Builder::protectionGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectionGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Patterns")
            .getter(getter(InclusionProtectionGroupFilters::patternsAsStrings))
            .setter(setter(Builder::patternsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Patterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ResourceTypes")
            .getter(getter(InclusionProtectionGroupFilters::resourceTypesAsStrings))
            .setter(setter(Builder::resourceTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AGGREGATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Aggregations")
            .getter(getter(InclusionProtectionGroupFilters::aggregationsAsStrings))
            .setter(setter(Builder::aggregationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTECTION_GROUP_IDS_FIELD,
            PATTERNS_FIELD, RESOURCE_TYPES_FIELD, AGGREGATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> protectionGroupIds;

    private final List<String> patterns;

    private final List<String> resourceTypes;

    private final List<String> aggregations;

    private InclusionProtectionGroupFilters(BuilderImpl builder) {
        this.protectionGroupIds = builder.protectionGroupIds;
        this.patterns = builder.patterns;
        this.resourceTypes = builder.resourceTypes;
        this.aggregations = builder.aggregations;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProtectionGroupIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProtectionGroupIds() {
        return protectionGroupIds != null && !(protectionGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the protection group that you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProtectionGroupIds} method.
     * </p>
     * 
     * @return The ID of the protection group that you want to retrieve.
     */
    public final List<String> protectionGroupIds() {
        return protectionGroupIds;
    }

    /**
     * <p>
     * The pattern specification of the protection groups that you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPatterns} method.
     * </p>
     * 
     * @return The pattern specification of the protection groups that you want to retrieve.
     */
    public final List<ProtectionGroupPattern> patterns() {
        return ProtectionGroupPatternFiltersCopier.copyStringToEnum(patterns);
    }

    /**
     * For responses, this returns true if the service returned a value for the Patterns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPatterns() {
        return patterns != null && !(patterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The pattern specification of the protection groups that you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPatterns} method.
     * </p>
     * 
     * @return The pattern specification of the protection groups that you want to retrieve.
     */
    public final List<String> patternsAsStrings() {
        return patterns;
    }

    /**
     * <p>
     * The resource type configuration of the protection groups that you want to retrieve. In the protection group
     * configuration, you specify the resource type when you set the group's <code>Pattern</code> to
     * <code>BY_RESOURCE_TYPE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The resource type configuration of the protection groups that you want to retrieve. In the protection
     *         group configuration, you specify the resource type when you set the group's <code>Pattern</code> to
     *         <code>BY_RESOURCE_TYPE</code>.
     */
    public final List<ProtectedResourceType> resourceTypes() {
        return ProtectedResourceTypeFiltersCopier.copyStringToEnum(resourceTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTypes() {
        return resourceTypes != null && !(resourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resource type configuration of the protection groups that you want to retrieve. In the protection group
     * configuration, you specify the resource type when you set the group's <code>Pattern</code> to
     * <code>BY_RESOURCE_TYPE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTypes} method.
     * </p>
     * 
     * @return The resource type configuration of the protection groups that you want to retrieve. In the protection
     *         group configuration, you specify the resource type when you set the group's <code>Pattern</code> to
     *         <code>BY_RESOURCE_TYPE</code>.
     */
    public final List<String> resourceTypesAsStrings() {
        return resourceTypes;
    }

    /**
     * <p>
     * The aggregation setting of the protection groups that you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregations} method.
     * </p>
     * 
     * @return The aggregation setting of the protection groups that you want to retrieve.
     */
    public final List<ProtectionGroupAggregation> aggregations() {
        return ProtectionGroupAggregationFiltersCopier.copyStringToEnum(aggregations);
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregations() {
        return aggregations != null && !(aggregations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The aggregation setting of the protection groups that you want to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregations} method.
     * </p>
     * 
     * @return The aggregation setting of the protection groups that you want to retrieve.
     */
    public final List<String> aggregationsAsStrings() {
        return aggregations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasProtectionGroupIds() ? protectionGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPatterns() ? patternsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTypes() ? resourceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregations() ? aggregationsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InclusionProtectionGroupFilters)) {
            return false;
        }
        InclusionProtectionGroupFilters other = (InclusionProtectionGroupFilters) obj;
        return hasProtectionGroupIds() == other.hasProtectionGroupIds()
                && Objects.equals(protectionGroupIds(), other.protectionGroupIds()) && hasPatterns() == other.hasPatterns()
                && Objects.equals(patternsAsStrings(), other.patternsAsStrings())
                && hasResourceTypes() == other.hasResourceTypes()
                && Objects.equals(resourceTypesAsStrings(), other.resourceTypesAsStrings())
                && hasAggregations() == other.hasAggregations()
                && Objects.equals(aggregationsAsStrings(), other.aggregationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InclusionProtectionGroupFilters")
                .add("ProtectionGroupIds", hasProtectionGroupIds() ? protectionGroupIds() : null)
                .add("Patterns", hasPatterns() ? patternsAsStrings() : null)
                .add("ResourceTypes", hasResourceTypes() ? resourceTypesAsStrings() : null)
                .add("Aggregations", hasAggregations() ? aggregationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProtectionGroupIds":
            return Optional.ofNullable(clazz.cast(protectionGroupIds()));
        case "Patterns":
            return Optional.ofNullable(clazz.cast(patternsAsStrings()));
        case "ResourceTypes":
            return Optional.ofNullable(clazz.cast(resourceTypesAsStrings()));
        case "Aggregations":
            return Optional.ofNullable(clazz.cast(aggregationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InclusionProtectionGroupFilters, T> g) {
        return obj -> g.apply((InclusionProtectionGroupFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InclusionProtectionGroupFilters> {
        /**
         * <p>
         * The ID of the protection group that you want to retrieve.
         * </p>
         * 
         * @param protectionGroupIds
         *        The ID of the protection group that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionGroupIds(Collection<String> protectionGroupIds);

        /**
         * <p>
         * The ID of the protection group that you want to retrieve.
         * </p>
         * 
         * @param protectionGroupIds
         *        The ID of the protection group that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectionGroupIds(String... protectionGroupIds);

        /**
         * <p>
         * The pattern specification of the protection groups that you want to retrieve.
         * </p>
         * 
         * @param patterns
         *        The pattern specification of the protection groups that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternsWithStrings(Collection<String> patterns);

        /**
         * <p>
         * The pattern specification of the protection groups that you want to retrieve.
         * </p>
         * 
         * @param patterns
         *        The pattern specification of the protection groups that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patternsWithStrings(String... patterns);

        /**
         * <p>
         * The pattern specification of the protection groups that you want to retrieve.
         * </p>
         * 
         * @param patterns
         *        The pattern specification of the protection groups that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patterns(Collection<ProtectionGroupPattern> patterns);

        /**
         * <p>
         * The pattern specification of the protection groups that you want to retrieve.
         * </p>
         * 
         * @param patterns
         *        The pattern specification of the protection groups that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patterns(ProtectionGroupPattern... patterns);

        /**
         * <p>
         * The resource type configuration of the protection groups that you want to retrieve. In the protection group
         * configuration, you specify the resource type when you set the group's <code>Pattern</code> to
         * <code>BY_RESOURCE_TYPE</code>.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type configuration of the protection groups that you want to retrieve. In the protection
         *        group configuration, you specify the resource type when you set the group's <code>Pattern</code> to
         *        <code>BY_RESOURCE_TYPE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(Collection<String> resourceTypes);

        /**
         * <p>
         * The resource type configuration of the protection groups that you want to retrieve. In the protection group
         * configuration, you specify the resource type when you set the group's <code>Pattern</code> to
         * <code>BY_RESOURCE_TYPE</code>.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type configuration of the protection groups that you want to retrieve. In the protection
         *        group configuration, you specify the resource type when you set the group's <code>Pattern</code> to
         *        <code>BY_RESOURCE_TYPE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypesWithStrings(String... resourceTypes);

        /**
         * <p>
         * The resource type configuration of the protection groups that you want to retrieve. In the protection group
         * configuration, you specify the resource type when you set the group's <code>Pattern</code> to
         * <code>BY_RESOURCE_TYPE</code>.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type configuration of the protection groups that you want to retrieve. In the protection
         *        group configuration, you specify the resource type when you set the group's <code>Pattern</code> to
         *        <code>BY_RESOURCE_TYPE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(Collection<ProtectedResourceType> resourceTypes);

        /**
         * <p>
         * The resource type configuration of the protection groups that you want to retrieve. In the protection group
         * configuration, you specify the resource type when you set the group's <code>Pattern</code> to
         * <code>BY_RESOURCE_TYPE</code>.
         * </p>
         * 
         * @param resourceTypes
         *        The resource type configuration of the protection groups that you want to retrieve. In the protection
         *        group configuration, you specify the resource type when you set the group's <code>Pattern</code> to
         *        <code>BY_RESOURCE_TYPE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTypes(ProtectedResourceType... resourceTypes);

        /**
         * <p>
         * The aggregation setting of the protection groups that you want to retrieve.
         * </p>
         * 
         * @param aggregations
         *        The aggregation setting of the protection groups that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationsWithStrings(Collection<String> aggregations);

        /**
         * <p>
         * The aggregation setting of the protection groups that you want to retrieve.
         * </p>
         * 
         * @param aggregations
         *        The aggregation setting of the protection groups that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregationsWithStrings(String... aggregations);

        /**
         * <p>
         * The aggregation setting of the protection groups that you want to retrieve.
         * </p>
         * 
         * @param aggregations
         *        The aggregation setting of the protection groups that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregations(Collection<ProtectionGroupAggregation> aggregations);

        /**
         * <p>
         * The aggregation setting of the protection groups that you want to retrieve.
         * </p>
         * 
         * @param aggregations
         *        The aggregation setting of the protection groups that you want to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregations(ProtectionGroupAggregation... aggregations);
    }

    static final class BuilderImpl implements Builder {
        private List<String> protectionGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> patterns = DefaultSdkAutoConstructList.getInstance();

        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> aggregations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InclusionProtectionGroupFilters model) {
            protectionGroupIds(model.protectionGroupIds);
            patternsWithStrings(model.patterns);
            resourceTypesWithStrings(model.resourceTypes);
            aggregationsWithStrings(model.aggregations);
        }

        public final Collection<String> getProtectionGroupIds() {
            if (protectionGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return protectionGroupIds;
        }

        public final void setProtectionGroupIds(Collection<String> protectionGroupIds) {
            this.protectionGroupIds = ProtectionGroupIdFiltersCopier.copy(protectionGroupIds);
        }

        @Override
        public final Builder protectionGroupIds(Collection<String> protectionGroupIds) {
            this.protectionGroupIds = ProtectionGroupIdFiltersCopier.copy(protectionGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protectionGroupIds(String... protectionGroupIds) {
            protectionGroupIds(Arrays.asList(protectionGroupIds));
            return this;
        }

        public final Collection<String> getPatterns() {
            if (patterns instanceof SdkAutoConstructList) {
                return null;
            }
            return patterns;
        }

        public final void setPatterns(Collection<String> patterns) {
            this.patterns = ProtectionGroupPatternFiltersCopier.copy(patterns);
        }

        @Override
        public final Builder patternsWithStrings(Collection<String> patterns) {
            this.patterns = ProtectionGroupPatternFiltersCopier.copy(patterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patternsWithStrings(String... patterns) {
            patternsWithStrings(Arrays.asList(patterns));
            return this;
        }

        @Override
        public final Builder patterns(Collection<ProtectionGroupPattern> patterns) {
            this.patterns = ProtectionGroupPatternFiltersCopier.copyEnumToString(patterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patterns(ProtectionGroupPattern... patterns) {
            patterns(Arrays.asList(patterns));
            return this;
        }

        public final Collection<String> getResourceTypes() {
            if (resourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceTypes;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copy(resourceTypes);
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String... resourceTypes) {
            resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ProtectedResourceType> resourceTypes) {
            this.resourceTypes = ProtectedResourceTypeFiltersCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ProtectedResourceType... resourceTypes) {
            resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final Collection<String> getAggregations() {
            if (aggregations instanceof SdkAutoConstructList) {
                return null;
            }
            return aggregations;
        }

        public final void setAggregations(Collection<String> aggregations) {
            this.aggregations = ProtectionGroupAggregationFiltersCopier.copy(aggregations);
        }

        @Override
        public final Builder aggregationsWithStrings(Collection<String> aggregations) {
            this.aggregations = ProtectionGroupAggregationFiltersCopier.copy(aggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationsWithStrings(String... aggregations) {
            aggregationsWithStrings(Arrays.asList(aggregations));
            return this;
        }

        @Override
        public final Builder aggregations(Collection<ProtectionGroupAggregation> aggregations) {
            this.aggregations = ProtectionGroupAggregationFiltersCopier.copyEnumToString(aggregations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregations(ProtectionGroupAggregation... aggregations) {
            aggregations(Arrays.asList(aggregations));
            return this;
        }

        @Override
        public InclusionProtectionGroupFilters build() {
            return new InclusionProtectionGroupFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
