/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.shield;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.shield.model.AccessDeniedException;
import software.amazon.awssdk.services.shield.model.AccessDeniedForDependencyException;
import software.amazon.awssdk.services.shield.model.AssociateDrtLogBucketRequest;
import software.amazon.awssdk.services.shield.model.AssociateDrtLogBucketResponse;
import software.amazon.awssdk.services.shield.model.AssociateDrtRoleRequest;
import software.amazon.awssdk.services.shield.model.AssociateDrtRoleResponse;
import software.amazon.awssdk.services.shield.model.AssociateHealthCheckRequest;
import software.amazon.awssdk.services.shield.model.AssociateHealthCheckResponse;
import software.amazon.awssdk.services.shield.model.AssociateProactiveEngagementDetailsRequest;
import software.amazon.awssdk.services.shield.model.AssociateProactiveEngagementDetailsResponse;
import software.amazon.awssdk.services.shield.model.CreateProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.CreateProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.CreateProtectionRequest;
import software.amazon.awssdk.services.shield.model.CreateProtectionResponse;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.CreateSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DeleteProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.DeleteProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.DeleteProtectionRequest;
import software.amazon.awssdk.services.shield.model.DeleteProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeAttackRequest;
import software.amazon.awssdk.services.shield.model.DescribeAttackResponse;
import software.amazon.awssdk.services.shield.model.DescribeAttackStatisticsRequest;
import software.amazon.awssdk.services.shield.model.DescribeAttackStatisticsResponse;
import software.amazon.awssdk.services.shield.model.DescribeDrtAccessRequest;
import software.amazon.awssdk.services.shield.model.DescribeDrtAccessResponse;
import software.amazon.awssdk.services.shield.model.DescribeEmergencyContactSettingsRequest;
import software.amazon.awssdk.services.shield.model.DescribeEmergencyContactSettingsResponse;
import software.amazon.awssdk.services.shield.model.DescribeProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.DescribeProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.DescribeProtectionRequest;
import software.amazon.awssdk.services.shield.model.DescribeProtectionResponse;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.DescribeSubscriptionResponse;
import software.amazon.awssdk.services.shield.model.DisableApplicationLayerAutomaticResponseRequest;
import software.amazon.awssdk.services.shield.model.DisableApplicationLayerAutomaticResponseResponse;
import software.amazon.awssdk.services.shield.model.DisableProactiveEngagementRequest;
import software.amazon.awssdk.services.shield.model.DisableProactiveEngagementResponse;
import software.amazon.awssdk.services.shield.model.DisassociateDrtLogBucketRequest;
import software.amazon.awssdk.services.shield.model.DisassociateDrtLogBucketResponse;
import software.amazon.awssdk.services.shield.model.DisassociateDrtRoleRequest;
import software.amazon.awssdk.services.shield.model.DisassociateDrtRoleResponse;
import software.amazon.awssdk.services.shield.model.DisassociateHealthCheckRequest;
import software.amazon.awssdk.services.shield.model.DisassociateHealthCheckResponse;
import software.amazon.awssdk.services.shield.model.EnableApplicationLayerAutomaticResponseRequest;
import software.amazon.awssdk.services.shield.model.EnableApplicationLayerAutomaticResponseResponse;
import software.amazon.awssdk.services.shield.model.EnableProactiveEngagementRequest;
import software.amazon.awssdk.services.shield.model.EnableProactiveEngagementResponse;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateRequest;
import software.amazon.awssdk.services.shield.model.GetSubscriptionStateResponse;
import software.amazon.awssdk.services.shield.model.InternalErrorException;
import software.amazon.awssdk.services.shield.model.InvalidOperationException;
import software.amazon.awssdk.services.shield.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.shield.model.InvalidParameterException;
import software.amazon.awssdk.services.shield.model.InvalidResourceException;
import software.amazon.awssdk.services.shield.model.LimitsExceededException;
import software.amazon.awssdk.services.shield.model.ListAttacksRequest;
import software.amazon.awssdk.services.shield.model.ListAttacksResponse;
import software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse;
import software.amazon.awssdk.services.shield.model.ListProtectionsRequest;
import software.amazon.awssdk.services.shield.model.ListProtectionsResponse;
import software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.shield.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.shield.model.LockedSubscriptionException;
import software.amazon.awssdk.services.shield.model.NoAssociatedRoleException;
import software.amazon.awssdk.services.shield.model.OptimisticLockException;
import software.amazon.awssdk.services.shield.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.shield.model.ResourceNotFoundException;
import software.amazon.awssdk.services.shield.model.ShieldException;
import software.amazon.awssdk.services.shield.model.TagResourceRequest;
import software.amazon.awssdk.services.shield.model.TagResourceResponse;
import software.amazon.awssdk.services.shield.model.UntagResourceRequest;
import software.amazon.awssdk.services.shield.model.UntagResourceResponse;
import software.amazon.awssdk.services.shield.model.UpdateApplicationLayerAutomaticResponseRequest;
import software.amazon.awssdk.services.shield.model.UpdateApplicationLayerAutomaticResponseResponse;
import software.amazon.awssdk.services.shield.model.UpdateEmergencyContactSettingsRequest;
import software.amazon.awssdk.services.shield.model.UpdateEmergencyContactSettingsResponse;
import software.amazon.awssdk.services.shield.model.UpdateProtectionGroupRequest;
import software.amazon.awssdk.services.shield.model.UpdateProtectionGroupResponse;
import software.amazon.awssdk.services.shield.model.UpdateSubscriptionRequest;
import software.amazon.awssdk.services.shield.model.UpdateSubscriptionResponse;
import software.amazon.awssdk.services.shield.paginators.ListAttacksIterable;
import software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsIterable;
import software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable;
import software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupIterable;

/**
 * Service client for accessing AWS Shield. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Shield Advanced</fullname>
 * <p>
 * This is the <i>Shield Advanced API Reference</i>. This guide is for developers who need detailed information about
 * the Shield Advanced API actions, data types, and errors. For detailed information about WAF and Shield Advanced
 * features and an overview of how to use the WAF and Shield Advanced APIs, see the <a
 * href="https://docs.aws.amazon.com/waf/latest/developerguide/">WAF and Shield Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ShieldClient extends AwsClient {
    String SERVICE_NAME = "shield";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "shield";

    /**
     * <p>
     * Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as
     * Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to
     * 10 Amazon S3 buckets with your subscription.
     * </p>
     * <p>
     * To use the services of the SRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to
     * the <a href="http://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="http://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     *
     * @param associateDrtLogBucketRequest
     * @return Result of the AssociateDRTLogBucket operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws NoAssociatedRoleException
     *         The ARN of the role that you specified does not exist.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request
     *         must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the
     *         appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an Amazon Web Services Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateDRTLogBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTLogBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateDrtLogBucketResponse associateDRTLogBucket(AssociateDrtLogBucketRequest associateDrtLogBucketRequest)
            throws InternalErrorException, InvalidOperationException, NoAssociatedRoleException, LimitsExceededException,
            InvalidParameterException, AccessDeniedForDependencyException, OptimisticLockException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the Shield Response Team (SRT) to access the specified Amazon S3 bucket containing log data such as
     * Application Load Balancer access logs, CloudFront logs, or logs from third party sources. You can associate up to
     * 10 Amazon S3 buckets with your subscription.
     * </p>
     * <p>
     * To use the services of the SRT and make an <code>AssociateDRTLogBucket</code> request, you must be subscribed to
     * the <a href="http://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="http://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDrtLogBucketRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateDrtLogBucketRequest#builder()}
     * </p>
     *
     * @param associateDrtLogBucketRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDRTLogBucketRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateDRTLogBucket operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws NoAssociatedRoleException
     *         The ARN of the role that you specified does not exist.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request
     *         must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the
     *         appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an Amazon Web Services Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateDRTLogBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTLogBucket" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateDrtLogBucketResponse associateDRTLogBucket(
            Consumer<AssociateDrtLogBucketRequest.Builder> associateDrtLogBucketRequest) throws InternalErrorException,
            InvalidOperationException, NoAssociatedRoleException, LimitsExceededException, InvalidParameterException,
            AccessDeniedForDependencyException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return associateDRTLogBucket(AssociateDrtLogBucketRequest.builder().applyMutation(associateDrtLogBucketRequest).build());
    }

    /**
     * <p>
     * Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to
     * assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF
     * configuration and create or update WAF rules and web ACLs.
     * </p>
     * <p>
     * You can associate only one <code>RoleArn</code> with your subscription. If you submit an
     * <code>AssociateDRTRole</code> request for an account that already has an associated role, the new
     * <code>RoleArn</code> will replace the existing <code>RoleArn</code>.
     * </p>
     * <p>
     * Prior to making the <code>AssociateDRTRole</code> request, you must attach the
     * <code>AWSShieldDRTAccessPolicy</code> managed policy to the role that you'll specify in the request. You can
     * access this policy in the IAM console at <a href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"
     * >AWSShieldDRTAccessPolicy</a>. For more information see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Adding and
     * removing IAM identity permissions</a>. The role must also trust the service principal
     * <code>drt.shield.amazonaws.com</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON
     * policy elements: Principal</a>.
     * </p>
     * <p>
     * The SRT will have access only to your WAF and Shield resources. By submitting this request, you authorize the SRT
     * to inspect your WAF and Shield configuration and create and update WAF rules and web ACLs on your behalf. The SRT
     * takes these actions only if explicitly authorized by you.
     * </p>
     * <p>
     * You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a
     * user permissions to pass a role to an Amazon Web Services service</a>.
     * </p>
     * <p>
     * To use the services of the SRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the
     * <a href="http://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="http://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     *
     * @param associateDrtRoleRequest
     * @return Result of the AssociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request
     *         must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the
     *         appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an Amazon Web Services Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateDrtRoleResponse associateDRTRole(AssociateDrtRoleRequest associateDrtRoleRequest)
            throws InternalErrorException, InvalidOperationException, InvalidParameterException,
            AccessDeniedForDependencyException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the Shield Response Team (SRT) using the specified role, to access your Amazon Web Services account to
     * assist with DDoS attack mitigation during potential attacks. This enables the SRT to inspect your WAF
     * configuration and create or update WAF rules and web ACLs.
     * </p>
     * <p>
     * You can associate only one <code>RoleArn</code> with your subscription. If you submit an
     * <code>AssociateDRTRole</code> request for an account that already has an associated role, the new
     * <code>RoleArn</code> will replace the existing <code>RoleArn</code>.
     * </p>
     * <p>
     * Prior to making the <code>AssociateDRTRole</code> request, you must attach the
     * <code>AWSShieldDRTAccessPolicy</code> managed policy to the role that you'll specify in the request. You can
     * access this policy in the IAM console at <a href=
     * "https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSShieldDRTAccessPolicy"
     * >AWSShieldDRTAccessPolicy</a>. For more information see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage-attach-detach.html">Adding and
     * removing IAM identity permissions</a>. The role must also trust the service principal
     * <code>drt.shield.amazonaws.com</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM JSON
     * policy elements: Principal</a>.
     * </p>
     * <p>
     * The SRT will have access only to your WAF and Shield resources. By submitting this request, you authorize the SRT
     * to inspect your WAF and Shield configuration and create and update WAF rules and web ACLs on your behalf. The SRT
     * takes these actions only if explicitly authorized by you.
     * </p>
     * <p>
     * You must have the <code>iam:PassRole</code> permission to make an <code>AssociateDRTRole</code> request. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a
     * user permissions to pass a role to an Amazon Web Services service</a>.
     * </p>
     * <p>
     * To use the services of the SRT and make an <code>AssociateDRTRole</code> request, you must be subscribed to the
     * <a href="http://aws.amazon.com/premiumsupport/business-support/">Business Support plan</a> or the <a
     * href="http://aws.amazon.com/premiumsupport/enterprise-support/">Enterprise Support plan</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDrtRoleRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateDrtRoleRequest#builder()}
     * </p>
     *
     * @param associateDrtRoleRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDRTRoleRequest.Builder} to create a request.
     * @return Result of the AssociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request
     *         must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the
     *         appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an Amazon Web Services Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateDRTRole" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateDrtRoleResponse associateDRTRole(Consumer<AssociateDrtRoleRequest.Builder> associateDrtRoleRequest)
            throws InternalErrorException, InvalidOperationException, InvalidParameterException,
            AccessDeniedForDependencyException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return associateDRTRole(AssociateDrtRoleRequest.builder().applyMutation(associateDrtRoleRequest).build());
    }

    /**
     * <p>
     * Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack
     * detection and response.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param associateHealthCheckRequest
     * @return Result of the AssociateHealthCheck operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateHealthCheck" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateHealthCheckResponse associateHealthCheck(AssociateHealthCheckRequest associateHealthCheckRequest)
            throws InternalErrorException, LimitsExceededException, ResourceNotFoundException, InvalidParameterException,
            OptimisticLockException, InvalidResourceException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds health-based detection to the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack
     * detection and response.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate it with your Shield Advanced protection. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateHealthCheckRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateHealthCheckRequest#builder()}
     * </p>
     *
     * @param associateHealthCheckRequest
     *        A {@link Consumer} that will call methods on {@link AssociateHealthCheckRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateHealthCheck operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateHealthCheck" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateHealthCheckResponse associateHealthCheck(
            Consumer<AssociateHealthCheckRequest.Builder> associateHealthCheckRequest) throws InternalErrorException,
            LimitsExceededException, ResourceNotFoundException, InvalidParameterException, OptimisticLockException,
            InvalidResourceException, AwsServiceException, SdkClientException, ShieldException {
        return associateHealthCheck(AssociateHealthCheckRequest.builder().applyMutation(associateHealthCheckRequest).build());
    }

    /**
     * <p>
     * Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You
     * must provide at least one phone number in the emergency contact list.
     * </p>
     * <p>
     * After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use
     * the calls <code>DisableProactiveEngagement</code> and <code>EnableProactiveEngagement</code>.
     * </p>
     * <note>
     * <p>
     * This call defines the list of email addresses and phone numbers that the SRT can use to contact you for
     * escalations to the SRT and to initiate proactive customer support.
     * </p>
     * <p>
     * The contacts that you provide in the request replace any contacts that were already defined. If you already have
     * contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and
     * then provide it to this call.
     * </p>
     * </note>
     *
     * @param associateProactiveEngagementDetailsRequest
     * @return Result of the AssociateProactiveEngagementDetails operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateProactiveEngagementDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateProactiveEngagementDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateProactiveEngagementDetailsResponse associateProactiveEngagementDetails(
            AssociateProactiveEngagementDetailsRequest associateProactiveEngagementDetailsRequest) throws InternalErrorException,
            InvalidOperationException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initializes proactive engagement and sets the list of contacts for the Shield Response Team (SRT) to use. You
     * must provide at least one phone number in the emergency contact list.
     * </p>
     * <p>
     * After you have initialized proactive engagement using this call, to disable or enable proactive engagement, use
     * the calls <code>DisableProactiveEngagement</code> and <code>EnableProactiveEngagement</code>.
     * </p>
     * <note>
     * <p>
     * This call defines the list of email addresses and phone numbers that the SRT can use to contact you for
     * escalations to the SRT and to initiate proactive customer support.
     * </p>
     * <p>
     * The contacts that you provide in the request replace any contacts that were already defined. If you already have
     * contacts defined and want to use them, retrieve the list using <code>DescribeEmergencyContactSettings</code> and
     * then provide it to this call.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateProactiveEngagementDetailsRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateProactiveEngagementDetailsRequest#builder()}
     * </p>
     *
     * @param associateProactiveEngagementDetailsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateProactiveEngagementDetailsRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateProactiveEngagementDetails operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.AssociateProactiveEngagementDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/AssociateProactiveEngagementDetails"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateProactiveEngagementDetailsResponse associateProactiveEngagementDetails(
            Consumer<AssociateProactiveEngagementDetailsRequest.Builder> associateProactiveEngagementDetailsRequest)
            throws InternalErrorException, InvalidOperationException, InvalidParameterException, ResourceNotFoundException,
            OptimisticLockException, AwsServiceException, SdkClientException, ShieldException {
        return associateProactiveEngagementDetails(AssociateProactiveEngagementDetailsRequest.builder()
                .applyMutation(associateProactiveEngagementDetailsRequest).build());
    }

    /**
     * <p>
     * Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront
     * distribution, Amazon Route 53 hosted zone, Global Accelerator standard accelerator, Elastic IP Address,
     * Application Load Balancer, or a Classic Load Balancer. You can protect Amazon EC2 instances and Network Load
     * Balancers by association with protected Amazon EC2 Elastic IP addresses.
     * </p>
     * <p>
     * You can add protection to only a single resource with each <code>CreateProtection</code> request. You can add
     * protection to multiple resources at once through the Shield Advanced console at <a
     * href="https://console.aws.amazon.com/wafv2/shieldv2#/">https://console.aws.amazon.com/wafv2/shieldv2#/</a>. For
     * more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with
     * Shield Advanced</a> and <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Adding Shield Advanced
     * protection to Amazon Web Services resources</a>.
     * </p>
     *
     * @param createProtectionRequest
     * @return Result of the CreateProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProtectionResponse createProtection(CreateProtectionRequest createProtectionRequest)
            throws InternalErrorException, InvalidResourceException, InvalidOperationException, LimitsExceededException,
            ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException, InvalidParameterException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Shield Advanced for a specific Amazon Web Services resource. The resource can be an Amazon CloudFront
     * distribution, Amazon Route 53 hosted zone, Global Accelerator standard accelerator, Elastic IP Address,
     * Application Load Balancer, or a Classic Load Balancer. You can protect Amazon EC2 instances and Network Load
     * Balancers by association with protected Amazon EC2 Elastic IP addresses.
     * </p>
     * <p>
     * You can add protection to only a single resource with each <code>CreateProtection</code> request. You can add
     * protection to multiple resources at once through the Shield Advanced console at <a
     * href="https://console.aws.amazon.com/wafv2/shieldv2#/">https://console.aws.amazon.com/wafv2/shieldv2#/</a>. For
     * more information see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with
     * Shield Advanced</a> and <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/configure-new-protection.html">Adding Shield Advanced
     * protection to Amazon Web Services resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateProtectionRequest#builder()}
     * </p>
     *
     * @param createProtectionRequest
     *        A {@link Consumer} that will call methods on {@link CreateProtectionRequest.Builder} to create a request.
     * @return Result of the CreateProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateProtectionResponse createProtection(Consumer<CreateProtectionRequest.Builder> createProtectionRequest)
            throws InternalErrorException, InvalidResourceException, InvalidOperationException, LimitsExceededException,
            ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException, InvalidParameterException,
            AwsServiceException, SdkClientException, ShieldException {
        return createProtection(CreateProtectionRequest.builder().applyMutation(createProtectionRequest).build());
    }

    /**
     * <p>
     * Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves
     * the accuracy of detection and reduces false positives.
     * </p>
     *
     * @param createProtectionGroupRequest
     * @return Result of the CreateProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProtectionGroupResponse createProtectionGroup(CreateProtectionGroupRequest createProtectionGroupRequest)
            throws InternalErrorException, ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException,
            InvalidParameterException, LimitsExceededException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a grouping of protected resources so they can be handled as a collective. This resource grouping improves
     * the accuracy of detection and reduces false positives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProtectionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProtectionGroupRequest#builder()}
     * </p>
     *
     * @param createProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateProtectionGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateProtectionGroupResponse createProtectionGroup(
            Consumer<CreateProtectionGroupRequest.Builder> createProtectionGroupRequest) throws InternalErrorException,
            ResourceAlreadyExistsException, OptimisticLockException, ResourceNotFoundException, InvalidParameterException,
            LimitsExceededException, AwsServiceException, SdkClientException, ShieldException {
        return createProtectionGroup(CreateProtectionGroupRequest.builder().applyMutation(createProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Activates Shield Advanced for an account.
     * </p>
     * <note>
     * <p>
     * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against
     * the organization's payer account, regardless of whether the payer account itself is subscribed.
     * </p>
     * </note>
     * <p>
     * When you initially create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     *
     * @param createSubscriptionRequest
     * @return Result of the CreateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSubscriptionResponse createSubscription(CreateSubscriptionRequest createSubscriptionRequest)
            throws InternalErrorException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates Shield Advanced for an account.
     * </p>
     * <note>
     * <p>
     * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against
     * the organization's payer account, regardless of whether the payer account itself is subscribed.
     * </p>
     * </note>
     * <p>
     * When you initially create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSubscriptionRequest#builder()}
     * </p>
     *
     * @param createSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSubscriptionResponse createSubscription(Consumer<CreateSubscriptionRequest.Builder> createSubscriptionRequest)
            throws InternalErrorException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            ShieldException {
        return createSubscription(CreateSubscriptionRequest.builder().applyMutation(createSubscriptionRequest).build());
    }

    /**
     * <p>
     * Activates Shield Advanced for an account.
     * </p>
     * <note>
     * <p>
     * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against
     * the organization's payer account, regardless of whether the payer account itself is subscribed.
     * </p>
     * </note>
     * <p>
     * When you initially create a subscription, your subscription is set to be automatically renewed at the end of the
     * existing subscription period. You can change this by submitting an <code>UpdateSubscription</code> request.
     * </p>
     *
     * @return Result of the CreateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceAlreadyExistsException
     *         Exception indicating the specified resource already exists. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.CreateSubscription
     * @see #createSubscription(CreateSubscriptionRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/CreateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSubscriptionResponse createSubscription() throws InternalErrorException, ResourceAlreadyExistsException,
            AwsServiceException, SdkClientException, ShieldException {
        return createSubscription(CreateSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Deletes an Shield Advanced <a>Protection</a>.
     * </p>
     *
     * @param deleteProtectionRequest
     * @return Result of the DeleteProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProtectionResponse deleteProtection(DeleteProtectionRequest deleteProtectionRequest)
            throws InternalErrorException, ResourceNotFoundException, OptimisticLockException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Shield Advanced <a>Protection</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProtectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteProtectionRequest#builder()}
     * </p>
     *
     * @param deleteProtectionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProtectionRequest.Builder} to create a request.
     * @return Result of the DeleteProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DeleteProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteProtectionResponse deleteProtection(Consumer<DeleteProtectionRequest.Builder> deleteProtectionRequest)
            throws InternalErrorException, ResourceNotFoundException, OptimisticLockException, AwsServiceException,
            SdkClientException, ShieldException {
        return deleteProtection(DeleteProtectionRequest.builder().applyMutation(deleteProtectionRequest).build());
    }

    /**
     * <p>
     * Removes the specified protection group.
     * </p>
     *
     * @param deleteProtectionGroupRequest
     * @return Result of the DeleteProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DeleteProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProtectionGroupResponse deleteProtectionGroup(DeleteProtectionGroupRequest deleteProtectionGroupRequest)
            throws InternalErrorException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified protection group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProtectionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProtectionGroupRequest#builder()}
     * </p>
     *
     * @param deleteProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProtectionGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DeleteProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DeleteProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteProtectionGroupResponse deleteProtectionGroup(
            Consumer<DeleteProtectionGroupRequest.Builder> deleteProtectionGroupRequest) throws InternalErrorException,
            OptimisticLockException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return deleteProtectionGroup(DeleteProtectionGroupRequest.builder().applyMutation(deleteProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Describes the details of a DDoS attack.
     * </p>
     *
     * @param describeAttackRequest
     * @return Result of the DescribeAttack operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws AccessDeniedException
     *         Exception that indicates the specified <code>AttackId</code> does not exist, or the requester does not
     *         have the appropriate permissions to access the <code>AttackId</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeAttack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAttackResponse describeAttack(DescribeAttackRequest describeAttackRequest) throws InternalErrorException,
            AccessDeniedException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details of a DDoS attack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAttackRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeAttackRequest#builder()}
     * </p>
     *
     * @param describeAttackRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAttackRequest.Builder} to create a request.
     * @return Result of the DescribeAttack operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws AccessDeniedException
     *         Exception that indicates the specified <code>AttackId</code> does not exist, or the requester does not
     *         have the appropriate permissions to access the <code>AttackId</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeAttack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttack" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAttackResponse describeAttack(Consumer<DescribeAttackRequest.Builder> describeAttackRequest)
            throws InternalErrorException, AccessDeniedException, AwsServiceException, SdkClientException, ShieldException {
        return describeAttack(DescribeAttackRequest.builder().applyMutation(describeAttackRequest).build());
    }

    /**
     * <p>
     * Provides information about the number and type of attacks Shield has detected in the last year for all resources
     * that belong to your account, regardless of whether you've defined Shield protections for them. This operation is
     * available to Shield customers as well as to Shield Advanced customers.
     * </p>
     * <p>
     * The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example,
     * if the current time is <code>2020-10-26 15:39:32 PDT</code>, equal to <code>2020-10-26 22:39:32 UTC</code>, then
     * the time range for the attack data returned is from <code>2019-10-26 00:00:00 UTC</code> to
     * <code>2020-10-26 00:00:00 UTC</code>.
     * </p>
     * <p>
     * The time range indicates the period covered by the attack statistics data items.
     * </p>
     *
     * @param describeAttackStatisticsRequest
     * @return Result of the DescribeAttackStatistics operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeAttackStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttackStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAttackStatisticsResponse describeAttackStatistics(
            DescribeAttackStatisticsRequest describeAttackStatisticsRequest) throws InternalErrorException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the number and type of attacks Shield has detected in the last year for all resources
     * that belong to your account, regardless of whether you've defined Shield protections for them. This operation is
     * available to Shield customers as well as to Shield Advanced customers.
     * </p>
     * <p>
     * The operation returns data for the time range of midnight UTC, one year ago, to midnight UTC, today. For example,
     * if the current time is <code>2020-10-26 15:39:32 PDT</code>, equal to <code>2020-10-26 22:39:32 UTC</code>, then
     * the time range for the attack data returned is from <code>2019-10-26 00:00:00 UTC</code> to
     * <code>2020-10-26 00:00:00 UTC</code>.
     * </p>
     * <p>
     * The time range indicates the period covered by the attack statistics data items.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAttackStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAttackStatisticsRequest#builder()}
     * </p>
     *
     * @param describeAttackStatisticsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAttackStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAttackStatistics operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeAttackStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeAttackStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAttackStatisticsResponse describeAttackStatistics(
            Consumer<DescribeAttackStatisticsRequest.Builder> describeAttackStatisticsRequest) throws InternalErrorException,
            AwsServiceException, SdkClientException, ShieldException {
        return describeAttackStatistics(DescribeAttackStatisticsRequest.builder().applyMutation(describeAttackStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your
     * Amazon Web Services account while assisting with attack mitigation.
     * </p>
     *
     * @param describeDrtAccessRequest
     * @return Result of the DescribeDRTAccess operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeDRTAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDrtAccessResponse describeDRTAccess(DescribeDrtAccessRequest describeDrtAccessRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the current role and list of Amazon S3 log buckets used by the Shield Response Team (SRT) to access your
     * Amazon Web Services account while assisting with attack mitigation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDrtAccessRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDrtAccessRequest#builder()}
     * </p>
     *
     * @param describeDrtAccessRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDRTAccessRequest.Builder} to create a request.
     * @return Result of the DescribeDRTAccess operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeDRTAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDrtAccessResponse describeDRTAccess(Consumer<DescribeDrtAccessRequest.Builder> describeDrtAccessRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return describeDRTAccess(DescribeDrtAccessRequest.builder().applyMutation(describeDrtAccessRequest).build());
    }

    /**
     * <p>
     * A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you
     * have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
     * </p>
     *
     * @param describeEmergencyContactSettingsRequest
     * @return Result of the DescribeEmergencyContactSettings operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeEmergencyContactSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEmergencyContactSettingsResponse describeEmergencyContactSettings(
            DescribeEmergencyContactSettingsRequest describeEmergencyContactSettingsRequest) throws InternalErrorException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of email addresses and phone numbers that the Shield Response Team (SRT) can use to contact you if you
     * have proactive engagement enabled, for escalations to the SRT and to initiate proactive customer support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEmergencyContactSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEmergencyContactSettingsRequest#builder()}
     * </p>
     *
     * @param describeEmergencyContactSettingsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEmergencyContactSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeEmergencyContactSettings operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeEmergencyContactSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEmergencyContactSettingsResponse describeEmergencyContactSettings(
            Consumer<DescribeEmergencyContactSettingsRequest.Builder> describeEmergencyContactSettingsRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return describeEmergencyContactSettings(DescribeEmergencyContactSettingsRequest.builder()
                .applyMutation(describeEmergencyContactSettingsRequest).build());
    }

    /**
     * <p>
     * Lists the details of a <a>Protection</a> object.
     * </p>
     *
     * @param describeProtectionRequest
     * @return Result of the DescribeProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProtectionResponse describeProtection(DescribeProtectionRequest describeProtectionRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of a <a>Protection</a> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProtectionRequest#builder()}
     * </p>
     *
     * @param describeProtectionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProtectionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProtection operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeProtection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeProtectionResponse describeProtection(Consumer<DescribeProtectionRequest.Builder> describeProtectionRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return describeProtection(DescribeProtectionRequest.builder().applyMutation(describeProtectionRequest).build());
    }

    /**
     * <p>
     * Returns the specification for the specified protection group.
     * </p>
     *
     * @param describeProtectionGroupRequest
     * @return Result of the DescribeProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectionGroupResponse describeProtectionGroup(DescribeProtectionGroupRequest describeProtectionGroupRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the specification for the specified protection group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProtectionGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeProtectionGroupRequest#builder()}
     * </p>
     *
     * @param describeProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProtectionGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProtectionGroupResponse describeProtectionGroup(
            Consumer<DescribeProtectionGroupRequest.Builder> describeProtectionGroupRequest) throws InternalErrorException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return describeProtectionGroup(DescribeProtectionGroupRequest.builder().applyMutation(describeProtectionGroupRequest)
                .build());
    }

    /**
     * <p>
     * Provides details about the Shield Advanced subscription for an account.
     * </p>
     *
     * @param describeSubscriptionRequest
     * @return Result of the DescribeSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubscriptionResponse describeSubscription(DescribeSubscriptionRequest describeSubscriptionRequest)
            throws InternalErrorException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about the Shield Advanced subscription for an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSubscriptionRequest#builder()}
     * </p>
     *
     * @param describeSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubscriptionResponse describeSubscription(
            Consumer<DescribeSubscriptionRequest.Builder> describeSubscriptionRequest) throws InternalErrorException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return describeSubscription(DescribeSubscriptionRequest.builder().applyMutation(describeSubscriptionRequest).build());
    }

    /**
     * <p>
     * Provides details about the Shield Advanced subscription for an account.
     * </p>
     *
     * @return Result of the DescribeSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DescribeSubscription
     * @see #describeSubscription(DescribeSubscriptionRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeSubscription" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSubscriptionResponse describeSubscription() throws InternalErrorException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        return describeSubscription(DescribeSubscriptionRequest.builder().build());
    }

    /**
     * <p>
     * Disable the Shield Advanced automatic application layer DDoS mitigation feature for the protected resource. This
     * stops Shield Advanced from creating, verifying, and applying WAF rules for attacks that it detects for the
     * resource.
     * </p>
     *
     * @param disableApplicationLayerAutomaticResponseRequest
     * @return Result of the DisableApplicationLayerAutomaticResponse operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisableApplicationLayerAutomaticResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisableApplicationLayerAutomaticResponse"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableApplicationLayerAutomaticResponseResponse disableApplicationLayerAutomaticResponse(
            DisableApplicationLayerAutomaticResponseRequest disableApplicationLayerAutomaticResponseRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disable the Shield Advanced automatic application layer DDoS mitigation feature for the protected resource. This
     * stops Shield Advanced from creating, verifying, and applying WAF rules for attacks that it detects for the
     * resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisableApplicationLayerAutomaticResponseRequest.Builder} avoiding the need to create one manually via
     * {@link DisableApplicationLayerAutomaticResponseRequest#builder()}
     * </p>
     *
     * @param disableApplicationLayerAutomaticResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DisableApplicationLayerAutomaticResponseRequest.Builder} to create a request.
     * @return Result of the DisableApplicationLayerAutomaticResponse operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisableApplicationLayerAutomaticResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisableApplicationLayerAutomaticResponse"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableApplicationLayerAutomaticResponseResponse disableApplicationLayerAutomaticResponse(
            Consumer<DisableApplicationLayerAutomaticResponseRequest.Builder> disableApplicationLayerAutomaticResponseRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        return disableApplicationLayerAutomaticResponse(DisableApplicationLayerAutomaticResponseRequest.builder()
                .applyMutation(disableApplicationLayerAutomaticResponseRequest).build());
    }

    /**
     * <p>
     * Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to
     * initiate proactive customer support.
     * </p>
     *
     * @param disableProactiveEngagementRequest
     * @return Result of the DisableProactiveEngagement operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisableProactiveEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisableProactiveEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableProactiveEngagementResponse disableProactiveEngagement(
            DisableProactiveEngagementRequest disableProactiveEngagementRequest) throws InternalErrorException,
            InvalidOperationException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes authorization from the Shield Response Team (SRT) to notify contacts about escalations to the SRT and to
     * initiate proactive customer support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableProactiveEngagementRequest.Builder} avoiding
     * the need to create one manually via {@link DisableProactiveEngagementRequest#builder()}
     * </p>
     *
     * @param disableProactiveEngagementRequest
     *        A {@link Consumer} that will call methods on {@link DisableProactiveEngagementRequest.Builder} to create a
     *        request.
     * @return Result of the DisableProactiveEngagement operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisableProactiveEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisableProactiveEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableProactiveEngagementResponse disableProactiveEngagement(
            Consumer<DisableProactiveEngagementRequest.Builder> disableProactiveEngagementRequest) throws InternalErrorException,
            InvalidOperationException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            AwsServiceException, SdkClientException, ShieldException {
        return disableProactiveEngagement(DisableProactiveEngagementRequest.builder()
                .applyMutation(disableProactiveEngagementRequest).build());
    }

    /**
     * <p>
     * Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you
     * shared previously.
     * </p>
     *
     * @param disassociateDrtLogBucketRequest
     * @return Result of the DisassociateDRTLogBucket operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws NoAssociatedRoleException
     *         The ARN of the role that you specified does not exist.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request
     *         must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the
     *         appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an Amazon Web Services Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTLogBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTLogBucket"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDrtLogBucketResponse disassociateDRTLogBucket(
            DisassociateDrtLogBucketRequest disassociateDrtLogBucketRequest) throws InternalErrorException,
            InvalidOperationException, NoAssociatedRoleException, AccessDeniedForDependencyException, OptimisticLockException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the Shield Response Team's (SRT) access to the specified Amazon S3 bucket containing the logs that you
     * shared previously.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDrtLogBucketRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateDrtLogBucketRequest#builder()}
     * </p>
     *
     * @param disassociateDrtLogBucketRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDRTLogBucketRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateDRTLogBucket operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws NoAssociatedRoleException
     *         The ARN of the role that you specified does not exist.
     * @throws AccessDeniedForDependencyException
     *         In order to grant the necessary access to the Shield Response Team (SRT) the user submitting the request
     *         must have the <code>iam:PassRole</code> permission. This error indicates the user did not have the
     *         appropriate permissions. For more information, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">Granting a User
     *         Permissions to Pass a Role to an Amazon Web Services Service</a>.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTLogBucket
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTLogBucket"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDrtLogBucketResponse disassociateDRTLogBucket(
            Consumer<DisassociateDrtLogBucketRequest.Builder> disassociateDrtLogBucketRequest) throws InternalErrorException,
            InvalidOperationException, NoAssociatedRoleException, AccessDeniedForDependencyException, OptimisticLockException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return disassociateDRTLogBucket(DisassociateDrtLogBucketRequest.builder().applyMutation(disassociateDrtLogBucketRequest)
                .build());
    }

    /**
     * <p>
     * Removes the Shield Response Team's (SRT) access to your Amazon Web Services account.
     * </p>
     *
     * @param disassociateDrtRoleRequest
     * @return Result of the DisassociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateDrtRoleResponse disassociateDRTRole(DisassociateDrtRoleRequest disassociateDrtRoleRequest)
            throws InternalErrorException, InvalidOperationException, OptimisticLockException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the Shield Response Team's (SRT) access to your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDrtRoleRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateDrtRoleRequest#builder()}
     * </p>
     *
     * @param disassociateDrtRoleRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDRTRoleRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateDrtRoleResponse disassociateDRTRole(
            Consumer<DisassociateDrtRoleRequest.Builder> disassociateDrtRoleRequest) throws InternalErrorException,
            InvalidOperationException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        return disassociateDRTRole(DisassociateDrtRoleRequest.builder().applyMutation(disassociateDrtRoleRequest).build());
    }

    /**
     * <p>
     * Removes the Shield Response Team's (SRT) access to your Amazon Web Services account.
     * </p>
     *
     * @return Result of the DisassociateDRTRole operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateDRTRole
     * @see #disassociateDRTRole(DisassociateDrtRoleRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateDRTRole" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateDrtRoleResponse disassociateDRTRole() throws InternalErrorException, InvalidOperationException,
            OptimisticLockException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return disassociateDRTRole(DisassociateDrtRoleRequest.builder().build());
    }

    /**
     * <p>
     * Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack
     * detection and response.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced
     * protection. For more information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>.
     * </p>
     *
     * @param disassociateHealthCheckRequest
     * @return Result of the DisassociateHealthCheck operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateHealthCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateHealthCheckResponse disassociateHealthCheck(DisassociateHealthCheckRequest disassociateHealthCheckRequest)
            throws InternalErrorException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            InvalidResourceException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes health-based detection from the Shield Advanced protection for a resource. Shield Advanced health-based
     * detection uses the health of your Amazon Web Services resource to improve responsiveness and accuracy in attack
     * detection and response.
     * </p>
     * <p>
     * You define the health check in Route 53 and then associate or disassociate it with your Shield Advanced
     * protection. For more information, see <a href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option"
     * >Shield Advanced Health-Based Detection</a> in the <i>WAF Developer Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateHealthCheckRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateHealthCheckRequest#builder()}
     * </p>
     *
     * @param disassociateHealthCheckRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateHealthCheckRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateHealthCheck operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.DisassociateHealthCheck
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DisassociateHealthCheck"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateHealthCheckResponse disassociateHealthCheck(
            Consumer<DisassociateHealthCheckRequest.Builder> disassociateHealthCheckRequest) throws InternalErrorException,
            InvalidParameterException, ResourceNotFoundException, OptimisticLockException, InvalidResourceException,
            AwsServiceException, SdkClientException, ShieldException {
        return disassociateHealthCheck(DisassociateHealthCheckRequest.builder().applyMutation(disassociateHealthCheckRequest)
                .build());
    }

    /**
     * <p>
     * Enable the Shield Advanced automatic application layer DDoS mitigation for the protected resource.
     * </p>
     * <note>
     * <p>
     * This feature is available for Amazon CloudFront distributions and Application Load Balancers only.
     * </p>
     * </note>
     * <p>
     * This causes Shield Advanced to create, verify, and apply WAF rules for DDoS attacks that it detects for the
     * resource. Shield Advanced applies the rules in a Shield rule group inside the web ACL that you've associated with
     * the resource. For information about how automatic mitigation works and the requirements for using it, see <a
     * href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-advanced-automatic-app-layer-response.html">Shield
     * Advanced automatic application layer DDoS mitigation</a>.
     * </p>
     * <note>
     * <p>
     * Don't use this action to make changes to automatic mitigation settings when it's already enabled for a resource.
     * Instead, use <a>UpdateApplicationLayerAutomaticResponse</a>.
     * </p>
     * </note>
     * <p>
     * To use this feature, you must associate a web ACL with the protected resource. The web ACL must be created using
     * the latest version of WAF (v2). You can associate the web ACL through the Shield Advanced console at <a
     * href="https://console.aws.amazon.com/wafv2/shieldv2#/">https://console.aws.amazon.com/wafv2/shieldv2#/</a>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with
     * Shield Advanced</a>. You can also associate the web ACL to the resource through the WAF console or the WAF API,
     * but you must manage Shield Advanced automatic mitigation through Shield Advanced. For information about WAF, see
     * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">WAF Developer Guide</a>.
     * </p>
     *
     * @param enableApplicationLayerAutomaticResponseRequest
     * @return Result of the EnableApplicationLayerAutomaticResponse operation returned by the service.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.EnableApplicationLayerAutomaticResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/EnableApplicationLayerAutomaticResponse"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableApplicationLayerAutomaticResponseResponse enableApplicationLayerAutomaticResponse(
            EnableApplicationLayerAutomaticResponseRequest enableApplicationLayerAutomaticResponseRequest)
            throws LimitsExceededException, InternalErrorException, ResourceNotFoundException, InvalidParameterException,
            OptimisticLockException, InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enable the Shield Advanced automatic application layer DDoS mitigation for the protected resource.
     * </p>
     * <note>
     * <p>
     * This feature is available for Amazon CloudFront distributions and Application Load Balancers only.
     * </p>
     * </note>
     * <p>
     * This causes Shield Advanced to create, verify, and apply WAF rules for DDoS attacks that it detects for the
     * resource. Shield Advanced applies the rules in a Shield rule group inside the web ACL that you've associated with
     * the resource. For information about how automatic mitigation works and the requirements for using it, see <a
     * href=
     * "https://docs.aws.amazon.com/waf/latest/developerguide/ddos-advanced-automatic-app-layer-response.html">Shield
     * Advanced automatic application layer DDoS mitigation</a>.
     * </p>
     * <note>
     * <p>
     * Don't use this action to make changes to automatic mitigation settings when it's already enabled for a resource.
     * Instead, use <a>UpdateApplicationLayerAutomaticResponse</a>.
     * </p>
     * </note>
     * <p>
     * To use this feature, you must associate a web ACL with the protected resource. The web ACL must be created using
     * the latest version of WAF (v2). You can associate the web ACL through the Shield Advanced console at <a
     * href="https://console.aws.amazon.com/wafv2/shieldv2#/">https://console.aws.amazon.com/wafv2/shieldv2#/</a>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/waf/latest/developerguide/getting-started-ddos.html">Getting Started with
     * Shield Advanced</a>. You can also associate the web ACL to the resource through the WAF console or the WAF API,
     * but you must manage Shield Advanced automatic mitigation through Shield Advanced. For information about WAF, see
     * <a href="https://docs.aws.amazon.com/waf/latest/developerguide/">WAF Developer Guide</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link EnableApplicationLayerAutomaticResponseRequest.Builder} avoiding the need to create one manually via
     * {@link EnableApplicationLayerAutomaticResponseRequest#builder()}
     * </p>
     *
     * @param enableApplicationLayerAutomaticResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link EnableApplicationLayerAutomaticResponseRequest.Builder} to create a request.
     * @return Result of the EnableApplicationLayerAutomaticResponse operation returned by the service.
     * @throws LimitsExceededException
     *         Exception that indicates that the operation would exceed a limit.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.EnableApplicationLayerAutomaticResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/EnableApplicationLayerAutomaticResponse"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableApplicationLayerAutomaticResponseResponse enableApplicationLayerAutomaticResponse(
            Consumer<EnableApplicationLayerAutomaticResponseRequest.Builder> enableApplicationLayerAutomaticResponseRequest)
            throws LimitsExceededException, InternalErrorException, ResourceNotFoundException, InvalidParameterException,
            OptimisticLockException, InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        return enableApplicationLayerAutomaticResponse(EnableApplicationLayerAutomaticResponseRequest.builder()
                .applyMutation(enableApplicationLayerAutomaticResponseRequest).build());
    }

    /**
     * <p>
     * Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT
     * and to initiate proactive customer support.
     * </p>
     *
     * @param enableProactiveEngagementRequest
     * @return Result of the EnableProactiveEngagement operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.EnableProactiveEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/EnableProactiveEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableProactiveEngagementResponse enableProactiveEngagement(
            EnableProactiveEngagementRequest enableProactiveEngagementRequest) throws InternalErrorException,
            InvalidOperationException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Authorizes the Shield Response Team (SRT) to use email and phone to notify contacts about escalations to the SRT
     * and to initiate proactive customer support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableProactiveEngagementRequest.Builder} avoiding
     * the need to create one manually via {@link EnableProactiveEngagementRequest#builder()}
     * </p>
     *
     * @param enableProactiveEngagementRequest
     *        A {@link Consumer} that will call methods on {@link EnableProactiveEngagementRequest.Builder} to create a
     *        request.
     * @return Result of the EnableProactiveEngagement operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.EnableProactiveEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/EnableProactiveEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableProactiveEngagementResponse enableProactiveEngagement(
            Consumer<EnableProactiveEngagementRequest.Builder> enableProactiveEngagementRequest) throws InternalErrorException,
            InvalidOperationException, InvalidParameterException, ResourceNotFoundException, OptimisticLockException,
            AwsServiceException, SdkClientException, ShieldException {
        return enableProactiveEngagement(EnableProactiveEngagementRequest.builder()
                .applyMutation(enableProactiveEngagementRequest).build());
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     *
     * @param getSubscriptionStateRequest
     * @return Result of the GetSubscriptionState operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.GetSubscriptionState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriptionStateResponse getSubscriptionState(GetSubscriptionStateRequest getSubscriptionStateRequest)
            throws InternalErrorException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSubscriptionStateRequest.Builder} avoiding the
     * need to create one manually via {@link GetSubscriptionStateRequest#builder()}
     * </p>
     *
     * @param getSubscriptionStateRequest
     *        A {@link Consumer} that will call methods on {@link GetSubscriptionStateRequest.Builder} to create a
     *        request.
     * @return Result of the GetSubscriptionState operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.GetSubscriptionState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriptionStateResponse getSubscriptionState(
            Consumer<GetSubscriptionStateRequest.Builder> getSubscriptionStateRequest) throws InternalErrorException,
            AwsServiceException, SdkClientException, ShieldException {
        return getSubscriptionState(GetSubscriptionStateRequest.builder().applyMutation(getSubscriptionStateRequest).build());
    }

    /**
     * <p>
     * Returns the <code>SubscriptionState</code>, either <code>Active</code> or <code>Inactive</code>.
     * </p>
     *
     * @return Result of the GetSubscriptionState operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.GetSubscriptionState
     * @see #getSubscriptionState(GetSubscriptionStateRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/GetSubscriptionState" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSubscriptionStateResponse getSubscriptionState() throws InternalErrorException, AwsServiceException,
            SdkClientException, ShieldException {
        return getSubscriptionState(GetSubscriptionStateRequest.builder().build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     *
     * @param listAttacksRequest
     * @return Result of the ListAttacks operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksResponse listAttacks(ListAttacksRequest listAttacksRequest) throws InternalErrorException,
            InvalidParameterException, InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttacksRequest#builder()}
     * </p>
     *
     * @param listAttacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAttacksRequest.Builder} to create a request.
     * @return Result of the ListAttacks operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksResponse listAttacks(Consumer<ListAttacksRequest.Builder> listAttacksRequest)
            throws InternalErrorException, InvalidParameterException, InvalidOperationException, AwsServiceException,
            SdkClientException, ShieldException {
        return listAttacks(ListAttacksRequest.builder().applyMutation(listAttacksRequest).build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     *
     * @return Result of the ListAttacks operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see #listAttacks(ListAttacksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksResponse listAttacks() throws InternalErrorException, InvalidParameterException,
            InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        return listAttacks(ListAttacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListAttacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see #listAttacksPaginator(ListAttacksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksIterable listAttacksPaginator() throws InternalErrorException, InvalidParameterException,
            InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        return listAttacksPaginator(ListAttacksRequest.builder().build());
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListAttacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)} operation.</b>
     * </p>
     *
     * @param listAttacksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksIterable listAttacksPaginator(ListAttacksRequest listAttacksRequest) throws InternalErrorException,
            InvalidParameterException, InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        return new ListAttacksIterable(this, listAttacksRequest);
    }

    /**
     * <p>
     * Returns all ongoing DDoS attacks or all DDoS attacks during a specified time period.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListAttacksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListAttacksIterable responses = client.listAttacksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttacks(software.amazon.awssdk.services.shield.model.ListAttacksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttacksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAttacksRequest#builder()}
     * </p>
     *
     * @param listAttacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAttacksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListAttacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListAttacks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAttacksIterable listAttacksPaginator(Consumer<ListAttacksRequest.Builder> listAttacksRequest)
            throws InternalErrorException, InvalidParameterException, InvalidOperationException, AwsServiceException,
            SdkClientException, ShieldException {
        return listAttacksPaginator(ListAttacksRequest.builder().applyMutation(listAttacksRequest).build());
    }

    /**
     * <p>
     * Retrieves <a>ProtectionGroup</a> objects for the account. You can retrieve all protection groups or you can
     * provide filtering criteria and retrieve just the subset of protection groups that match the criteria.
     * </p>
     *
     * @param listProtectionGroupsRequest
     * @return Result of the ListProtectionGroups operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtectionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectionGroupsResponse listProtectionGroups(ListProtectionGroupsRequest listProtectionGroupsRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves <a>ProtectionGroup</a> objects for the account. You can retrieve all protection groups or you can
     * provide filtering criteria and retrieve just the subset of protection groups that match the criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectionGroupsRequest#builder()}
     * </p>
     *
     * @param listProtectionGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListProtectionGroups operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtectionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectionGroupsResponse listProtectionGroups(
            Consumer<ListProtectionGroupsRequest.Builder> listProtectionGroupsRequest) throws InternalErrorException,
            ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        return listProtectionGroups(ListProtectionGroupsRequest.builder().applyMutation(listProtectionGroupsRequest).build());
    }

    /**
     * <p>
     * Retrieves <a>ProtectionGroup</a> objects for the account. You can retrieve all protection groups or you can
     * provide filtering criteria and retrieve just the subset of protection groups that match the criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectionGroups(software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsIterable responses = client.listProtectionGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsIterable responses = client
     *             .listProtectionGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsIterable responses = client.listProtectionGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectionGroups(software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProtectionGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtectionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectionGroupsIterable listProtectionGroupsPaginator(ListProtectionGroupsRequest listProtectionGroupsRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, ShieldException {
        return new ListProtectionGroupsIterable(this, listProtectionGroupsRequest);
    }

    /**
     * <p>
     * Retrieves <a>ProtectionGroup</a> objects for the account. You can retrieve all protection groups or you can
     * provide filtering criteria and retrieve just the subset of protection groups that match the criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtectionGroups(software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsIterable responses = client.listProtectionGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsIterable responses = client
     *             .listProtectionGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListProtectionGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionGroupsIterable responses = client.listProtectionGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtectionGroups(software.amazon.awssdk.services.shield.model.ListProtectionGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProtectionGroupsRequest#builder()}
     * </p>
     *
     * @param listProtectionGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtectionGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtectionGroups" target="_top">AWS
     *      API Documentation</a>
     */
    default ListProtectionGroupsIterable listProtectionGroupsPaginator(
            Consumer<ListProtectionGroupsRequest.Builder> listProtectionGroupsRequest) throws InternalErrorException,
            ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        return listProtectionGroupsPaginator(ListProtectionGroupsRequest.builder().applyMutation(listProtectionGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves <a>Protection</a> objects for the account. You can retrieve all protections or you can provide
     * filtering criteria and retrieve just the subset of protections that match the criteria.
     * </p>
     *
     * @param listProtectionsRequest
     * @return Result of the ListProtections operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsResponse listProtections(ListProtectionsRequest listProtectionsRequest) throws InternalErrorException,
            ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves <a>Protection</a> objects for the account. You can retrieve all protections or you can provide
     * filtering criteria and retrieve just the subset of protections that match the criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProtectionsRequest#builder()}
     * </p>
     *
     * @param listProtectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionsRequest.Builder} to create a request.
     * @return Result of the ListProtections operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsResponse listProtections(Consumer<ListProtectionsRequest.Builder> listProtectionsRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, ShieldException {
        return listProtections(ListProtectionsRequest.builder().applyMutation(listProtectionsRequest).build());
    }

    /**
     * <p>
     * Retrieves <a>Protection</a> objects for the account. You can retrieve all protections or you can provide
     * filtering criteria and retrieve just the subset of protections that match the criteria.
     * </p>
     *
     * @return Result of the ListProtections operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see #listProtections(ListProtectionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsResponse listProtections() throws InternalErrorException, ResourceNotFoundException,
            InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        return listProtections(ListProtectionsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves <a>Protection</a> objects for the account. You can retrieve all protections or you can provide
     * filtering criteria and retrieve just the subset of protections that match the criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client.listProtectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client
     *             .listProtectionsPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListProtectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client.listProtectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see #listProtectionsPaginator(ListProtectionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsIterable listProtectionsPaginator() throws InternalErrorException, ResourceNotFoundException,
            InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        return listProtectionsPaginator(ListProtectionsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves <a>Protection</a> objects for the account. You can retrieve all protections or you can provide
     * filtering criteria and retrieve just the subset of protections that match the criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client.listProtectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client
     *             .listProtectionsPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListProtectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client.listProtectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation.</b>
     * </p>
     *
     * @param listProtectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsIterable listProtectionsPaginator(ListProtectionsRequest listProtectionsRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, ShieldException {
        return new ListProtectionsIterable(this, listProtectionsRequest);
    }

    /**
     * <p>
     * Retrieves <a>Protection</a> objects for the account. You can retrieve all protections or you can provide
     * filtering criteria and retrieve just the subset of protections that match the criteria.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client.listProtectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client
     *             .listProtectionsPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListProtectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListProtectionsIterable responses = client.listProtectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProtections(software.amazon.awssdk.services.shield.model.ListProtectionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProtectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListProtectionsRequest#builder()}
     * </p>
     *
     * @param listProtectionsRequest
     *        A {@link Consumer} that will call methods on {@link ListProtectionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListProtections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListProtections" target="_top">AWS API
     *      Documentation</a>
     */
    default ListProtectionsIterable listProtectionsPaginator(Consumer<ListProtectionsRequest.Builder> listProtectionsRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, ShieldException {
        return listProtectionsPaginator(ListProtectionsRequest.builder().applyMutation(listProtectionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the resources that are included in the protection group.
     * </p>
     *
     * @param listResourcesInProtectionGroupRequest
     * @return Result of the ListResourcesInProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListResourcesInProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListResourcesInProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesInProtectionGroupResponse listResourcesInProtectionGroup(
            ListResourcesInProtectionGroupRequest listResourcesInProtectionGroupRequest) throws InternalErrorException,
            ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resources that are included in the protection group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesInProtectionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourcesInProtectionGroupRequest#builder()}
     * </p>
     *
     * @param listResourcesInProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesInProtectionGroupRequest.Builder} to
     *        create a request.
     * @return Result of the ListResourcesInProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListResourcesInProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListResourcesInProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesInProtectionGroupResponse listResourcesInProtectionGroup(
            Consumer<ListResourcesInProtectionGroupRequest.Builder> listResourcesInProtectionGroupRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, ShieldException {
        return listResourcesInProtectionGroup(ListResourcesInProtectionGroupRequest.builder()
                .applyMutation(listResourcesInProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the resources that are included in the protection group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesInProtectionGroup(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupIterable responses = client.listResourcesInProtectionGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupIterable responses = client
     *             .listResourcesInProtectionGroupPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupIterable responses = client.listResourcesInProtectionGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesInProtectionGroup(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourcesInProtectionGroupRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListResourcesInProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListResourcesInProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesInProtectionGroupIterable listResourcesInProtectionGroupPaginator(
            ListResourcesInProtectionGroupRequest listResourcesInProtectionGroupRequest) throws InternalErrorException,
            ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, ShieldException {
        return new ListResourcesInProtectionGroupIterable(this, listResourcesInProtectionGroupRequest);
    }

    /**
     * <p>
     * Retrieves the resources that are included in the protection group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourcesInProtectionGroup(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupIterable responses = client.listResourcesInProtectionGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupIterable responses = client
     *             .listResourcesInProtectionGroupPaginator(request);
     *     for (software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.shield.paginators.ListResourcesInProtectionGroupIterable responses = client.listResourcesInProtectionGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourcesInProtectionGroup(software.amazon.awssdk.services.shield.model.ListResourcesInProtectionGroupRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourcesInProtectionGroupRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourcesInProtectionGroupRequest#builder()}
     * </p>
     *
     * @param listResourcesInProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link ListResourcesInProtectionGroupRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidPaginationTokenException
     *         Exception that indicates that the <code>NextToken</code> specified in the request is invalid. Submit the
     *         request using the <code>NextToken</code> value that was returned in the prior response.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListResourcesInProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListResourcesInProtectionGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourcesInProtectionGroupIterable listResourcesInProtectionGroupPaginator(
            Consumer<ListResourcesInProtectionGroupRequest.Builder> listResourcesInProtectionGroupRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidPaginationTokenException, AwsServiceException,
            SdkClientException, ShieldException {
        return listResourcesInProtectionGroupPaginator(ListResourcesInProtectionGroupRequest.builder()
                .applyMutation(listResourcesInProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalErrorException, InvalidResourceException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Shield.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalErrorException,
            InvalidResourceException, ResourceNotFoundException, AwsServiceException, SdkClientException, ShieldException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a resource in Shield.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalErrorException,
            InvalidResourceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a resource in Shield.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalErrorException, InvalidResourceException, InvalidParameterException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource in Shield.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalErrorException,
            InvalidResourceException, InvalidParameterException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource in Shield.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidResourceException
     *         Exception that indicates that the resource is invalid. You might not have access to the resource, or the
     *         resource might not exist.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalErrorException, InvalidResourceException, InvalidParameterException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing Shield Advanced automatic application layer DDoS mitigation configuration for the specified
     * resource.
     * </p>
     *
     * @param updateApplicationLayerAutomaticResponseRequest
     * @return Result of the UpdateApplicationLayerAutomaticResponse operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateApplicationLayerAutomaticResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateApplicationLayerAutomaticResponse"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationLayerAutomaticResponseResponse updateApplicationLayerAutomaticResponse(
            UpdateApplicationLayerAutomaticResponseRequest updateApplicationLayerAutomaticResponseRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidParameterException, OptimisticLockException,
            InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Shield Advanced automatic application layer DDoS mitigation configuration for the specified
     * resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateApplicationLayerAutomaticResponseRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateApplicationLayerAutomaticResponseRequest#builder()}
     * </p>
     *
     * @param updateApplicationLayerAutomaticResponseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link UpdateApplicationLayerAutomaticResponseRequest.Builder} to create a request.
     * @return Result of the UpdateApplicationLayerAutomaticResponse operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidOperationException
     *         Exception that indicates that the operation would not cause any change to occur.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateApplicationLayerAutomaticResponse
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateApplicationLayerAutomaticResponse"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationLayerAutomaticResponseResponse updateApplicationLayerAutomaticResponse(
            Consumer<UpdateApplicationLayerAutomaticResponseRequest.Builder> updateApplicationLayerAutomaticResponseRequest)
            throws InternalErrorException, ResourceNotFoundException, InvalidParameterException, OptimisticLockException,
            InvalidOperationException, AwsServiceException, SdkClientException, ShieldException {
        return updateApplicationLayerAutomaticResponse(UpdateApplicationLayerAutomaticResponseRequest.builder()
                .applyMutation(updateApplicationLayerAutomaticResponseRequest).build());
    }

    /**
     * <p>
     * Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use
     * to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive
     * customer support.
     * </p>
     *
     * @param updateEmergencyContactSettingsRequest
     * @return Result of the UpdateEmergencyContactSettings operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateEmergencyContactSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEmergencyContactSettingsResponse updateEmergencyContactSettings(
            UpdateEmergencyContactSettingsRequest updateEmergencyContactSettingsRequest) throws InternalErrorException,
            InvalidParameterException, OptimisticLockException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of the list of email addresses and phone numbers that the Shield Response Team (SRT) can use
     * to contact you if you have proactive engagement enabled, for escalations to the SRT and to initiate proactive
     * customer support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEmergencyContactSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateEmergencyContactSettingsRequest#builder()}
     * </p>
     *
     * @param updateEmergencyContactSettingsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEmergencyContactSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateEmergencyContactSettings operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateEmergencyContactSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateEmergencyContactSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateEmergencyContactSettingsResponse updateEmergencyContactSettings(
            Consumer<UpdateEmergencyContactSettingsRequest.Builder> updateEmergencyContactSettingsRequest)
            throws InternalErrorException, InvalidParameterException, OptimisticLockException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, ShieldException {
        return updateEmergencyContactSettings(UpdateEmergencyContactSettingsRequest.builder()
                .applyMutation(updateEmergencyContactSettingsRequest).build());
    }

    /**
     * <p>
     * Updates an existing protection group. A protection group is a grouping of protected resources so they can be
     * handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
     * </p>
     *
     * @param updateProtectionGroupRequest
     * @return Result of the UpdateProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProtectionGroupResponse updateProtectionGroup(UpdateProtectionGroupRequest updateProtectionGroupRequest)
            throws InternalErrorException, ResourceNotFoundException, OptimisticLockException, InvalidParameterException,
            AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing protection group. A protection group is a grouping of protected resources so they can be
     * handled as a collective. This resource grouping improves the accuracy of detection and reduces false positives.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProtectionGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateProtectionGroupRequest#builder()}
     * </p>
     *
     * @param updateProtectionGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProtectionGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateProtectionGroup operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateProtectionGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateProtectionGroup" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateProtectionGroupResponse updateProtectionGroup(
            Consumer<UpdateProtectionGroupRequest.Builder> updateProtectionGroupRequest) throws InternalErrorException,
            ResourceNotFoundException, OptimisticLockException, InvalidParameterException, AwsServiceException,
            SdkClientException, ShieldException {
        return updateProtectionGroup(UpdateProtectionGroupRequest.builder().applyMutation(updateProtectionGroupRequest).build());
    }

    /**
     * <p>
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty
     * parameters are not updated.
     * </p>
     * <note>
     * <p>
     * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against
     * the organization's payer account, regardless of whether the payer account itself is subscribed.
     * </p>
     * </note>
     *
     * @param updateSubscriptionRequest
     * @return Result of the UpdateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws LockedSubscriptionException
     *         You are trying to update a subscription that has not yet completed the 1-year commitment. You can change
     *         the <code>AutoRenew</code> parameter during the last 30 days of your subscription. This exception
     *         indicates that you are attempting to change <code>AutoRenew</code> prior to that period.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSubscriptionResponse updateSubscription(UpdateSubscriptionRequest updateSubscriptionRequest)
            throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, InvalidParameterException,
            OptimisticLockException, AwsServiceException, SdkClientException, ShieldException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the details of an existing subscription. Only enter values for parameters you want to change. Empty
     * parameters are not updated.
     * </p>
     * <note>
     * <p>
     * For accounts that are members of an Organizations organization, Shield Advanced subscriptions are billed against
     * the organization's payer account, regardless of whether the payer account itself is subscribed.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSubscriptionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSubscriptionRequest#builder()}
     * </p>
     *
     * @param updateSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSubscriptionRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSubscription operation returned by the service.
     * @throws InternalErrorException
     *         Exception that indicates that a problem occurred with the service infrastructure. You can retry the
     *         request.
     * @throws LockedSubscriptionException
     *         You are trying to update a subscription that has not yet completed the 1-year commitment. You can change
     *         the <code>AutoRenew</code> parameter during the last 30 days of your subscription. This exception
     *         indicates that you are attempting to change <code>AutoRenew</code> prior to that period.
     * @throws ResourceNotFoundException
     *         Exception indicating the specified resource does not exist. If available, this exception includes details
     *         in additional properties.
     * @throws InvalidParameterException
     *         Exception that indicates that the parameters passed to the API are invalid. If available, this exception
     *         includes details in additional properties.
     * @throws OptimisticLockException
     *         Exception that indicates that the resource state has been modified by another client. Retrieve the
     *         resource and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ShieldException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ShieldClient.UpdateSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/UpdateSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSubscriptionResponse updateSubscription(Consumer<UpdateSubscriptionRequest.Builder> updateSubscriptionRequest)
            throws InternalErrorException, LockedSubscriptionException, ResourceNotFoundException, InvalidParameterException,
            OptimisticLockException, AwsServiceException, SdkClientException, ShieldException {
        return updateSubscription(UpdateSubscriptionRequest.builder().applyMutation(updateSubscriptionRequest).build());
    }

    /**
     * Create a {@link ShieldClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ShieldClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ShieldClient}.
     */
    static ShieldClientBuilder builder() {
        return new DefaultShieldClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ShieldServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
