/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalogappregistry;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.AssociateResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ConflictException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.CreateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DeleteAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.DisassociateResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAssociatedResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAssociatedResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetConfigurationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.GetConfigurationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.InternalServerException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.PutConfigurationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.PutConfigurationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceNotFoundException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceCatalogAppRegistryException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.SyncResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.SyncResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.TagResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.TagResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ThrottlingException;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateAttributeGroupRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.UpdateAttributeGroupResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ValidationException;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsIterable;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesIterable;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationIterable;
import software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsIterable;

/**
 * Service client for accessing AppRegistry. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Web Services Service Catalog AppRegistry enables organizations to understand the application context of their
 * Amazon Web Services resources. AppRegistry provides a repository of your applications, their resources, and the
 * application metadata that you use within your enterprise.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ServiceCatalogAppRegistryClient extends AwsClient {
    String SERVICE_NAME = "servicecatalog";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "servicecatalog-appregistry";

    /**
     * <p>
     * Associates an attribute group with an application to augment the application's metadata with the group's
     * attributes. This feature enables applications to be described with user-defined details that are
     * machine-readable, such as third-party integrations.
     * </p>
     *
     * @param associateAttributeGroupRequest
     * @return Result of the AssociateAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ServiceQuotaExceededException
     *         The maximum number of resources per account has been reached.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.AssociateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAttributeGroupResponse associateAttributeGroup(AssociateAttributeGroupRequest associateAttributeGroupRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an attribute group with an application to augment the application's metadata with the group's
     * attributes. This feature enables applications to be described with user-defined details that are
     * machine-readable, such as third-party integrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateAttributeGroupRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateAttributeGroupRequest#builder()}
     * </p>
     *
     * @param associateAttributeGroupRequest
     *        A {@link Consumer} that will call methods on {@link AssociateAttributeGroupRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ServiceQuotaExceededException
     *         The maximum number of resources per account has been reached.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.AssociateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateAttributeGroupResponse associateAttributeGroup(
            Consumer<AssociateAttributeGroupRequest.Builder> associateAttributeGroupRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        return associateAttributeGroup(AssociateAttributeGroupRequest.builder().applyMutation(associateAttributeGroupRequest)
                .build());
    }

    /**
     * <p>
     * Associates a resource with an application. The resource can be specified by its ARN or name. The application can
     * be specified by ARN, ID, or name.
     * </p>
     *
     * @param associateResourceRequest
     * @return Result of the AssociateResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ServiceQuotaExceededException
     *         The maximum number of resources per account has been reached.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.AssociateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResourceResponse associateResource(AssociateResourceRequest associateResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ConflictException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a resource with an application. The resource can be specified by its ARN or name. The application can
     * be specified by ARN, ID, or name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateResourceRequest#builder()}
     * </p>
     *
     * @param associateResourceRequest
     *        A {@link Consumer} that will call methods on {@link AssociateResourceRequest.Builder} to create a request.
     * @return Result of the AssociateResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ServiceQuotaExceededException
     *         The maximum number of resources per account has been reached.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.AssociateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateResource"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateResourceResponse associateResource(Consumer<AssociateResourceRequest.Builder> associateResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ServiceQuotaExceededException, ConflictException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return associateResource(AssociateResourceRequest.builder().applyMutation(associateResourceRequest).build());
    }

    /**
     * <p>
     * Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The maximum number of resources per account has been reached.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws ServiceQuotaExceededException, ConflictException, InternalServerException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The maximum number of resources per account has been reached.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws ServiceQuotaExceededException, ConflictException, InternalServerException, ValidationException,
            ThrottlingException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full
     * control over their cloud application's metadata in a rich machine-readable format to facilitate integration with
     * automated workflows and third-party tools.
     * </p>
     *
     * @param createAttributeGroupRequest
     * @return Result of the CreateAttributeGroup operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The maximum number of resources per account has been reached.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.CreateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAttributeGroupResponse createAttributeGroup(CreateAttributeGroupRequest createAttributeGroupRequest)
            throws ServiceQuotaExceededException, ConflictException, ValidationException, InternalServerException,
            AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new attribute group as a container for user-defined attributes. This feature enables users to have full
     * control over their cloud application's metadata in a rich machine-readable format to facilitate integration with
     * automated workflows and third-party tools.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAttributeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAttributeGroupRequest#builder()}
     * </p>
     *
     * @param createAttributeGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateAttributeGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAttributeGroup operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         The maximum number of resources per account has been reached.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.CreateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAttributeGroupResponse createAttributeGroup(
            Consumer<CreateAttributeGroupRequest.Builder> createAttributeGroupRequest) throws ServiceQuotaExceededException,
            ConflictException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return createAttributeGroup(CreateAttributeGroupRequest.builder().applyMutation(createAttributeGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an application that is specified either by its application ID, name, or ARN. All associated attribute
     * groups and resources must be disassociated from it before deleting an application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application that is specified either by its application ID, name, or ARN. All associated attribute
     * groups and resources must be disassociated from it before deleting an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationRequest.Builder} to create a request.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes an attribute group, specified either by its attribute group ID, name, or ARN.
     * </p>
     *
     * @param deleteAttributeGroupRequest
     * @return Result of the DeleteAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.DeleteAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAttributeGroupResponse deleteAttributeGroup(DeleteAttributeGroupRequest deleteAttributeGroupRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an attribute group, specified either by its attribute group ID, name, or ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAttributeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAttributeGroupRequest#builder()}
     * </p>
     *
     * @param deleteAttributeGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAttributeGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.DeleteAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAttributeGroupResponse deleteAttributeGroup(
            Consumer<DeleteAttributeGroupRequest.Builder> deleteAttributeGroupRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return deleteAttributeGroup(DeleteAttributeGroupRequest.builder().applyMutation(deleteAttributeGroupRequest).build());
    }

    /**
     * <p>
     * Disassociates an attribute group from an application to remove the extra attributes contained in the attribute
     * group from the application's metadata. This operation reverts <code>AssociateAttributeGroup</code>.
     * </p>
     *
     * @param disassociateAttributeGroupRequest
     * @return Result of the DisassociateAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.DisassociateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAttributeGroupResponse disassociateAttributeGroup(
            DisassociateAttributeGroupRequest disassociateAttributeGroupRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates an attribute group from an application to remove the extra attributes contained in the attribute
     * group from the application's metadata. This operation reverts <code>AssociateAttributeGroup</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateAttributeGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateAttributeGroupRequest#builder()}
     * </p>
     *
     * @param disassociateAttributeGroupRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateAttributeGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.DisassociateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateAttributeGroupResponse disassociateAttributeGroup(
            Consumer<DisassociateAttributeGroupRequest.Builder> disassociateAttributeGroupRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        return disassociateAttributeGroup(DisassociateAttributeGroupRequest.builder()
                .applyMutation(disassociateAttributeGroupRequest).build());
    }

    /**
     * <p>
     * Disassociates a resource from application. Both the resource and the application can be specified either by ID or
     * name.
     * </p>
     *
     * @param disassociateResourceRequest
     * @return Result of the DisassociateResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.DisassociateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResourceResponse disassociateResource(DisassociateResourceRequest disassociateResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ValidationException, ThrottlingException,
            AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a resource from application. Both the resource and the application can be specified either by ID or
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateResourceRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateResourceRequest#builder()}
     * </p>
     *
     * @param disassociateResourceRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateResourceRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.DisassociateResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateResource"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateResourceResponse disassociateResource(
            Consumer<DisassociateResourceRequest.Builder> disassociateResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return disassociateResource(DisassociateResourceRequest.builder().applyMutation(disassociateResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata information about one of your applications. The application can be specified by its ARN, ID,
     * or name (which is unique within one account in one region at a given point in time). Specify by ARN or ID in
     * automated workflows if you want to make sure that the exact same application is returned or a
     * <code>ResourceNotFoundException</code> is thrown, avoiding the ABA addressing problem.
     * </p>
     *
     * @param getApplicationRequest
     * @return Result of the GetApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationResponse getApplication(GetApplicationRequest getApplicationRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata information about one of your applications. The application can be specified by its ARN, ID,
     * or name (which is unique within one account in one region at a given point in time). Specify by ARN or ID in
     * automated workflows if you want to make sure that the exact same application is returned or a
     * <code>ResourceNotFoundException</code> is thrown, avoiding the ABA addressing problem.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     * </p>
     *
     * @param getApplicationRequest
     *        A {@link Consumer} that will call methods on {@link GetApplicationRequest.Builder} to create a request.
     * @return Result of the GetApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.GetApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default GetApplicationResponse getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return getApplication(GetApplicationRequest.builder().applyMutation(getApplicationRequest).build());
    }

    /**
     * <p>
     * Gets the resource associated with the application.
     * </p>
     *
     * @param getAssociatedResourceRequest
     * @return Result of the GetAssociatedResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.GetAssociatedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAssociatedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssociatedResourceResponse getAssociatedResource(GetAssociatedResourceRequest getAssociatedResourceRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the resource associated with the application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssociatedResourceRequest.Builder} avoiding the
     * need to create one manually via {@link GetAssociatedResourceRequest#builder()}
     * </p>
     *
     * @param getAssociatedResourceRequest
     *        A {@link Consumer} that will call methods on {@link GetAssociatedResourceRequest.Builder} to create a
     *        request.
     * @return Result of the GetAssociatedResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.GetAssociatedResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAssociatedResource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssociatedResourceResponse getAssociatedResource(
            Consumer<GetAssociatedResourceRequest.Builder> getAssociatedResourceRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return getAssociatedResource(GetAssociatedResourceRequest.builder().applyMutation(getAssociatedResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves an attribute group by its ARN, ID, or name. The attribute group can be specified by its ARN, ID, or
     * name.
     * </p>
     *
     * @param getAttributeGroupRequest
     * @return Result of the GetAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.GetAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAttributeGroupResponse getAttributeGroup(GetAttributeGroupRequest getAttributeGroupRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an attribute group by its ARN, ID, or name. The attribute group can be specified by its ARN, ID, or
     * name.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAttributeGroupRequest.Builder} avoiding the need
     * to create one manually via {@link GetAttributeGroupRequest#builder()}
     * </p>
     *
     * @param getAttributeGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetAttributeGroupRequest.Builder} to create a request.
     * @return Result of the GetAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.GetAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAttributeGroupResponse getAttributeGroup(Consumer<GetAttributeGroupRequest.Builder> getAttributeGroupRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return getAttributeGroup(GetAttributeGroupRequest.builder().applyMutation(getAttributeGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves a <code>TagKey</code> configuration from an account.
     * </p>
     *
     * @param getConfigurationRequest
     * @return Result of the GetConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationResponse getConfiguration(GetConfigurationRequest getConfigurationRequest)
            throws InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>TagKey</code> configuration from an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link GetConfigurationRequest#builder()}
     * </p>
     *
     * @param getConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetConfigurationRequest.Builder} to create a request.
     * @return Result of the GetConfiguration operation returned by the service.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.GetConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationResponse getConfiguration(Consumer<GetConfigurationRequest.Builder> getConfigurationRequest)
            throws InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return getConfiguration(GetConfigurationRequest.builder().applyMutation(getConfigurationRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of your applications. Results are paginated.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all of your applications. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return Result of the ListApplications operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all of your applications. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    /**
     * <p>
     * Retrieves a list of all of your applications. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listApplications(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsIterable responses = client
     *             .listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.servicecatalogappregistry.model.ListApplicationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     * </p>
     *
     * @param listAssociatedAttributeGroupsRequest
     * @return Result of the ListAssociatedAttributeGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAssociatedAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAttributeGroupsResponse listAssociatedAttributeGroups(
            ListAssociatedAttributeGroupsRequest listAssociatedAttributeGroupsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedAttributeGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAssociatedAttributeGroupsRequest#builder()}
     * </p>
     *
     * @param listAssociatedAttributeGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedAttributeGroupsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAssociatedAttributeGroups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAssociatedAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAttributeGroupsResponse listAssociatedAttributeGroups(
            Consumer<ListAssociatedAttributeGroupsRequest.Builder> listAssociatedAttributeGroupsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        return listAssociatedAttributeGroups(ListAssociatedAttributeGroupsRequest.builder()
                .applyMutation(listAssociatedAttributeGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsIterable responses = client.listAssociatedAttributeGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsIterable responses = client
     *             .listAssociatedAttributeGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsIterable responses = client.listAssociatedAttributeGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedAttributeGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAssociatedAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAttributeGroupsIterable listAssociatedAttributeGroupsPaginator(
            ListAssociatedAttributeGroupsRequest listAssociatedAttributeGroupsRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return new ListAssociatedAttributeGroupsIterable(this, listAssociatedAttributeGroupsRequest);
    }

    /**
     * <p>
     * Lists all attribute groups that are associated with specified application. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsIterable responses = client.listAssociatedAttributeGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsIterable responses = client
     *             .listAssociatedAttributeGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedAttributeGroupsIterable responses = client.listAssociatedAttributeGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedAttributeGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedAttributeGroupsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAssociatedAttributeGroupsRequest#builder()}
     * </p>
     *
     * @param listAssociatedAttributeGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedAttributeGroupsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAssociatedAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedAttributeGroupsIterable listAssociatedAttributeGroupsPaginator(
            Consumer<ListAssociatedAttributeGroupsRequest.Builder> listAssociatedAttributeGroupsRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        return listAssociatedAttributeGroupsPaginator(ListAssociatedAttributeGroupsRequest.builder()
                .applyMutation(listAssociatedAttributeGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     * </p>
     * <note>
     * <p>
     * If you share an application, and a consumer account associates a tag query to the application, all of the users
     * who can access the application can also view the tag values in all accounts that are associated with it using
     * this API.
     * </p>
     * </note>
     *
     * @param listAssociatedResourcesRequest
     * @return Result of the ListAssociatedResources operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAssociatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedResourcesResponse listAssociatedResources(ListAssociatedResourcesRequest listAssociatedResourcesRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     * </p>
     * <note>
     * <p>
     * If you share an application, and a consumer account associates a tag query to the application, all of the users
     * who can access the application can also view the tag values in all accounts that are associated with it using
     * this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociatedResourcesRequest#builder()}
     * </p>
     *
     * @param listAssociatedResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedResourcesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssociatedResources operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAssociatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedResourcesResponse listAssociatedResources(
            Consumer<ListAssociatedResourcesRequest.Builder> listAssociatedResourcesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return listAssociatedResources(ListAssociatedResourcesRequest.builder().applyMutation(listAssociatedResourcesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     * </p>
     * <note>
     * <p>
     * If you share an application, and a consumer account associates a tag query to the application, all of the users
     * who can access the application can also view the tag values in all accounts that are associated with it using
     * this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedResources(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesIterable responses = client.listAssociatedResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesIterable responses = client
     *             .listAssociatedResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesIterable responses = client.listAssociatedResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedResources(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociatedResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAssociatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedResourcesIterable listAssociatedResourcesPaginator(
            ListAssociatedResourcesRequest listAssociatedResourcesRequest) throws ResourceNotFoundException, ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return new ListAssociatedResourcesIterable(this, listAssociatedResourcesRequest);
    }

    /**
     * <p>
     * Lists all of the resources that are associated with the specified application. Results are paginated.
     * </p>
     * <note>
     * <p>
     * If you share an application, and a consumer account associates a tag query to the application, all of the users
     * who can access the application can also view the tag values in all accounts that are associated with it using
     * this API.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #listAssociatedResources(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesIterable responses = client.listAssociatedResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesIterable responses = client
     *             .listAssociatedResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAssociatedResourcesIterable responses = client.listAssociatedResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociatedResources(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedResourcesRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociatedResourcesRequest#builder()}
     * </p>
     *
     * @param listAssociatedResourcesRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedResourcesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAssociatedResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedResourcesIterable listAssociatedResourcesPaginator(
            Consumer<ListAssociatedResourcesRequest.Builder> listAssociatedResourcesRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return listAssociatedResourcesPaginator(ListAssociatedResourcesRequest.builder()
                .applyMutation(listAssociatedResourcesRequest).build());
    }

    /**
     * <p>
     * Lists all attribute groups which you have access to. Results are paginated.
     * </p>
     *
     * @param listAttributeGroupsRequest
     * @return Result of the ListAttributeGroups operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsResponse listAttributeGroups(ListAttributeGroupsRequest listAttributeGroupsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all attribute groups which you have access to. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributeGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttributeGroupsRequest#builder()}
     * </p>
     *
     * @param listAttributeGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListAttributeGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAttributeGroups operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsResponse listAttributeGroups(
            Consumer<ListAttributeGroupsRequest.Builder> listAttributeGroupsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return listAttributeGroups(ListAttributeGroupsRequest.builder().applyMutation(listAttributeGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all attribute groups which you have access to. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsIterable responses = client.listAttributeGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsIterable responses = client
     *             .listAttributeGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsIterable responses = client.listAttributeGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttributeGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsIterable listAttributeGroupsPaginator(ListAttributeGroupsRequest listAttributeGroupsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return new ListAttributeGroupsIterable(this, listAttributeGroupsRequest);
    }

    /**
     * <p>
     * Lists all attribute groups which you have access to. Results are paginated.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsIterable responses = client.listAttributeGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsIterable responses = client
     *             .listAttributeGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsIterable responses = client.listAttributeGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributeGroups(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributeGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttributeGroupsRequest#builder()}
     * </p>
     *
     * @param listAttributeGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListAttributeGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAttributeGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsIterable listAttributeGroupsPaginator(
            Consumer<ListAttributeGroupsRequest.Builder> listAttributeGroupsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return listAttributeGroupsPaginator(ListAttributeGroupsRequest.builder().applyMutation(listAttributeGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     * </p>
     *
     * @param listAttributeGroupsForApplicationRequest
     * @return Result of the ListAttributeGroupsForApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAttributeGroupsForApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroupsForApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsForApplicationResponse listAttributeGroupsForApplication(
            ListAttributeGroupsForApplicationRequest listAttributeGroupsForApplicationRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributeGroupsForApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link ListAttributeGroupsForApplicationRequest#builder()}
     * </p>
     *
     * @param listAttributeGroupsForApplicationRequest
     *        A {@link Consumer} that will call methods on {@link ListAttributeGroupsForApplicationRequest.Builder} to
     *        create a request.
     * @return Result of the ListAttributeGroupsForApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAttributeGroupsForApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroupsForApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsForApplicationResponse listAttributeGroupsForApplication(
            Consumer<ListAttributeGroupsForApplicationRequest.Builder> listAttributeGroupsForApplicationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        return listAttributeGroupsForApplication(ListAttributeGroupsForApplicationRequest.builder()
                .applyMutation(listAttributeGroupsForApplicationRequest).build());
    }

    /**
     * <p>
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttributeGroupsForApplication(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationIterable responses = client.listAttributeGroupsForApplicationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationIterable responses = client
     *             .listAttributeGroupsForApplicationPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationIterable responses = client.listAttributeGroupsForApplicationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributeGroupsForApplication(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttributeGroupsForApplicationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAttributeGroupsForApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroupsForApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsForApplicationIterable listAttributeGroupsForApplicationPaginator(
            ListAttributeGroupsForApplicationRequest listAttributeGroupsForApplicationRequest) throws ResourceNotFoundException,
            ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return new ListAttributeGroupsForApplicationIterable(this, listAttributeGroupsForApplicationRequest);
    }

    /**
     * <p>
     * Lists the details of all attribute groups associated with a specific application. The results display in pages.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttributeGroupsForApplication(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationIterable responses = client.listAttributeGroupsForApplicationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationIterable responses = client
     *             .listAttributeGroupsForApplicationPaginator(request);
     *     for (software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicecatalogappregistry.paginators.ListAttributeGroupsForApplicationIterable responses = client.listAttributeGroupsForApplicationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttributeGroupsForApplication(software.amazon.awssdk.services.servicecatalogappregistry.model.ListAttributeGroupsForApplicationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttributeGroupsForApplicationRequest.Builder}
     * avoiding the need to create one manually via {@link ListAttributeGroupsForApplicationRequest#builder()}
     * </p>
     *
     * @param listAttributeGroupsForApplicationRequest
     *        A {@link Consumer} that will call methods on {@link ListAttributeGroupsForApplicationRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListAttributeGroupsForApplication
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroupsForApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAttributeGroupsForApplicationIterable listAttributeGroupsForApplicationPaginator(
            Consumer<ListAttributeGroupsForApplicationRequest.Builder> listAttributeGroupsForApplicationRequest)
            throws ResourceNotFoundException, ValidationException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        return listAttributeGroupsForApplicationPaginator(ListAttributeGroupsForApplicationRequest.builder()
                .applyMutation(listAttributeGroupsForApplicationRequest).build());
    }

    /**
     * <p>
     * Lists all of the tags on the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the tags on the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     *
     * @param putConfigurationRequest
     * @return Result of the PutConfiguration operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.PutConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/PutConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationResponse putConfiguration(PutConfigurationRequest putConfigurationRequest) throws ConflictException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a <code>TagKey</code> configuration to an account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutConfigurationRequest.Builder} avoiding the need
     * to create one manually via {@link PutConfigurationRequest#builder()}
     * </p>
     *
     * @param putConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutConfigurationRequest.Builder} to create a request.
     * @return Result of the PutConfiguration operation returned by the service.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.PutConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/PutConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutConfigurationResponse putConfiguration(Consumer<PutConfigurationRequest.Builder> putConfigurationRequest)
            throws ConflictException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return putConfiguration(PutConfigurationRequest.builder().applyMutation(putConfigurationRequest).build());
    }

    /**
     * <p>
     * Syncs the resource with current AppRegistry records.
     * </p>
     * <p>
     * Specifically, the resource’s AppRegistry system tags sync with its associated application. We remove the
     * resource's AppRegistry system tags if it does not associate with the application. The caller must have
     * permissions to read and update the resource.
     * </p>
     *
     * @param syncResourceRequest
     * @return Result of the SyncResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.SyncResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/SyncResource"
     *      target="_top">AWS API Documentation</a>
     */
    default SyncResourceResponse syncResource(SyncResourceRequest syncResourceRequest) throws ResourceNotFoundException,
            InternalServerException, ConflictException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Syncs the resource with current AppRegistry records.
     * </p>
     * <p>
     * Specifically, the resource’s AppRegistry system tags sync with its associated application. We remove the
     * resource's AppRegistry system tags if it does not associate with the application. The caller must have
     * permissions to read and update the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SyncResourceRequest.Builder} avoiding the need to
     * create one manually via {@link SyncResourceRequest#builder()}
     * </p>
     *
     * @param syncResourceRequest
     *        A {@link Consumer} that will call methods on {@link SyncResourceRequest.Builder} to create a request.
     * @return Result of the SyncResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.SyncResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/SyncResource"
     *      target="_top">AWS API Documentation</a>
     */
    default SyncResourceResponse syncResource(Consumer<SyncResourceRequest.Builder> syncResourceRequest)
            throws ResourceNotFoundException, InternalServerException, ConflictException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return syncResource(SyncResourceRequest.builder().applyMutation(syncResourceRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the
     * resource, this action updates its value.
     * </p>
     * <p>
     * This operation returns an empty response if the call was successful.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the
     * resource, this action updates its value.
     * </p>
     * <p>
     * This operation returns an empty response if the call was successful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <p>
     * This operation returns an empty response if the call was successful.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <p>
     * This operation returns an empty response if the call was successful.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, ServiceCatalogAppRegistryException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing application with new attributes.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing application with new attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws ThrottlingException
     *         The maximum number of API requests has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates an existing attribute group with new details.
     * </p>
     *
     * @param updateAttributeGroupRequest
     * @return Result of the UpdateAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.UpdateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAttributeGroupResponse updateAttributeGroup(UpdateAttributeGroupRequest updateAttributeGroupRequest)
            throws ResourceNotFoundException, ValidationException, ConflictException, InternalServerException,
            AwsServiceException, SdkClientException, ServiceCatalogAppRegistryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing attribute group with new details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAttributeGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAttributeGroupRequest#builder()}
     * </p>
     *
     * @param updateAttributeGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateAttributeGroupRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateAttributeGroup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ValidationException
     *         The request has invalid or missing parameters.
     * @throws ConflictException
     *         There was a conflict when processing the request (for example, a resource with the given name already
     *         exists within the account).
     * @throws InternalServerException
     *         The service is experiencing internal problems.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceCatalogAppRegistryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceCatalogAppRegistryClient.UpdateAttributeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateAttributeGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAttributeGroupResponse updateAttributeGroup(
            Consumer<UpdateAttributeGroupRequest.Builder> updateAttributeGroupRequest) throws ResourceNotFoundException,
            ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            ServiceCatalogAppRegistryException {
        return updateAttributeGroup(UpdateAttributeGroupRequest.builder().applyMutation(updateAttributeGroupRequest).build());
    }

    /**
     * Create a {@link ServiceCatalogAppRegistryClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServiceCatalogAppRegistryClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceCatalogAppRegistryClient}.
     */
    static ServiceCatalogAppRegistryClientBuilder builder() {
        return new DefaultServiceCatalogAppRegistryClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ServiceCatalogAppRegistryServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
