/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListServiceActionsResponse;

public class ListServiceActionsIterable
implements SdkIterable<ListServiceActionsResponse> {
    private final ServiceCatalogClient client;
    private final ListServiceActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceActionsIterable(ServiceCatalogClient client, ListServiceActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceActionsResponseFetcher();
    }

    public Iterator<ListServiceActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListServiceActionsResponseFetcher
    implements SyncPageFetcher<ListServiceActionsResponse> {
        private ListServiceActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListServiceActionsResponse nextPage(ListServiceActionsResponse previousPage) {
            if (previousPage == null) {
                return ListServiceActionsIterable.this.client.listServiceActions(ListServiceActionsIterable.this.firstRequest);
            }
            return ListServiceActionsIterable.this.client.listServiceActions((ListServiceActionsRequest)((Object)ListServiceActionsIterable.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

