/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecordStatus {
    CREATED("CREATED"),
    IN_PROGRESS("IN_PROGRESS"),
    IN_PROGRESS_IN_ERROR("IN_PROGRESS_IN_ERROR"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecordStatus> VALUE_MAP;
    private final String value;

    private RecordStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecordStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecordStatus> knownValues() {
        EnumSet<RecordStatus> knownValues = EnumSet.allOf(RecordStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecordStatus.class, RecordStatus::toString);
    }
}

