/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociatePrincipalWithPortfolioRequest extends ServiceCatalogRequest implements
        ToCopyableBuilder<AssociatePrincipalWithPortfolioRequest.Builder, AssociatePrincipalWithPortfolioRequest> {
    private static final SdkField<String> ACCEPT_LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AcceptLanguage").getter(getter(AssociatePrincipalWithPortfolioRequest::acceptLanguage))
            .setter(setter(Builder::acceptLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceptLanguage").build()).build();

    private static final SdkField<String> PORTFOLIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PortfolioId").getter(getter(AssociatePrincipalWithPortfolioRequest::portfolioId))
            .setter(setter(Builder::portfolioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PortfolioId").build()).build();

    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalARN").getter(getter(AssociatePrincipalWithPortfolioRequest::principalARN))
            .setter(setter(Builder::principalARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalARN").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalType").getter(getter(AssociatePrincipalWithPortfolioRequest::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPT_LANGUAGE_FIELD,
            PORTFOLIO_ID_FIELD, PRINCIPAL_ARN_FIELD, PRINCIPAL_TYPE_FIELD));

    private final String acceptLanguage;

    private final String portfolioId;

    private final String principalARN;

    private final String principalType;

    private AssociatePrincipalWithPortfolioRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.principalARN = builder.principalARN;
        this.principalType = builder.principalType;
    }

    /**
     * <p>
     * The language code.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>jp</code> - Japanese
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh</code> - Chinese
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language code.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>jp</code> - Japanese
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh</code> - Chinese
     *         </p>
     *         </li>
     */
    public final String acceptLanguage() {
        return acceptLanguage;
    }

    /**
     * <p>
     * The portfolio identifier.
     * </p>
     * 
     * @return The portfolio identifier.
     */
    public final String portfolioId() {
        return portfolioId;
    }

    /**
     * <p>
     * The ARN of the principal (user, role, or group). If the <code>PrincipalType</code> is <code>IAM</code>, the
     * supported value is a fully defined <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM Amazon
     * Resource Name (ARN)</a>. If the <code>PrincipalType</code> is <code>IAM_PATTERN</code>, the supported value is an
     * <code>IAM</code> ARN <i>without an AccountID</i> in the following format:
     * </p>
     * <p>
     * <i>arn:partition:iam:::resource-type/resource-id</i>
     * </p>
     * <p>
     * The ARN resource-id can be either:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A fully formed resource-id. For example, <i>arn:aws:iam:::role/resource-name</i> or
     * <i>arn:aws:iam:::role/resource-path/resource-name</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * A wildcard ARN. The wildcard ARN accepts <code>IAM_PATTERN</code> values with a "*" or "?" in the resource-id
     * segment of the ARN. For example <i>arn:partition:service:::resource-type/resource-path/resource-name</i>. The new
     * symbols are exclusive to the <b>resource-path</b> and <b>resource-name</b> and cannot replace the
     * <b>resource-type</b> or other ARN values.
     * </p>
     * <p>
     * The ARN path and principal name allow unlimited wildcard characters.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Examples of an <b>acceptable</b> wildcard ARN:
     * </p>
     * <ul>
     * <li>
     * <p>
     * arn:aws:iam:::role/ResourceName_*
     * </p>
     * </li>
     * <li>
     * <p>
     * arn:aws:iam:::role/*&#47;ResourceName_?
     * </p>
     * </li>
     * </ul>
     * <p>
     * Examples of an <b>unacceptable</b> wildcard ARN:
     * </p>
     * <ul>
     * <li>
     * <p>
     * arn:aws:iam:::*&#47;ResourceName
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can associate multiple <code>IAM_PATTERN</code>s even if the account has no principal with that name.
     * </p>
     * <p>
     * The "?" wildcard character matches zero or one of any character. This is similar to ".?" in regular regex
     * context. The "*" wildcard character matches any number of any characters. This is similar to ".*" in regular
     * regex context.
     * </p>
     * <p>
     * In the IAM Principal ARN format (<i>arn:partition:iam:::resource-type/resource-path/resource-name</i>), valid
     * resource-type values include <b>user/</b>, <b>group/</b>, or <b>role/</b>. The "?" and "*" characters are allowed
     * only after the resource-type in the resource-id segment. You can use special characters anywhere within the
     * resource-id.
     * </p>
     * <p>
     * The "*" character also matches the "/" character, allowing paths to be formed <i>within</i> the resource-id. For
     * example, <i>arn:aws:iam:::role/<b>*</b>/ResourceName_?</i> matches both
     * <i>arn:aws:iam:::role/pathA/pathB/ResourceName_1</i> and <i>arn:aws:iam:::role/pathA/ResourceName_1</i>.
     * </p>
     * 
     * @return The ARN of the principal (user, role, or group). If the <code>PrincipalType</code> is <code>IAM</code>,
     *         the supported value is a fully defined <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
     *         Amazon Resource Name (ARN)</a>. If the <code>PrincipalType</code> is <code>IAM_PATTERN</code>, the
     *         supported value is an <code>IAM</code> ARN <i>without an AccountID</i> in the following format:</p>
     *         <p>
     *         <i>arn:partition:iam:::resource-type/resource-id</i>
     *         </p>
     *         <p>
     *         The ARN resource-id can be either:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         A fully formed resource-id. For example, <i>arn:aws:iam:::role/resource-name</i> or
     *         <i>arn:aws:iam:::role/resource-path/resource-name</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A wildcard ARN. The wildcard ARN accepts <code>IAM_PATTERN</code> values with a "*" or "?" in the
     *         resource-id segment of the ARN. For example
     *         <i>arn:partition:service:::resource-type/resource-path/resource-name</i>. The new symbols are exclusive
     *         to the <b>resource-path</b> and <b>resource-name</b> and cannot replace the <b>resource-type</b> or other
     *         ARN values.
     *         </p>
     *         <p>
     *         The ARN path and principal name allow unlimited wildcard characters.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Examples of an <b>acceptable</b> wildcard ARN:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         arn:aws:iam:::role/ResourceName_*
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         arn:aws:iam:::role/*&#47;ResourceName_?
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Examples of an <b>unacceptable</b> wildcard ARN:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         arn:aws:iam:::*&#47;ResourceName
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You can associate multiple <code>IAM_PATTERN</code>s even if the account has no principal with that name.
     *         </p>
     *         <p>
     *         The "?" wildcard character matches zero or one of any character. This is similar to ".?" in regular regex
     *         context. The "*" wildcard character matches any number of any characters. This is similar to ".*" in
     *         regular regex context.
     *         </p>
     *         <p>
     *         In the IAM Principal ARN format (<i>arn:partition:iam:::resource-type/resource-path/resource-name</i>),
     *         valid resource-type values include <b>user/</b>, <b>group/</b>, or <b>role/</b>. The "?" and "*"
     *         characters are allowed only after the resource-type in the resource-id segment. You can use special
     *         characters anywhere within the resource-id.
     *         </p>
     *         <p>
     *         The "*" character also matches the "/" character, allowing paths to be formed <i>within</i> the
     *         resource-id. For example, <i>arn:aws:iam:::role/<b>*</b>/ResourceName_?</i> matches both
     *         <i>arn:aws:iam:::role/pathA/pathB/ResourceName_1</i> and <i>arn:aws:iam:::role/pathA/ResourceName_1</i>.
     */
    public final String principalARN() {
        return principalARN;
    }

    /**
     * <p>
     * The principal type. The supported value is <code>IAM</code> if you use a fully defined Amazon Resource Name
     * (ARN), or <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
     * characters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The principal type. The supported value is <code>IAM</code> if you use a fully defined Amazon Resource
     *         Name (ARN), or <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without
     *         wildcard characters.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * The principal type. The supported value is <code>IAM</code> if you use a fully defined Amazon Resource Name
     * (ARN), or <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
     * characters.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The principal type. The supported value is <code>IAM</code> if you use a fully defined Amazon Resource
     *         Name (ARN), or <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without
     *         wildcard characters.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(principalARN());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatePrincipalWithPortfolioRequest)) {
            return false;
        }
        AssociatePrincipalWithPortfolioRequest other = (AssociatePrincipalWithPortfolioRequest) obj;
        return Objects.equals(acceptLanguage(), other.acceptLanguage()) && Objects.equals(portfolioId(), other.portfolioId())
                && Objects.equals(principalARN(), other.principalARN())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociatePrincipalWithPortfolioRequest").add("AcceptLanguage", acceptLanguage())
                .add("PortfolioId", portfolioId()).add("PrincipalARN", principalARN())
                .add("PrincipalType", principalTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceptLanguage":
            return Optional.ofNullable(clazz.cast(acceptLanguage()));
        case "PortfolioId":
            return Optional.ofNullable(clazz.cast(portfolioId()));
        case "PrincipalARN":
            return Optional.ofNullable(clazz.cast(principalARN()));
        case "PrincipalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatePrincipalWithPortfolioRequest, T> g) {
        return obj -> g.apply((AssociatePrincipalWithPortfolioRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceCatalogRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociatePrincipalWithPortfolioRequest> {
        /**
         * <p>
         * The language code.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>jp</code> - Japanese
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh</code> - Chinese
         * </p>
         * </li>
         * </ul>
         * 
         * @param acceptLanguage
         *        The language code.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>jp</code> - Japanese
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh</code> - Chinese
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceptLanguage(String acceptLanguage);

        /**
         * <p>
         * The portfolio identifier.
         * </p>
         * 
         * @param portfolioId
         *        The portfolio identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portfolioId(String portfolioId);

        /**
         * <p>
         * The ARN of the principal (user, role, or group). If the <code>PrincipalType</code> is <code>IAM</code>, the
         * supported value is a fully defined <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM
         * Amazon Resource Name (ARN)</a>. If the <code>PrincipalType</code> is <code>IAM_PATTERN</code>, the supported
         * value is an <code>IAM</code> ARN <i>without an AccountID</i> in the following format:
         * </p>
         * <p>
         * <i>arn:partition:iam:::resource-type/resource-id</i>
         * </p>
         * <p>
         * The ARN resource-id can be either:
         * </p>
         * <ul>
         * <li>
         * <p>
         * A fully formed resource-id. For example, <i>arn:aws:iam:::role/resource-name</i> or
         * <i>arn:aws:iam:::role/resource-path/resource-name</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * A wildcard ARN. The wildcard ARN accepts <code>IAM_PATTERN</code> values with a "*" or "?" in the resource-id
         * segment of the ARN. For example <i>arn:partition:service:::resource-type/resource-path/resource-name</i>. The
         * new symbols are exclusive to the <b>resource-path</b> and <b>resource-name</b> and cannot replace the
         * <b>resource-type</b> or other ARN values.
         * </p>
         * <p>
         * The ARN path and principal name allow unlimited wildcard characters.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Examples of an <b>acceptable</b> wildcard ARN:
         * </p>
         * <ul>
         * <li>
         * <p>
         * arn:aws:iam:::role/ResourceName_*
         * </p>
         * </li>
         * <li>
         * <p>
         * arn:aws:iam:::role/*&#47;ResourceName_?
         * </p>
         * </li>
         * </ul>
         * <p>
         * Examples of an <b>unacceptable</b> wildcard ARN:
         * </p>
         * <ul>
         * <li>
         * <p>
         * arn:aws:iam:::*&#47;ResourceName
         * </p>
         * </li>
         * </ul>
         * <p>
         * You can associate multiple <code>IAM_PATTERN</code>s even if the account has no principal with that name.
         * </p>
         * <p>
         * The "?" wildcard character matches zero or one of any character. This is similar to ".?" in regular regex
         * context. The "*" wildcard character matches any number of any characters. This is similar to ".*" in regular
         * regex context.
         * </p>
         * <p>
         * In the IAM Principal ARN format (<i>arn:partition:iam:::resource-type/resource-path/resource-name</i>), valid
         * resource-type values include <b>user/</b>, <b>group/</b>, or <b>role/</b>. The "?" and "*" characters are
         * allowed only after the resource-type in the resource-id segment. You can use special characters anywhere
         * within the resource-id.
         * </p>
         * <p>
         * The "*" character also matches the "/" character, allowing paths to be formed <i>within</i> the resource-id.
         * For example, <i>arn:aws:iam:::role/<b>*</b>/ResourceName_?</i> matches both
         * <i>arn:aws:iam:::role/pathA/pathB/ResourceName_1</i> and <i>arn:aws:iam:::role/pathA/ResourceName_1</i>.
         * </p>
         * 
         * @param principalARN
         *        The ARN of the principal (user, role, or group). If the <code>PrincipalType</code> is <code>IAM</code>
         *        , the supported value is a fully defined <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns"
         *        >IAM Amazon Resource Name (ARN)</a>. If the <code>PrincipalType</code> is <code>IAM_PATTERN</code>,
         *        the supported value is an <code>IAM</code> ARN <i>without an AccountID</i> in the following
         *        format:</p>
         *        <p>
         *        <i>arn:partition:iam:::resource-type/resource-id</i>
         *        </p>
         *        <p>
         *        The ARN resource-id can be either:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        A fully formed resource-id. For example, <i>arn:aws:iam:::role/resource-name</i> or
         *        <i>arn:aws:iam:::role/resource-path/resource-name</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A wildcard ARN. The wildcard ARN accepts <code>IAM_PATTERN</code> values with a "*" or "?" in the
         *        resource-id segment of the ARN. For example
         *        <i>arn:partition:service:::resource-type/resource-path/resource-name</i>. The new symbols are
         *        exclusive to the <b>resource-path</b> and <b>resource-name</b> and cannot replace the
         *        <b>resource-type</b> or other ARN values.
         *        </p>
         *        <p>
         *        The ARN path and principal name allow unlimited wildcard characters.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Examples of an <b>acceptable</b> wildcard ARN:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        arn:aws:iam:::role/ResourceName_*
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        arn:aws:iam:::role/*&#47;ResourceName_?
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Examples of an <b>unacceptable</b> wildcard ARN:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        arn:aws:iam:::*&#47;ResourceName
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You can associate multiple <code>IAM_PATTERN</code>s even if the account has no principal with that
         *        name.
         *        </p>
         *        <p>
         *        The "?" wildcard character matches zero or one of any character. This is similar to ".?" in regular
         *        regex context. The "*" wildcard character matches any number of any characters. This is similar to
         *        ".*" in regular regex context.
         *        </p>
         *        <p>
         *        In the IAM Principal ARN format
         *        (<i>arn:partition:iam:::resource-type/resource-path/resource-name</i>), valid resource-type values
         *        include <b>user/</b>, <b>group/</b>, or <b>role/</b>. The "?" and "*" characters are allowed only
         *        after the resource-type in the resource-id segment. You can use special characters anywhere within the
         *        resource-id.
         *        </p>
         *        <p>
         *        The "*" character also matches the "/" character, allowing paths to be formed <i>within</i> the
         *        resource-id. For example, <i>arn:aws:iam:::role/<b>*</b>/ResourceName_?</i> matches both
         *        <i>arn:aws:iam:::role/pathA/pathB/ResourceName_1</i> and
         *        <i>arn:aws:iam:::role/pathA/ResourceName_1</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalARN(String principalARN);

        /**
         * <p>
         * The principal type. The supported value is <code>IAM</code> if you use a fully defined Amazon Resource Name
         * (ARN), or <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
         * characters.
         * </p>
         * 
         * @param principalType
         *        The principal type. The supported value is <code>IAM</code> if you use a fully defined Amazon Resource
         *        Name (ARN), or <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or
         *        without wildcard characters.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The principal type. The supported value is <code>IAM</code> if you use a fully defined Amazon Resource Name
         * (ARN), or <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or without wildcard
         * characters.
         * </p>
         * 
         * @param principalType
         *        The principal type. The supported value is <code>IAM</code> if you use a fully defined Amazon Resource
         *        Name (ARN), or <code>IAM_PATTERN</code> if you use an ARN with no <code>accountID</code>, with or
         *        without wildcard characters.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServiceCatalogRequest.BuilderImpl implements Builder {
        private String acceptLanguage;

        private String portfolioId;

        private String principalARN;

        private String principalType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatePrincipalWithPortfolioRequest model) {
            super(model);
            acceptLanguage(model.acceptLanguage);
            portfolioId(model.portfolioId);
            principalARN(model.principalARN);
            principalType(model.principalType);
        }

        public final String getAcceptLanguage() {
            return acceptLanguage;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final String getPortfolioId() {
            return portfolioId;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final String getPrincipalARN() {
            return principalARN;
        }

        public final void setPrincipalARN(String principalARN) {
            this.principalARN = principalARN;
        }

        @Override
        public final Builder principalARN(String principalARN) {
            this.principalARN = principalARN;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociatePrincipalWithPortfolioRequest build() {
            return new AssociatePrincipalWithPortfolioRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
