/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatalakeResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<GetDatalakeResponse.Builder, GetDatalakeResponse> {
    private static final SdkField<Map<String, LakeConfigurationResponse>> CONFIGURATIONS_FIELD = SdkField
            .<Map<String, LakeConfigurationResponse>> builder(MarshallingType.MAP)
            .memberName("configurations")
            .getter(getter(GetDatalakeResponse::configurationsAsStrings))
            .setter(setter(Builder::configurationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurations").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<LakeConfigurationResponse> builder(MarshallingType.SDK_POJO)
                                            .constructor(LakeConfigurationResponse::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATIONS_FIELD));

    private final Map<String, LakeConfigurationResponse> configurations;

    private GetDatalakeResponse(BuilderImpl builder) {
        super(builder);
        this.configurations = builder.configurations;
    }

    /**
     * <p>
     * Retrieves the Security Lake configuration object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return Retrieves the Security Lake configuration object.
     */
    public final Map<Region, LakeConfigurationResponse> configurations() {
        return LakeConfigurationResponseMapCopier.copyStringToEnum(configurations);
    }

    /**
     * For responses, this returns true if the service returned a value for the Configurations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurations() {
        return configurations != null && !(configurations instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Retrieves the Security Lake configuration object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurations} method.
     * </p>
     * 
     * @return Retrieves the Security Lake configuration object.
     */
    public final Map<String, LakeConfigurationResponse> configurationsAsStrings() {
        return configurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurations() ? configurationsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatalakeResponse)) {
            return false;
        }
        GetDatalakeResponse other = (GetDatalakeResponse) obj;
        return hasConfigurations() == other.hasConfigurations()
                && Objects.equals(configurationsAsStrings(), other.configurationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatalakeResponse")
                .add("Configurations", hasConfigurations() ? configurationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "configurations":
            return Optional.ofNullable(clazz.cast(configurationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatalakeResponse, T> g) {
        return obj -> g.apply((GetDatalakeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDatalakeResponse> {
        /**
         * <p>
         * Retrieves the Security Lake configuration object.
         * </p>
         * 
         * @param configurations
         *        Retrieves the Security Lake configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationsWithStrings(Map<String, LakeConfigurationResponse> configurations);

        /**
         * <p>
         * Retrieves the Security Lake configuration object.
         * </p>
         * 
         * @param configurations
         *        Retrieves the Security Lake configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurations(Map<Region, LakeConfigurationResponse> configurations);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private Map<String, LakeConfigurationResponse> configurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatalakeResponse model) {
            super(model);
            configurationsWithStrings(model.configurations);
        }

        public final Map<String, LakeConfigurationResponse.Builder> getConfigurations() {
            Map<String, LakeConfigurationResponse.Builder> result = LakeConfigurationResponseMapCopier
                    .copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Map<String, LakeConfigurationResponse.BuilderImpl> configurations) {
            this.configurations = LakeConfigurationResponseMapCopier.copyFromBuilder(configurations);
        }

        @Override
        public final Builder configurationsWithStrings(Map<String, LakeConfigurationResponse> configurations) {
            this.configurations = LakeConfigurationResponseMapCopier.copy(configurations);
            return this;
        }

        @Override
        public final Builder configurations(Map<Region, LakeConfigurationResponse> configurations) {
            this.configurations = LakeConfigurationResponseMapCopier.copyEnumToString(configurations);
            return this;
        }

        @Override
        public GetDatalakeResponse build() {
            return new GetDatalakeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
