/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDatalakeAutoEnableResponse extends SecurityLakeResponse implements
        ToCopyableBuilder<GetDatalakeAutoEnableResponse.Builder, GetDatalakeAutoEnableResponse> {
    private static final SdkField<List<AutoEnableNewRegionConfiguration>> AUTO_ENABLE_NEW_ACCOUNTS_FIELD = SdkField
            .<List<AutoEnableNewRegionConfiguration>> builder(MarshallingType.LIST)
            .memberName("autoEnableNewAccounts")
            .getter(getter(GetDatalakeAutoEnableResponse::autoEnableNewAccounts))
            .setter(setter(Builder::autoEnableNewAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnableNewAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AutoEnableNewRegionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AutoEnableNewRegionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUTO_ENABLE_NEW_ACCOUNTS_FIELD));

    private final List<AutoEnableNewRegionConfiguration> autoEnableNewAccounts;

    private GetDatalakeAutoEnableResponse(BuilderImpl builder) {
        super(builder);
        this.autoEnableNewAccounts = builder.autoEnableNewAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AutoEnableNewAccounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAutoEnableNewAccounts() {
        return autoEnableNewAccounts != null && !(autoEnableNewAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configuration for new accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAutoEnableNewAccounts} method.
     * </p>
     * 
     * @return The configuration for new accounts.
     */
    public final List<AutoEnableNewRegionConfiguration> autoEnableNewAccounts() {
        return autoEnableNewAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAutoEnableNewAccounts() ? autoEnableNewAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDatalakeAutoEnableResponse)) {
            return false;
        }
        GetDatalakeAutoEnableResponse other = (GetDatalakeAutoEnableResponse) obj;
        return hasAutoEnableNewAccounts() == other.hasAutoEnableNewAccounts()
                && Objects.equals(autoEnableNewAccounts(), other.autoEnableNewAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDatalakeAutoEnableResponse")
                .add("AutoEnableNewAccounts", hasAutoEnableNewAccounts() ? autoEnableNewAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "autoEnableNewAccounts":
            return Optional.ofNullable(clazz.cast(autoEnableNewAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDatalakeAutoEnableResponse, T> g) {
        return obj -> g.apply((GetDatalakeAutoEnableResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetDatalakeAutoEnableResponse> {
        /**
         * <p>
         * The configuration for new accounts.
         * </p>
         * 
         * @param autoEnableNewAccounts
         *        The configuration for new accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableNewAccounts(Collection<AutoEnableNewRegionConfiguration> autoEnableNewAccounts);

        /**
         * <p>
         * The configuration for new accounts.
         * </p>
         * 
         * @param autoEnableNewAccounts
         *        The configuration for new accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoEnableNewAccounts(AutoEnableNewRegionConfiguration... autoEnableNewAccounts);

        /**
         * <p>
         * The configuration for new accounts.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #autoEnableNewAccounts(List<AutoEnableNewRegionConfiguration>)}.
         * 
         * @param autoEnableNewAccounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.AutoEnableNewRegionConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoEnableNewAccounts(java.util.Collection<AutoEnableNewRegionConfiguration>)
         */
        Builder autoEnableNewAccounts(Consumer<AutoEnableNewRegionConfiguration.Builder>... autoEnableNewAccounts);
    }

    static final class BuilderImpl extends SecurityLakeResponse.BuilderImpl implements Builder {
        private List<AutoEnableNewRegionConfiguration> autoEnableNewAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDatalakeAutoEnableResponse model) {
            super(model);
            autoEnableNewAccounts(model.autoEnableNewAccounts);
        }

        public final List<AutoEnableNewRegionConfiguration.Builder> getAutoEnableNewAccounts() {
            List<AutoEnableNewRegionConfiguration.Builder> result = AutoEnableNewRegionConfigurationListCopier
                    .copyToBuilder(this.autoEnableNewAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAutoEnableNewAccounts(Collection<AutoEnableNewRegionConfiguration.BuilderImpl> autoEnableNewAccounts) {
            this.autoEnableNewAccounts = AutoEnableNewRegionConfigurationListCopier.copyFromBuilder(autoEnableNewAccounts);
        }

        @Override
        public final Builder autoEnableNewAccounts(Collection<AutoEnableNewRegionConfiguration> autoEnableNewAccounts) {
            this.autoEnableNewAccounts = AutoEnableNewRegionConfigurationListCopier.copy(autoEnableNewAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoEnableNewAccounts(AutoEnableNewRegionConfiguration... autoEnableNewAccounts) {
            autoEnableNewAccounts(Arrays.asList(autoEnableNewAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoEnableNewAccounts(Consumer<AutoEnableNewRegionConfiguration.Builder>... autoEnableNewAccounts) {
            autoEnableNewAccounts(Stream.of(autoEnableNewAccounts)
                    .map(c -> AutoEnableNewRegionConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetDatalakeAutoEnableResponse build() {
            return new GetDatalakeAutoEnableResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
