/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List of all failures.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Failures implements SdkPojo, Serializable, ToCopyableBuilder<Failures.Builder, Failures> {
    private static final SdkField<String> EXCEPTION_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exceptionMessage").getter(getter(Failures::exceptionMessage)).setter(setter(Builder::exceptionMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exceptionMessage").build()).build();

    private static final SdkField<String> REMEDIATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("remediation").getter(getter(Failures::remediation)).setter(setter(Builder::remediation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remediation").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp")
            .getter(getter(Failures::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXCEPTION_MESSAGE_FIELD,
            REMEDIATION_FIELD, TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exceptionMessage;

    private final String remediation;

    private final Instant timestamp;

    private Failures(BuilderImpl builder) {
        this.exceptionMessage = builder.exceptionMessage;
        this.remediation = builder.remediation;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * List of all exception messages.
     * </p>
     * 
     * @return List of all exception messages.
     */
    public final String exceptionMessage() {
        return exceptionMessage;
    }

    /**
     * <p>
     * List of all remediation steps for failures.
     * </p>
     * 
     * @return List of all remediation steps for failures.
     */
    public final String remediation() {
        return remediation;
    }

    /**
     * <p>
     * This error can occur if you configure the wrong timestamp format, or if the subset of entries used for validation
     * had errors or missing values.
     * </p>
     * 
     * @return This error can occur if you configure the wrong timestamp format, or if the subset of entries used for
     *         validation had errors or missing values.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exceptionMessage());
        hashCode = 31 * hashCode + Objects.hashCode(remediation());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Failures)) {
            return false;
        }
        Failures other = (Failures) obj;
        return Objects.equals(exceptionMessage(), other.exceptionMessage()) && Objects.equals(remediation(), other.remediation())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Failures").add("ExceptionMessage", exceptionMessage()).add("Remediation", remediation())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exceptionMessage":
            return Optional.ofNullable(clazz.cast(exceptionMessage()));
        case "remediation":
            return Optional.ofNullable(clazz.cast(remediation()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Failures, T> g) {
        return obj -> g.apply((Failures) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Failures> {
        /**
         * <p>
         * List of all exception messages.
         * </p>
         * 
         * @param exceptionMessage
         *        List of all exception messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exceptionMessage(String exceptionMessage);

        /**
         * <p>
         * List of all remediation steps for failures.
         * </p>
         * 
         * @param remediation
         *        List of all remediation steps for failures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediation(String remediation);

        /**
         * <p>
         * This error can occur if you configure the wrong timestamp format, or if the subset of entries used for
         * validation had errors or missing values.
         * </p>
         * 
         * @param timestamp
         *        This error can occur if you configure the wrong timestamp format, or if the subset of entries used for
         *        validation had errors or missing values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    static final class BuilderImpl implements Builder {
        private String exceptionMessage;

        private String remediation;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Failures model) {
            exceptionMessage(model.exceptionMessage);
            remediation(model.remediation);
            timestamp(model.timestamp);
        }

        public final String getExceptionMessage() {
            return exceptionMessage;
        }

        public final void setExceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
        }

        @Override
        public final Builder exceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
            return this;
        }

        public final String getRemediation() {
            return remediation;
        }

        public final void setRemediation(String remediation) {
            this.remediation = remediation;
        }

        @Override
        public final Builder remediation(String remediation) {
            this.remediation = remediation;
            return this;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Failures build() {
            return new Failures(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
