/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSubscriberRequest extends SecurityLakeRequest implements
        ToCopyableBuilder<CreateSubscriberRequest.Builder, CreateSubscriberRequest> {
    private static final SdkField<List<String>> ACCESS_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accessTypes")
            .getter(getter(CreateSubscriberRequest::accessTypesAsStrings))
            .setter(setter(Builder::accessTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(CreateSubscriberRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(CreateSubscriberRequest::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<List<SourceType>> SOURCE_TYPES_FIELD = SdkField
            .<List<SourceType>> builder(MarshallingType.LIST)
            .memberName("sourceTypes")
            .getter(getter(CreateSubscriberRequest::sourceTypes))
            .setter(setter(Builder::sourceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceType> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SUBSCRIBER_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriberDescription").getter(getter(CreateSubscriberRequest::subscriberDescription))
            .setter(setter(Builder::subscriberDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberDescription").build())
            .build();

    private static final SdkField<String> SUBSCRIBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subscriberName").getter(getter(CreateSubscriberRequest::subscriberName))
            .setter(setter(Builder::subscriberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriberName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPES_FIELD,
            ACCOUNT_ID_FIELD, EXTERNAL_ID_FIELD, SOURCE_TYPES_FIELD, SUBSCRIBER_DESCRIPTION_FIELD, SUBSCRIBER_NAME_FIELD));

    private final List<String> accessTypes;

    private final String accountId;

    private final String externalId;

    private final List<SourceType> sourceTypes;

    private final String subscriberDescription;

    private final String subscriberName;

    private CreateSubscriberRequest(BuilderImpl builder) {
        super(builder);
        this.accessTypes = builder.accessTypes;
        this.accountId = builder.accountId;
        this.externalId = builder.externalId;
        this.sourceTypes = builder.sourceTypes;
        this.subscriberDescription = builder.subscriberDescription;
        this.subscriberName = builder.subscriberName;
    }

    /**
     * <p>
     * The Amazon S3 or Lake Formation access type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessTypes} method.
     * </p>
     * 
     * @return The Amazon S3 or Lake Formation access type.
     */
    public final List<AccessType> accessTypes() {
        return AccessTypeListCopier.copyStringToEnum(accessTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessTypes() {
        return accessTypes != null && !(accessTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon S3 or Lake Formation access type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessTypes} method.
     * </p>
     * 
     * @return The Amazon S3 or Lake Formation access type.
     */
    public final List<String> accessTypesAsStrings() {
        return accessTypes;
    }

    /**
     * <p>
     * The Amazon Web Services account ID used to access your data.
     * </p>
     * 
     * @return The Amazon Web Services account ID used to access your data.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The external ID of the subscriber. This lets the user that is assuming the role assert the circumstances in which
     * they are operating. It also provides a way for the account owner to permit the role to be assumed only under
     * specific circumstances.
     * </p>
     * 
     * @return The external ID of the subscriber. This lets the user that is assuming the role assert the circumstances
     *         in which they are operating. It also provides a way for the account owner to permit the role to be
     *         assumed only under specific circumstances.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceTypes() {
        return sourceTypes != null && !(sourceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and event
     * collection for natively supported Amazon Web Services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceTypes} method.
     * </p>
     * 
     * @return The supported Amazon Web Services from which logs and events are collected. Security Lake supports log
     *         and event collection for natively supported Amazon Web Services.
     */
    public final List<SourceType> sourceTypes() {
        return sourceTypes;
    }

    /**
     * <p>
     * The description for your subscriber account in Security Lake.
     * </p>
     * 
     * @return The description for your subscriber account in Security Lake.
     */
    public final String subscriberDescription() {
        return subscriberDescription;
    }

    /**
     * <p>
     * The name of your Security Lake subscriber account.
     * </p>
     * 
     * @return The name of your Security Lake subscriber account.
     */
    public final String subscriberName() {
        return subscriberName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessTypes() ? accessTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceTypes() ? sourceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(subscriberDescription());
        hashCode = 31 * hashCode + Objects.hashCode(subscriberName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriberRequest)) {
            return false;
        }
        CreateSubscriberRequest other = (CreateSubscriberRequest) obj;
        return hasAccessTypes() == other.hasAccessTypes() && Objects.equals(accessTypesAsStrings(), other.accessTypesAsStrings())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(externalId(), other.externalId())
                && hasSourceTypes() == other.hasSourceTypes() && Objects.equals(sourceTypes(), other.sourceTypes())
                && Objects.equals(subscriberDescription(), other.subscriberDescription())
                && Objects.equals(subscriberName(), other.subscriberName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSubscriberRequest").add("AccessTypes", hasAccessTypes() ? accessTypesAsStrings() : null)
                .add("AccountId", accountId()).add("ExternalId", externalId())
                .add("SourceTypes", hasSourceTypes() ? sourceTypes() : null)
                .add("SubscriberDescription", subscriberDescription()).add("SubscriberName", subscriberName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessTypes":
            return Optional.ofNullable(clazz.cast(accessTypesAsStrings()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "sourceTypes":
            return Optional.ofNullable(clazz.cast(sourceTypes()));
        case "subscriberDescription":
            return Optional.ofNullable(clazz.cast(subscriberDescription()));
        case "subscriberName":
            return Optional.ofNullable(clazz.cast(subscriberName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriberRequest, T> g) {
        return obj -> g.apply((CreateSubscriberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityLakeRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSubscriberRequest> {
        /**
         * <p>
         * The Amazon S3 or Lake Formation access type.
         * </p>
         * 
         * @param accessTypes
         *        The Amazon S3 or Lake Formation access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTypesWithStrings(Collection<String> accessTypes);

        /**
         * <p>
         * The Amazon S3 or Lake Formation access type.
         * </p>
         * 
         * @param accessTypes
         *        The Amazon S3 or Lake Formation access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTypesWithStrings(String... accessTypes);

        /**
         * <p>
         * The Amazon S3 or Lake Formation access type.
         * </p>
         * 
         * @param accessTypes
         *        The Amazon S3 or Lake Formation access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTypes(Collection<AccessType> accessTypes);

        /**
         * <p>
         * The Amazon S3 or Lake Formation access type.
         * </p>
         * 
         * @param accessTypes
         *        The Amazon S3 or Lake Formation access type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessTypes(AccessType... accessTypes);

        /**
         * <p>
         * The Amazon Web Services account ID used to access your data.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID used to access your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The external ID of the subscriber. This lets the user that is assuming the role assert the circumstances in
         * which they are operating. It also provides a way for the account owner to permit the role to be assumed only
         * under specific circumstances.
         * </p>
         * 
         * @param externalId
         *        The external ID of the subscriber. This lets the user that is assuming the role assert the
         *        circumstances in which they are operating. It also provides a way for the account owner to permit the
         *        role to be assumed only under specific circumstances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and
         * event collection for natively supported Amazon Web Services.
         * </p>
         * 
         * @param sourceTypes
         *        The supported Amazon Web Services from which logs and events are collected. Security Lake supports log
         *        and event collection for natively supported Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTypes(Collection<SourceType> sourceTypes);

        /**
         * <p>
         * The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and
         * event collection for natively supported Amazon Web Services.
         * </p>
         * 
         * @param sourceTypes
         *        The supported Amazon Web Services from which logs and events are collected. Security Lake supports log
         *        and event collection for natively supported Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTypes(SourceType... sourceTypes);

        /**
         * <p>
         * The supported Amazon Web Services from which logs and events are collected. Security Lake supports log and
         * event collection for natively supported Amazon Web Services.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securitylake.model.SourceType.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securitylake.model.SourceType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securitylake.model.SourceType.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceTypes(List<SourceType>)}.
         * 
         * @param sourceTypes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securitylake.model.SourceType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceTypes(java.util.Collection<SourceType>)
         */
        Builder sourceTypes(Consumer<SourceType.Builder>... sourceTypes);

        /**
         * <p>
         * The description for your subscriber account in Security Lake.
         * </p>
         * 
         * @param subscriberDescription
         *        The description for your subscriber account in Security Lake.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberDescription(String subscriberDescription);

        /**
         * <p>
         * The name of your Security Lake subscriber account.
         * </p>
         * 
         * @param subscriberName
         *        The name of your Security Lake subscriber account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriberName(String subscriberName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityLakeRequest.BuilderImpl implements Builder {
        private List<String> accessTypes = DefaultSdkAutoConstructList.getInstance();

        private String accountId;

        private String externalId;

        private List<SourceType> sourceTypes = DefaultSdkAutoConstructList.getInstance();

        private String subscriberDescription;

        private String subscriberName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriberRequest model) {
            super(model);
            accessTypesWithStrings(model.accessTypes);
            accountId(model.accountId);
            externalId(model.externalId);
            sourceTypes(model.sourceTypes);
            subscriberDescription(model.subscriberDescription);
            subscriberName(model.subscriberName);
        }

        public final Collection<String> getAccessTypes() {
            if (accessTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return accessTypes;
        }

        public final void setAccessTypes(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
        }

        @Override
        public final Builder accessTypesWithStrings(Collection<String> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copy(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypesWithStrings(String... accessTypes) {
            accessTypesWithStrings(Arrays.asList(accessTypes));
            return this;
        }

        @Override
        public final Builder accessTypes(Collection<AccessType> accessTypes) {
            this.accessTypes = AccessTypeListCopier.copyEnumToString(accessTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessTypes(AccessType... accessTypes) {
            accessTypes(Arrays.asList(accessTypes));
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final List<SourceType.Builder> getSourceTypes() {
            List<SourceType.Builder> result = SourceTypeListCopier.copyToBuilder(this.sourceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceTypes(Collection<SourceType.BuilderImpl> sourceTypes) {
            this.sourceTypes = SourceTypeListCopier.copyFromBuilder(sourceTypes);
        }

        @Override
        public final Builder sourceTypes(Collection<SourceType> sourceTypes) {
            this.sourceTypes = SourceTypeListCopier.copy(sourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(SourceType... sourceTypes) {
            sourceTypes(Arrays.asList(sourceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceTypes(Consumer<SourceType.Builder>... sourceTypes) {
            sourceTypes(Stream.of(sourceTypes).map(c -> SourceType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getSubscriberDescription() {
            return subscriberDescription;
        }

        public final void setSubscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
        }

        @Override
        public final Builder subscriberDescription(String subscriberDescription) {
            this.subscriberDescription = subscriberDescription;
            return this;
        }

        public final String getSubscriberName() {
            return subscriberName;
        }

        public final void setSubscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
        }

        @Override
        public final Builder subscriberName(String subscriberName) {
            this.subscriberName = subscriberName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriberRequest build() {
            return new CreateSubscriberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
