/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides metadata for a security control, including its unique standard-agnostic identifier, title, description,
 * severity, availability in Amazon Web Services Regions, and a link to remediation steps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityControlDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityControlDefinition.Builder, SecurityControlDefinition> {
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityControlId").getter(getter(SecurityControlDefinition::securityControlId))
            .setter(setter(Builder::securityControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(SecurityControlDefinition::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(SecurityControlDefinition::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> REMEDIATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RemediationUrl").getter(getter(SecurityControlDefinition::remediationUrl))
            .setter(setter(Builder::remediationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemediationUrl").build()).build();

    private static final SdkField<String> SEVERITY_RATING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SeverityRating").getter(getter(SecurityControlDefinition::severityRatingAsString))
            .setter(setter(Builder::severityRating))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityRating").build()).build();

    private static final SdkField<String> CURRENT_REGION_AVAILABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentRegionAvailability").getter(getter(SecurityControlDefinition::currentRegionAvailabilityAsString))
            .setter(setter(Builder::currentRegionAvailability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentRegionAvailability").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_ID_FIELD,
            TITLE_FIELD, DESCRIPTION_FIELD, REMEDIATION_URL_FIELD, SEVERITY_RATING_FIELD, CURRENT_REGION_AVAILABILITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String securityControlId;

    private final String title;

    private final String description;

    private final String remediationUrl;

    private final String severityRating;

    private final String currentRegionAvailability;

    private SecurityControlDefinition(BuilderImpl builder) {
        this.securityControlId = builder.securityControlId;
        this.title = builder.title;
        this.description = builder.description;
        this.remediationUrl = builder.remediationUrl;
        this.severityRating = builder.severityRating;
        this.currentRegionAvailability = builder.currentRegionAvailability;
    }

    /**
     * <p>
     * The unique identifier of a security control across standards. Values for this field typically consist of an
     * Amazon Web Service name and a number (for example, APIGateway.3). This parameter differs from
     * <code>SecurityControlArn</code>, which is a unique Amazon Resource Name (ARN) assigned to a control. The ARN
     * references the security control ID (for example,
     * arn:aws:securityhub:eu-central-1:123456789012:security-control/APIGateway.3).
     * </p>
     * 
     * @return The unique identifier of a security control across standards. Values for this field typically consist of
     *         an Amazon Web Service name and a number (for example, APIGateway.3). This parameter differs from
     *         <code>SecurityControlArn</code>, which is a unique Amazon Resource Name (ARN) assigned to a control. The
     *         ARN references the security control ID (for example,
     *         arn:aws:securityhub:eu-central-1:123456789012:security-control/APIGateway.3).
     */
    public final String securityControlId() {
        return securityControlId;
    }

    /**
     * <p>
     * The title of a security control.
     * </p>
     * 
     * @return The title of a security control.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The description of a security control across standards. This typically summarizes how Security Hub evaluates the
     * control and the conditions under which it produces a failed finding. This parameter doesn't reference a specific
     * standard.
     * </p>
     * 
     * @return The description of a security control across standards. This typically summarizes how Security Hub
     *         evaluates the control and the conditions under which it produces a failed finding. This parameter doesn't
     *         reference a specific standard.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A link to Security Hub documentation that explains how to remediate a failed finding for a security control.
     * </p>
     * 
     * @return A link to Security Hub documentation that explains how to remediate a failed finding for a security
     *         control.
     */
    public final String remediationUrl() {
        return remediationUrl;
    }

    /**
     * <p>
     * The severity of a security control. For more information about how Security Hub determines control severity, see
     * <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity"
     * >Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severityRating}
     * will return {@link SeverityRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #severityRatingAsString}.
     * </p>
     * 
     * @return The severity of a security control. For more information about how Security Hub determines control
     *         severity, see <a href=
     *         "https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity"
     *         >Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>.
     * @see SeverityRating
     */
    public final SeverityRating severityRating() {
        return SeverityRating.fromValue(severityRating);
    }

    /**
     * <p>
     * The severity of a security control. For more information about how Security Hub determines control severity, see
     * <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity"
     * >Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severityRating}
     * will return {@link SeverityRating#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #severityRatingAsString}.
     * </p>
     * 
     * @return The severity of a security control. For more information about how Security Hub determines control
     *         severity, see <a href=
     *         "https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity"
     *         >Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>.
     * @see SeverityRating
     */
    public final String severityRatingAsString() {
        return severityRating;
    }

    /**
     * <p>
     * Specifies whether a security control is available in the current Amazon Web Services Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentRegionAvailability} will return {@link RegionAvailabilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #currentRegionAvailabilityAsString}.
     * </p>
     * 
     * @return Specifies whether a security control is available in the current Amazon Web Services Region.
     * @see RegionAvailabilityStatus
     */
    public final RegionAvailabilityStatus currentRegionAvailability() {
        return RegionAvailabilityStatus.fromValue(currentRegionAvailability);
    }

    /**
     * <p>
     * Specifies whether a security control is available in the current Amazon Web Services Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #currentRegionAvailability} will return {@link RegionAvailabilityStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #currentRegionAvailabilityAsString}.
     * </p>
     * 
     * @return Specifies whether a security control is available in the current Amazon Web Services Region.
     * @see RegionAvailabilityStatus
     */
    public final String currentRegionAvailabilityAsString() {
        return currentRegionAvailability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(remediationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(severityRatingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentRegionAvailabilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityControlDefinition)) {
            return false;
        }
        SecurityControlDefinition other = (SecurityControlDefinition) obj;
        return Objects.equals(securityControlId(), other.securityControlId()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && Objects.equals(remediationUrl(), other.remediationUrl())
                && Objects.equals(severityRatingAsString(), other.severityRatingAsString())
                && Objects.equals(currentRegionAvailabilityAsString(), other.currentRegionAvailabilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityControlDefinition").add("SecurityControlId", securityControlId()).add("Title", title())
                .add("Description", description()).add("RemediationUrl", remediationUrl())
                .add("SeverityRating", severityRatingAsString())
                .add("CurrentRegionAvailability", currentRegionAvailabilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityControlId":
            return Optional.ofNullable(clazz.cast(securityControlId()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "RemediationUrl":
            return Optional.ofNullable(clazz.cast(remediationUrl()));
        case "SeverityRating":
            return Optional.ofNullable(clazz.cast(severityRatingAsString()));
        case "CurrentRegionAvailability":
            return Optional.ofNullable(clazz.cast(currentRegionAvailabilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityControlDefinition, T> g) {
        return obj -> g.apply((SecurityControlDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityControlDefinition> {
        /**
         * <p>
         * The unique identifier of a security control across standards. Values for this field typically consist of an
         * Amazon Web Service name and a number (for example, APIGateway.3). This parameter differs from
         * <code>SecurityControlArn</code>, which is a unique Amazon Resource Name (ARN) assigned to a control. The ARN
         * references the security control ID (for example,
         * arn:aws:securityhub:eu-central-1:123456789012:security-control/APIGateway.3).
         * </p>
         * 
         * @param securityControlId
         *        The unique identifier of a security control across standards. Values for this field typically consist
         *        of an Amazon Web Service name and a number (for example, APIGateway.3). This parameter differs from
         *        <code>SecurityControlArn</code>, which is a unique Amazon Resource Name (ARN) assigned to a control.
         *        The ARN references the security control ID (for example,
         *        arn:aws:securityhub:eu-central-1:123456789012:security-control/APIGateway.3).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlId(String securityControlId);

        /**
         * <p>
         * The title of a security control.
         * </p>
         * 
         * @param title
         *        The title of a security control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The description of a security control across standards. This typically summarizes how Security Hub evaluates
         * the control and the conditions under which it produces a failed finding. This parameter doesn't reference a
         * specific standard.
         * </p>
         * 
         * @param description
         *        The description of a security control across standards. This typically summarizes how Security Hub
         *        evaluates the control and the conditions under which it produces a failed finding. This parameter
         *        doesn't reference a specific standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A link to Security Hub documentation that explains how to remediate a failed finding for a security control.
         * </p>
         * 
         * @param remediationUrl
         *        A link to Security Hub documentation that explains how to remediate a failed finding for a security
         *        control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remediationUrl(String remediationUrl);

        /**
         * <p>
         * The severity of a security control. For more information about how Security Hub determines control severity,
         * see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity"
         * >Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * 
         * @param severityRating
         *        The severity of a security control. For more information about how Security Hub determines control
         *        severity, see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity"
         *        >Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>.
         * @see SeverityRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityRating
         */
        Builder severityRating(String severityRating);

        /**
         * <p>
         * The severity of a security control. For more information about how Security Hub determines control severity,
         * see <a href=
         * "https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity"
         * >Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>.
         * </p>
         * 
         * @param severityRating
         *        The severity of a security control. For more information about how Security Hub determines control
         *        severity, see <a href=
         *        "https://docs.aws.amazon.com/securityhub/latest/userguide/controls-findings-create-update.html#control-findings-severity"
         *        >Assigning severity to control findings</a> in the <i>Security Hub User Guide</i>.
         * @see SeverityRating
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SeverityRating
         */
        Builder severityRating(SeverityRating severityRating);

        /**
         * <p>
         * Specifies whether a security control is available in the current Amazon Web Services Region.
         * </p>
         * 
         * @param currentRegionAvailability
         *        Specifies whether a security control is available in the current Amazon Web Services Region.
         * @see RegionAvailabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionAvailabilityStatus
         */
        Builder currentRegionAvailability(String currentRegionAvailability);

        /**
         * <p>
         * Specifies whether a security control is available in the current Amazon Web Services Region.
         * </p>
         * 
         * @param currentRegionAvailability
         *        Specifies whether a security control is available in the current Amazon Web Services Region.
         * @see RegionAvailabilityStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionAvailabilityStatus
         */
        Builder currentRegionAvailability(RegionAvailabilityStatus currentRegionAvailability);
    }

    static final class BuilderImpl implements Builder {
        private String securityControlId;

        private String title;

        private String description;

        private String remediationUrl;

        private String severityRating;

        private String currentRegionAvailability;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityControlDefinition model) {
            securityControlId(model.securityControlId);
            title(model.title);
            description(model.description);
            remediationUrl(model.remediationUrl);
            severityRating(model.severityRating);
            currentRegionAvailability(model.currentRegionAvailability);
        }

        public final String getSecurityControlId() {
            return securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRemediationUrl() {
            return remediationUrl;
        }

        public final void setRemediationUrl(String remediationUrl) {
            this.remediationUrl = remediationUrl;
        }

        @Override
        public final Builder remediationUrl(String remediationUrl) {
            this.remediationUrl = remediationUrl;
            return this;
        }

        public final String getSeverityRating() {
            return severityRating;
        }

        public final void setSeverityRating(String severityRating) {
            this.severityRating = severityRating;
        }

        @Override
        public final Builder severityRating(String severityRating) {
            this.severityRating = severityRating;
            return this;
        }

        @Override
        public final Builder severityRating(SeverityRating severityRating) {
            this.severityRating(severityRating == null ? null : severityRating.toString());
            return this;
        }

        public final String getCurrentRegionAvailability() {
            return currentRegionAvailability;
        }

        public final void setCurrentRegionAvailability(String currentRegionAvailability) {
            this.currentRegionAvailability = currentRegionAvailability;
        }

        @Override
        public final Builder currentRegionAvailability(String currentRegionAvailability) {
            this.currentRegionAvailability = currentRegionAvailability;
            return this;
        }

        @Override
        public final Builder currentRegionAvailability(RegionAvailabilityStatus currentRegionAvailability) {
            this.currentRegionAvailability(currentRegionAvailability == null ? null : currentRegionAvailability.toString());
            return this;
        }

        @Override
        public SecurityControlDefinition build() {
            return new SecurityControlDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
