/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about where a code vulnerability is located in your Lambda function.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CodeVulnerabilitiesFilePath implements SdkPojo, Serializable,
        ToCopyableBuilder<CodeVulnerabilitiesFilePath.Builder, CodeVulnerabilitiesFilePath> {
    private static final SdkField<Integer> END_LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndLine").getter(getter(CodeVulnerabilitiesFilePath::endLine)).setter(setter(Builder::endLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndLine").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(CodeVulnerabilitiesFilePath::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileName").build()).build();

    private static final SdkField<String> FILE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FilePath").getter(getter(CodeVulnerabilitiesFilePath::filePath)).setter(setter(Builder::filePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilePath").build()).build();

    private static final SdkField<Integer> START_LINE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartLine").getter(getter(CodeVulnerabilitiesFilePath::startLine)).setter(setter(Builder::startLine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartLine").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_LINE_FIELD,
            FILE_NAME_FIELD, FILE_PATH_FIELD, START_LINE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer endLine;

    private final String fileName;

    private final String filePath;

    private final Integer startLine;

    private CodeVulnerabilitiesFilePath(BuilderImpl builder) {
        this.endLine = builder.endLine;
        this.fileName = builder.fileName;
        this.filePath = builder.filePath;
        this.startLine = builder.startLine;
    }

    /**
     * <p>
     * The line number of the last line of code in which the vulnerability is located.
     * </p>
     * 
     * @return The line number of the last line of code in which the vulnerability is located.
     */
    public final Integer endLine() {
        return endLine;
    }

    /**
     * <p>
     * The name of the file in which the code vulnerability is located.
     * </p>
     * 
     * @return The name of the file in which the code vulnerability is located.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The file path to the code in which the vulnerability is located.
     * </p>
     * 
     * @return The file path to the code in which the vulnerability is located.
     */
    public final String filePath() {
        return filePath;
    }

    /**
     * <p>
     * The line number of the first line of code in which the vulnerability is located.
     * </p>
     * 
     * @return The line number of the first line of code in which the vulnerability is located.
     */
    public final Integer startLine() {
        return startLine;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endLine());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(filePath());
        hashCode = 31 * hashCode + Objects.hashCode(startLine());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeVulnerabilitiesFilePath)) {
            return false;
        }
        CodeVulnerabilitiesFilePath other = (CodeVulnerabilitiesFilePath) obj;
        return Objects.equals(endLine(), other.endLine()) && Objects.equals(fileName(), other.fileName())
                && Objects.equals(filePath(), other.filePath()) && Objects.equals(startLine(), other.startLine());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CodeVulnerabilitiesFilePath").add("EndLine", endLine()).add("FileName", fileName())
                .add("FilePath", filePath()).add("StartLine", startLine()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndLine":
            return Optional.ofNullable(clazz.cast(endLine()));
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "FilePath":
            return Optional.ofNullable(clazz.cast(filePath()));
        case "StartLine":
            return Optional.ofNullable(clazz.cast(startLine()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeVulnerabilitiesFilePath, T> g) {
        return obj -> g.apply((CodeVulnerabilitiesFilePath) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CodeVulnerabilitiesFilePath> {
        /**
         * <p>
         * The line number of the last line of code in which the vulnerability is located.
         * </p>
         * 
         * @param endLine
         *        The line number of the last line of code in which the vulnerability is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endLine(Integer endLine);

        /**
         * <p>
         * The name of the file in which the code vulnerability is located.
         * </p>
         * 
         * @param fileName
         *        The name of the file in which the code vulnerability is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The file path to the code in which the vulnerability is located.
         * </p>
         * 
         * @param filePath
         *        The file path to the code in which the vulnerability is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filePath(String filePath);

        /**
         * <p>
         * The line number of the first line of code in which the vulnerability is located.
         * </p>
         * 
         * @param startLine
         *        The line number of the first line of code in which the vulnerability is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startLine(Integer startLine);
    }

    static final class BuilderImpl implements Builder {
        private Integer endLine;

        private String fileName;

        private String filePath;

        private Integer startLine;

        private BuilderImpl() {
        }

        private BuilderImpl(CodeVulnerabilitiesFilePath model) {
            endLine(model.endLine);
            fileName(model.fileName);
            filePath(model.filePath);
            startLine(model.startLine);
        }

        public final Integer getEndLine() {
            return endLine;
        }

        public final void setEndLine(Integer endLine) {
            this.endLine = endLine;
        }

        @Override
        public final Builder endLine(Integer endLine) {
            this.endLine = endLine;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getFilePath() {
            return filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final Integer getStartLine() {
            return startLine;
        }

        public final void setStartLine(Integer startLine) {
            this.startLine = startLine;
        }

        @Override
        public final Builder startLine(Integer startLine) {
            this.startLine = startLine;
            return this;
        }

        @Override
        public CodeVulnerabilitiesFilePath build() {
            return new CodeVulnerabilitiesFilePath(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
