/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetStandardsControlAssociationsResponse extends SecurityHubResponse implements
        ToCopyableBuilder<BatchGetStandardsControlAssociationsResponse.Builder, BatchGetStandardsControlAssociationsResponse> {
    private static final SdkField<List<StandardsControlAssociationDetail>> STANDARDS_CONTROL_ASSOCIATION_DETAILS_FIELD = SdkField
            .<List<StandardsControlAssociationDetail>> builder(MarshallingType.LIST)
            .memberName("StandardsControlAssociationDetails")
            .getter(getter(BatchGetStandardsControlAssociationsResponse::standardsControlAssociationDetails))
            .setter(setter(Builder::standardsControlAssociationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StandardsControlAssociationDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(StandardsControlAssociationDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<UnprocessedStandardsControlAssociation>> UNPROCESSED_ASSOCIATIONS_FIELD = SdkField
            .<List<UnprocessedStandardsControlAssociation>> builder(MarshallingType.LIST)
            .memberName("UnprocessedAssociations")
            .getter(getter(BatchGetStandardsControlAssociationsResponse::unprocessedAssociations))
            .setter(setter(Builder::unprocessedAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UnprocessedStandardsControlAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(UnprocessedStandardsControlAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            STANDARDS_CONTROL_ASSOCIATION_DETAILS_FIELD, UNPROCESSED_ASSOCIATIONS_FIELD));

    private final List<StandardsControlAssociationDetail> standardsControlAssociationDetails;

    private final List<UnprocessedStandardsControlAssociation> unprocessedAssociations;

    private BatchGetStandardsControlAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.standardsControlAssociationDetails = builder.standardsControlAssociationDetails;
        this.unprocessedAssociations = builder.unprocessedAssociations;
    }

    /**
     * For responses, this returns true if the service returned a value for the StandardsControlAssociationDetails
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasStandardsControlAssociationDetails() {
        return standardsControlAssociationDetails != null
                && !(standardsControlAssociationDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides the enablement status of a security control in a specified standard and other details for the control in
     * relation to the specified standard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandardsControlAssociationDetails}
     * method.
     * </p>
     * 
     * @return Provides the enablement status of a security control in a specified standard and other details for the
     *         control in relation to the specified standard.
     */
    public final List<StandardsControlAssociationDetail> standardsControlAssociationDetails() {
        return standardsControlAssociationDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the UnprocessedAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUnprocessedAssociations() {
        return unprocessedAssociations != null && !(unprocessedAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix of
     * both parameters) whose enablement status in a specified standard cannot be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUnprocessedAssociations} method.
     * </p>
     * 
     * @return A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a
     *         mix of both parameters) whose enablement status in a specified standard cannot be returned.
     */
    public final List<UnprocessedStandardsControlAssociation> unprocessedAssociations() {
        return unprocessedAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasStandardsControlAssociationDetails() ? standardsControlAssociationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUnprocessedAssociations() ? unprocessedAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetStandardsControlAssociationsResponse)) {
            return false;
        }
        BatchGetStandardsControlAssociationsResponse other = (BatchGetStandardsControlAssociationsResponse) obj;
        return hasStandardsControlAssociationDetails() == other.hasStandardsControlAssociationDetails()
                && Objects.equals(standardsControlAssociationDetails(), other.standardsControlAssociationDetails())
                && hasUnprocessedAssociations() == other.hasUnprocessedAssociations()
                && Objects.equals(unprocessedAssociations(), other.unprocessedAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchGetStandardsControlAssociationsResponse")
                .add("StandardsControlAssociationDetails",
                        hasStandardsControlAssociationDetails() ? standardsControlAssociationDetails() : null)
                .add("UnprocessedAssociations", hasUnprocessedAssociations() ? unprocessedAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardsControlAssociationDetails":
            return Optional.ofNullable(clazz.cast(standardsControlAssociationDetails()));
        case "UnprocessedAssociations":
            return Optional.ofNullable(clazz.cast(unprocessedAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetStandardsControlAssociationsResponse, T> g) {
        return obj -> g.apply((BatchGetStandardsControlAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetStandardsControlAssociationsResponse> {
        /**
         * <p>
         * Provides the enablement status of a security control in a specified standard and other details for the
         * control in relation to the specified standard.
         * </p>
         * 
         * @param standardsControlAssociationDetails
         *        Provides the enablement status of a security control in a specified standard and other details for the
         *        control in relation to the specified standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsControlAssociationDetails(
                Collection<StandardsControlAssociationDetail> standardsControlAssociationDetails);

        /**
         * <p>
         * Provides the enablement status of a security control in a specified standard and other details for the
         * control in relation to the specified standard.
         * </p>
         * 
         * @param standardsControlAssociationDetails
         *        Provides the enablement status of a security control in a specified standard and other details for the
         *        control in relation to the specified standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardsControlAssociationDetails(StandardsControlAssociationDetail... standardsControlAssociationDetails);

        /**
         * <p>
         * Provides the enablement status of a security control in a specified standard and other details for the
         * control in relation to the specified standard.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #standardsControlAssociationDetails(List<StandardsControlAssociationDetail>)}.
         * 
         * @param standardsControlAssociationDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #standardsControlAssociationDetails(java.util.Collection<StandardsControlAssociationDetail>)
         */
        Builder standardsControlAssociationDetails(
                Consumer<StandardsControlAssociationDetail.Builder>... standardsControlAssociationDetails);

        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) whose enablement status in a specified standard cannot be returned.
         * </p>
         * 
         * @param unprocessedAssociations
         *        A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
         *        or a mix of both parameters) whose enablement status in a specified standard cannot be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAssociations(Collection<UnprocessedStandardsControlAssociation> unprocessedAssociations);

        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) whose enablement status in a specified standard cannot be returned.
         * </p>
         * 
         * @param unprocessedAssociations
         *        A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
         *        or a mix of both parameters) whose enablement status in a specified standard cannot be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unprocessedAssociations(UnprocessedStandardsControlAssociation... unprocessedAssociations);

        /**
         * <p>
         * A security control (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or a mix
         * of both parameters) whose enablement status in a specified standard cannot be returned.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #unprocessedAssociations(List<UnprocessedStandardsControlAssociation>)}.
         * 
         * @param unprocessedAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unprocessedAssociations(java.util.Collection<UnprocessedStandardsControlAssociation>)
         */
        Builder unprocessedAssociations(Consumer<UnprocessedStandardsControlAssociation.Builder>... unprocessedAssociations);
    }

    static final class BuilderImpl extends SecurityHubResponse.BuilderImpl implements Builder {
        private List<StandardsControlAssociationDetail> standardsControlAssociationDetails = DefaultSdkAutoConstructList
                .getInstance();

        private List<UnprocessedStandardsControlAssociation> unprocessedAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetStandardsControlAssociationsResponse model) {
            super(model);
            standardsControlAssociationDetails(model.standardsControlAssociationDetails);
            unprocessedAssociations(model.unprocessedAssociations);
        }

        public final List<StandardsControlAssociationDetail.Builder> getStandardsControlAssociationDetails() {
            List<StandardsControlAssociationDetail.Builder> result = StandardsControlAssociationDetailsCopier
                    .copyToBuilder(this.standardsControlAssociationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandardsControlAssociationDetails(
                Collection<StandardsControlAssociationDetail.BuilderImpl> standardsControlAssociationDetails) {
            this.standardsControlAssociationDetails = StandardsControlAssociationDetailsCopier
                    .copyFromBuilder(standardsControlAssociationDetails);
        }

        @Override
        public final Builder standardsControlAssociationDetails(
                Collection<StandardsControlAssociationDetail> standardsControlAssociationDetails) {
            this.standardsControlAssociationDetails = StandardsControlAssociationDetailsCopier
                    .copy(standardsControlAssociationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationDetails(
                StandardsControlAssociationDetail... standardsControlAssociationDetails) {
            standardsControlAssociationDetails(Arrays.asList(standardsControlAssociationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationDetails(
                Consumer<StandardsControlAssociationDetail.Builder>... standardsControlAssociationDetails) {
            standardsControlAssociationDetails(Stream.of(standardsControlAssociationDetails)
                    .map(c -> StandardsControlAssociationDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedStandardsControlAssociation.Builder> getUnprocessedAssociations() {
            List<UnprocessedStandardsControlAssociation.Builder> result = UnprocessedStandardsControlAssociationsCopier
                    .copyToBuilder(this.unprocessedAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAssociations(
                Collection<UnprocessedStandardsControlAssociation.BuilderImpl> unprocessedAssociations) {
            this.unprocessedAssociations = UnprocessedStandardsControlAssociationsCopier.copyFromBuilder(unprocessedAssociations);
        }

        @Override
        public final Builder unprocessedAssociations(Collection<UnprocessedStandardsControlAssociation> unprocessedAssociations) {
            this.unprocessedAssociations = UnprocessedStandardsControlAssociationsCopier.copy(unprocessedAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAssociations(UnprocessedStandardsControlAssociation... unprocessedAssociations) {
            unprocessedAssociations(Arrays.asList(unprocessedAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAssociations(
                Consumer<UnprocessedStandardsControlAssociation.Builder>... unprocessedAssociations) {
            unprocessedAssociations(Stream.of(unprocessedAssociations)
                    .map(c -> UnprocessedStandardsControlAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetStandardsControlAssociationsResponse build() {
            return new BatchGetStandardsControlAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
