/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetSecurityControlsRequest extends SecurityHubRequest implements
        ToCopyableBuilder<BatchGetSecurityControlsRequest.Builder, BatchGetSecurityControlsRequest> {
    private static final SdkField<List<String>> SECURITY_CONTROL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityControlIds")
            .getter(getter(BatchGetSecurityControlsRequest::securityControlIds))
            .setter(setter(Builder::securityControlIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_IDS_FIELD));

    private final List<String> securityControlIds;

    private BatchGetSecurityControlsRequest(BuilderImpl builder) {
        super(builder);
        this.securityControlIds = builder.securityControlIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityControlIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityControlIds() {
        return securityControlIds != null && !(securityControlIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of security controls (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>, or
     * a mix of both parameters). The security control ID or Amazon Resource Name (ARN) is the same across standards.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityControlIds} method.
     * </p>
     * 
     * @return A list of security controls (identified with <code>SecurityControlId</code>,
     *         <code>SecurityControlArn</code>, or a mix of both parameters). The security control ID or Amazon Resource
     *         Name (ARN) is the same across standards.
     */
    public final List<String> securityControlIds() {
        return securityControlIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityControlIds() ? securityControlIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetSecurityControlsRequest)) {
            return false;
        }
        BatchGetSecurityControlsRequest other = (BatchGetSecurityControlsRequest) obj;
        return hasSecurityControlIds() == other.hasSecurityControlIds()
                && Objects.equals(securityControlIds(), other.securityControlIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetSecurityControlsRequest")
                .add("SecurityControlIds", hasSecurityControlIds() ? securityControlIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityControlIds":
            return Optional.ofNullable(clazz.cast(securityControlIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetSecurityControlsRequest, T> g) {
        return obj -> g.apply((BatchGetSecurityControlsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetSecurityControlsRequest> {
        /**
         * <p>
         * A list of security controls (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
         * or a mix of both parameters). The security control ID or Amazon Resource Name (ARN) is the same across
         * standards.
         * </p>
         * 
         * @param securityControlIds
         *        A list of security controls (identified with <code>SecurityControlId</code>,
         *        <code>SecurityControlArn</code>, or a mix of both parameters). The security control ID or Amazon
         *        Resource Name (ARN) is the same across standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlIds(Collection<String> securityControlIds);

        /**
         * <p>
         * A list of security controls (identified with <code>SecurityControlId</code>, <code>SecurityControlArn</code>,
         * or a mix of both parameters). The security control ID or Amazon Resource Name (ARN) is the same across
         * standards.
         * </p>
         * 
         * @param securityControlIds
         *        A list of security controls (identified with <code>SecurityControlId</code>,
         *        <code>SecurityControlArn</code>, or a mix of both parameters). The security control ID or Amazon
         *        Resource Name (ARN) is the same across standards.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlIds(String... securityControlIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private List<String> securityControlIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetSecurityControlsRequest model) {
            super(model);
            securityControlIds(model.securityControlIds);
        }

        public final Collection<String> getSecurityControlIds() {
            if (securityControlIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityControlIds;
        }

        public final void setSecurityControlIds(Collection<String> securityControlIds) {
            this.securityControlIds = StringListCopier.copy(securityControlIds);
        }

        @Override
        public final Builder securityControlIds(Collection<String> securityControlIds) {
            this.securityControlIds = StringListCopier.copy(securityControlIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityControlIds(String... securityControlIds) {
            securityControlIds(Arrays.asList(securityControlIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetSecurityControlsRequest build() {
            return new BatchGetSecurityControlsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
