/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about different modes of client authentication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsMskClusterClusterInfoClientAuthenticationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsMskClusterClusterInfoClientAuthenticationDetails.Builder, AwsMskClusterClusterInfoClientAuthenticationDetails> {
    private static final SdkField<AwsMskClusterClusterInfoClientAuthenticationSaslDetails> SASL_FIELD = SdkField
            .<AwsMskClusterClusterInfoClientAuthenticationSaslDetails> builder(MarshallingType.SDK_POJO).memberName("Sasl")
            .getter(getter(AwsMskClusterClusterInfoClientAuthenticationDetails::sasl)).setter(setter(Builder::sasl))
            .constructor(AwsMskClusterClusterInfoClientAuthenticationSaslDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sasl").build()).build();

    private static final SdkField<AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails> UNAUTHENTICATED_FIELD = SdkField
            .<AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Unauthenticated").getter(getter(AwsMskClusterClusterInfoClientAuthenticationDetails::unauthenticated))
            .setter(setter(Builder::unauthenticated))
            .constructor(AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unauthenticated").build()).build();

    private static final SdkField<AwsMskClusterClusterInfoClientAuthenticationTlsDetails> TLS_FIELD = SdkField
            .<AwsMskClusterClusterInfoClientAuthenticationTlsDetails> builder(MarshallingType.SDK_POJO).memberName("Tls")
            .getter(getter(AwsMskClusterClusterInfoClientAuthenticationDetails::tls)).setter(setter(Builder::tls))
            .constructor(AwsMskClusterClusterInfoClientAuthenticationTlsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tls").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SASL_FIELD,
            UNAUTHENTICATED_FIELD, TLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsMskClusterClusterInfoClientAuthenticationSaslDetails sasl;

    private final AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails unauthenticated;

    private final AwsMskClusterClusterInfoClientAuthenticationTlsDetails tls;

    private AwsMskClusterClusterInfoClientAuthenticationDetails(BuilderImpl builder) {
        this.sasl = builder.sasl;
        this.unauthenticated = builder.unauthenticated;
        this.tls = builder.tls;
    }

    /**
     * <p>
     * Provides details for client authentication using SASL.
     * </p>
     * 
     * @return Provides details for client authentication using SASL.
     */
    public final AwsMskClusterClusterInfoClientAuthenticationSaslDetails sasl() {
        return sasl;
    }

    /**
     * <p>
     * Provides details for allowing no client authentication.
     * </p>
     * 
     * @return Provides details for allowing no client authentication.
     */
    public final AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails unauthenticated() {
        return unauthenticated;
    }

    /**
     * <p>
     * Provides details for client authentication using TLS.
     * </p>
     * 
     * @return Provides details for client authentication using TLS.
     */
    public final AwsMskClusterClusterInfoClientAuthenticationTlsDetails tls() {
        return tls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sasl());
        hashCode = 31 * hashCode + Objects.hashCode(unauthenticated());
        hashCode = 31 * hashCode + Objects.hashCode(tls());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsMskClusterClusterInfoClientAuthenticationDetails)) {
            return false;
        }
        AwsMskClusterClusterInfoClientAuthenticationDetails other = (AwsMskClusterClusterInfoClientAuthenticationDetails) obj;
        return Objects.equals(sasl(), other.sasl()) && Objects.equals(unauthenticated(), other.unauthenticated())
                && Objects.equals(tls(), other.tls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsMskClusterClusterInfoClientAuthenticationDetails").add("Sasl", sasl())
                .add("Unauthenticated", unauthenticated()).add("Tls", tls()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Sasl":
            return Optional.ofNullable(clazz.cast(sasl()));
        case "Unauthenticated":
            return Optional.ofNullable(clazz.cast(unauthenticated()));
        case "Tls":
            return Optional.ofNullable(clazz.cast(tls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsMskClusterClusterInfoClientAuthenticationDetails, T> g) {
        return obj -> g.apply((AwsMskClusterClusterInfoClientAuthenticationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsMskClusterClusterInfoClientAuthenticationDetails> {
        /**
         * <p>
         * Provides details for client authentication using SASL.
         * </p>
         * 
         * @param sasl
         *        Provides details for client authentication using SASL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sasl(AwsMskClusterClusterInfoClientAuthenticationSaslDetails sasl);

        /**
         * <p>
         * Provides details for client authentication using SASL.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoClientAuthenticationSaslDetails.Builder} avoiding the need to create one
         * manually via {@link AwsMskClusterClusterInfoClientAuthenticationSaslDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsMskClusterClusterInfoClientAuthenticationSaslDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #sasl(AwsMskClusterClusterInfoClientAuthenticationSaslDetails)}.
         * 
         * @param sasl
         *        a consumer that will call methods on
         *        {@link AwsMskClusterClusterInfoClientAuthenticationSaslDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sasl(AwsMskClusterClusterInfoClientAuthenticationSaslDetails)
         */
        default Builder sasl(Consumer<AwsMskClusterClusterInfoClientAuthenticationSaslDetails.Builder> sasl) {
            return sasl(AwsMskClusterClusterInfoClientAuthenticationSaslDetails.builder().applyMutation(sasl).build());
        }

        /**
         * <p>
         * Provides details for allowing no client authentication.
         * </p>
         * 
         * @param unauthenticated
         *        Provides details for allowing no client authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unauthenticated(AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails unauthenticated);

        /**
         * <p>
         * Provides details for allowing no client authentication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.Builder} avoiding the need to
         * create one manually via {@link AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #unauthenticated(AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails)}.
         * 
         * @param unauthenticated
         *        a consumer that will call methods on
         *        {@link AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unauthenticated(AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails)
         */
        default Builder unauthenticated(
                Consumer<AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.Builder> unauthenticated) {
            return unauthenticated(AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.builder()
                    .applyMutation(unauthenticated).build());
        }

        /**
         * <p>
         * Provides details for client authentication using TLS.
         * </p>
         * 
         * @param tls
         *        Provides details for client authentication using TLS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tls(AwsMskClusterClusterInfoClientAuthenticationTlsDetails tls);

        /**
         * <p>
         * Provides details for client authentication using TLS.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoClientAuthenticationTlsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsMskClusterClusterInfoClientAuthenticationTlsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsMskClusterClusterInfoClientAuthenticationTlsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #tls(AwsMskClusterClusterInfoClientAuthenticationTlsDetails)}.
         * 
         * @param tls
         *        a consumer that will call methods on
         *        {@link AwsMskClusterClusterInfoClientAuthenticationTlsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tls(AwsMskClusterClusterInfoClientAuthenticationTlsDetails)
         */
        default Builder tls(Consumer<AwsMskClusterClusterInfoClientAuthenticationTlsDetails.Builder> tls) {
            return tls(AwsMskClusterClusterInfoClientAuthenticationTlsDetails.builder().applyMutation(tls).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsMskClusterClusterInfoClientAuthenticationSaslDetails sasl;

        private AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails unauthenticated;

        private AwsMskClusterClusterInfoClientAuthenticationTlsDetails tls;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsMskClusterClusterInfoClientAuthenticationDetails model) {
            sasl(model.sasl);
            unauthenticated(model.unauthenticated);
            tls(model.tls);
        }

        public final AwsMskClusterClusterInfoClientAuthenticationSaslDetails.Builder getSasl() {
            return sasl != null ? sasl.toBuilder() : null;
        }

        public final void setSasl(AwsMskClusterClusterInfoClientAuthenticationSaslDetails.BuilderImpl sasl) {
            this.sasl = sasl != null ? sasl.build() : null;
        }

        @Override
        public final Builder sasl(AwsMskClusterClusterInfoClientAuthenticationSaslDetails sasl) {
            this.sasl = sasl;
            return this;
        }

        public final AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.Builder getUnauthenticated() {
            return unauthenticated != null ? unauthenticated.toBuilder() : null;
        }

        public final void setUnauthenticated(
                AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails.BuilderImpl unauthenticated) {
            this.unauthenticated = unauthenticated != null ? unauthenticated.build() : null;
        }

        @Override
        public final Builder unauthenticated(AwsMskClusterClusterInfoClientAuthenticationUnauthenticatedDetails unauthenticated) {
            this.unauthenticated = unauthenticated;
            return this;
        }

        public final AwsMskClusterClusterInfoClientAuthenticationTlsDetails.Builder getTls() {
            return tls != null ? tls.toBuilder() : null;
        }

        public final void setTls(AwsMskClusterClusterInfoClientAuthenticationTlsDetails.BuilderImpl tls) {
            this.tls = tls != null ? tls.build() : null;
        }

        @Override
        public final Builder tls(AwsMskClusterClusterInfoClientAuthenticationTlsDetails tls) {
            this.tls = tls;
            return this;
        }

        @Override
        public AwsMskClusterClusterInfoClientAuthenticationDetails build() {
            return new AwsMskClusterClusterInfoClientAuthenticationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
