/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the entity that created the session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamAccessKeySessionContextSessionIssuer implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamAccessKeySessionContextSessionIssuer.Builder, AwsIamAccessKeySessionContextSessionIssuer> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsIamAccessKeySessionContextSessionIssuer::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrincipalId").getter(getter(AwsIamAccessKeySessionContextSessionIssuer::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsIamAccessKeySessionContextSessionIssuer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(AwsIamAccessKeySessionContextSessionIssuer::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(AwsIamAccessKeySessionContextSessionIssuer::userName))
            .setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            PRINCIPAL_ID_FIELD, ARN_FIELD, ACCOUNT_ID_FIELD, USER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String principalId;

    private final String arn;

    private final String accountId;

    private final String userName;

    private AwsIamAccessKeySessionContextSessionIssuer(BuilderImpl builder) {
        this.type = builder.type;
        this.principalId = builder.principalId;
        this.arn = builder.arn;
        this.accountId = builder.accountId;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * The type of principal (user, role, or group) that created the session.
     * </p>
     * 
     * @return The type of principal (user, role, or group) that created the session.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * The principal ID of the principal (user, role, or group) that created the session.
     * </p>
     * 
     * @return The principal ID of the principal (user, role, or group) that created the session.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The ARN of the session.
     * </p>
     * 
     * @return The ARN of the session.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The identifier of the Amazon Web Services account that created the session.
     * </p>
     * 
     * @return The identifier of the Amazon Web Services account that created the session.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The name of the principal that created the session.
     * </p>
     * 
     * @return The name of the principal that created the session.
     */
    public final String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamAccessKeySessionContextSessionIssuer)) {
            return false;
        }
        AwsIamAccessKeySessionContextSessionIssuer other = (AwsIamAccessKeySessionContextSessionIssuer) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(arn(), other.arn()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamAccessKeySessionContextSessionIssuer").add("Type", type())
                .add("PrincipalId", principalId()).add("Arn", arn()).add("AccountId", accountId()).add("UserName", userName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "PrincipalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsIamAccessKeySessionContextSessionIssuer, T> g) {
        return obj -> g.apply((AwsIamAccessKeySessionContextSessionIssuer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamAccessKeySessionContextSessionIssuer> {
        /**
         * <p>
         * The type of principal (user, role, or group) that created the session.
         * </p>
         * 
         * @param type
         *        The type of principal (user, role, or group) that created the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The principal ID of the principal (user, role, or group) that created the session.
         * </p>
         * 
         * @param principalId
         *        The principal ID of the principal (user, role, or group) that created the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The ARN of the session.
         * </p>
         * 
         * @param arn
         *        The ARN of the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The identifier of the Amazon Web Services account that created the session.
         * </p>
         * 
         * @param accountId
         *        The identifier of the Amazon Web Services account that created the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The name of the principal that created the session.
         * </p>
         * 
         * @param userName
         *        The name of the principal that created the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String principalId;

        private String arn;

        private String accountId;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamAccessKeySessionContextSessionIssuer model) {
            type(model.type);
            principalId(model.principalId);
            arn(model.arn);
            accountId(model.accountId);
            userName(model.userName);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public AwsIamAccessKeySessionContextSessionIssuer build() {
            return new AwsIamAccessKeySessionContextSessionIssuer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
